;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Bdb/emit.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  8 17:32:59 1998                          */
;*    Last change :  Sat Oct 10 14:49:35 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The emission of the Bdb identifier translation table.            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module bdb_emit
   (include "Ast/node.sch"
	    "Ast/unit.sch"
	    "Tools/location.sch")
   (import  tools_shape
	    tools_error
	    tools_misc
	    tools_location
	    type_env
	    type_cache
	    ast_sexp
	    ast_env
	    ast_ident
	    ast_unit
	    module_module
	    module_include
	    engine_param
	    cgen_prototype)
   (export (emit-bdb-info globals ::output-port)))

;*---------------------------------------------------------------------*/
;*    emit-bdb-info ...                                                */
;*---------------------------------------------------------------------*/
(define (emit-bdb-info globals port)
   ;; we save the output port
   (set! *c-port* port)
   ;; the declaration of the association table
   (newline port)
   (newline port)
   (fprint port "/* bdb association table */")
   (let ((global-table-name "__bdb_info"))
      (fprint port
	      #"static struct bdb_fun_info {\n"
	      #"   char *sname, *cname;\n"
	      #"} " global-table-name "[] = { "))
   ;; first we emit information about the module and the source files
   (fprint *c-port*
	   "   {\"" *module* "\", \""
	   (qualified-name (id->name
			    (unit-initializer-id
			     (unit-id (get-toplevel-unit))))
			   *module*)
	   "\" },")
   (for-each (lambda (src)
		(fprint *c-port* "   {\"" src "\", 0 },"))
	     *src-files*)
   (fprint *c-port*
	   "   { 0, (char *)"
	   (let ((loc (find-location *module-clause*)))
	      (if (location? loc)
		  (location-lnum loc)
		  "0"))
	   " },")
   ;; we start scanning the global functions
   (for-each (lambda (global)
		(enter-function (global-id global))
		(bdb-global-sfun! global)
		(leave-function))
	     globals)
   ;; and then the non function global variables.
   (for-each-global! (lambda (global)
			(if (and (or (and (eq? (global-module global) *module*)
					  (eq? (global-import global) 'export))
				     (>fx (global-occurrence global) 0))
				 (svar? (global-value global)))
			    (bdb-global-svar! global))))
   (fprint port #"   0};\n"))

;*---------------------------------------------------------------------*/
;*    bdb-global-sfun! ...                                             */
;*---------------------------------------------------------------------*/
(define (bdb-global-sfun! global)
   (let* ((sfun     (global-value global))
	  (sfun-loc (sfun-loc sfun))
	  (clo      (sfun-the-closure sfun)))
      (if (and (location? sfun-loc)
	       (global-user? global))
	  (begin
	     (set-variable-name! global)
	     (let ((fname    (location-fname sfun-loc))
		   (lnum     (location-lnum sfun-loc))
		   (id       (global-id global))
		   (val-name (if (global? clo)
				 (global-name clo)
				 0))
		   (bp-name  (global-name global)))
;* 		(fprint *c-port* "   {\"" fname "\", 0 },")            */
		(fprint *c-port* "   {\"" fname "\", (char *)" lnum " },")
		(fprint *c-port* "   {\"" id "\", 0},")
		(if (not (number? val-name))
		    (fprint *c-port* "   {\"" val-name "\", \"" bp-name "\"},")
		    (fprint *c-port* "   {" val-name ", \"" bp-name "\"},"))
		(bdb-sfun! sfun)
		(fprint *c-port* "     {0, 0},"))))))

;*---------------------------------------------------------------------*/
;*    bdb-global-svar! ...                                             */
;*---------------------------------------------------------------------*/
(define (bdb-global-svar! global)
   (let* ((svar     (global-value global))
	  (svar-loc (svar-loc svar)))
      (if (location? svar-loc)
	  (begin
	     (set-variable-name! global)
	     (let ((fname (location-fname svar-loc))
		   (lnum  (location-lnum svar-loc))
		   (id    (global-id global))
		   (name  (global-name global)))
		(fprint *c-port* "   {\"" fname "\", (char *)" lnum " },")
		(fprint *c-port* "   {\"" id "\", \"" name "\"},"))))))
   
;*---------------------------------------------------------------------*/
;*    bdb-sfun! ...                                                    */
;*---------------------------------------------------------------------*/
(define (bdb-sfun! sfun)
   (with-access::sfun sfun (args body)
      (for-each bdb-emit-local-info! args)
      (bdb! body)))

;*---------------------------------------------------------------------*/
;*    *c-port* ...                                                     */
;*---------------------------------------------------------------------*/
(define *c-port* #unspecified)

;*---------------------------------------------------------------------*/
;*    bdb-emit-local-info! ...                                         */
;*---------------------------------------------------------------------*/
(define (bdb-emit-local-info! local)
   (if (and (local-user? local) (eq? (type-class (local-type local)) 'bigloo))
       (begin
	  (set-variable-name! local)
	  (let ((id   (local-id local))
		(name (local-name local)))
	     (fprint *c-port* "     {\"" id "\", \"" name "\"},")))))
   
;*---------------------------------------------------------------------*/
;*    bdb! ...                                                         */
;*---------------------------------------------------------------------*/
(define-generic (bdb! node::node)
   #unspecified)
   
;*---------------------------------------------------------------------*/
;*    bdb! ::sequence ...                                              */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::sequence)
   (with-access::sequence node (nodes)
      (bdb*! nodes)))

;*---------------------------------------------------------------------*/
;*    bdb! ::pragma ...                                                */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::pragma)
   (with-access::pragma node (args)
      (bdb*! args)))

;*---------------------------------------------------------------------*/
;*    bdb! ::cast ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::cast)
   (with-access::cast node (arg)
      (bdb! arg)))

;*---------------------------------------------------------------------*/
;*    bdb! ::setq ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::setq)
   (with-access::setq node (value)
      (bdb! value)))

;*---------------------------------------------------------------------*/
;*    bdb! ::conditional ...                                           */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::conditional)
   (with-access::conditional node (test true false)
      (bdb! test)
      (bdb! true)
      (bdb! false)))

;*---------------------------------------------------------------------*/
;*    bdb! ::fail ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::fail)
   (with-access::fail node (proc msg obj)
      (bdb! proc)
      (bdb! msg)
      (bdb! obj)))

;*---------------------------------------------------------------------*/
;*    bdb! ::select ...                                                */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::select)
   (with-access::select node (clauses test)
      (bdb! test)
      (for-each (lambda (clause) (bdb! (cdr clause))) clauses)))

;*---------------------------------------------------------------------*/
;*    bdb! ::let-fun ...                                               */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each (lambda (local)
		   (bdb-sfun! (local-value local)))
		locals)
      (bdb! body)))

;*---------------------------------------------------------------------*/
;*    bdb! ::let-var ...                                               */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::let-var)
   (with-access::let-var node (body bindings)
       (for-each (lambda (binding)
		    (let ((var (car binding)))
		       (bdb! (cdr binding))
		       (bdb-emit-local-info! (car binding))))
		 bindings)
       (bdb! body)))
 
;*---------------------------------------------------------------------*/
;*    bdb! ::set-ex-it ...                                             */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::set-ex-it)
   (with-access::set-ex-it node (body)
      (bdb! body)))

;*---------------------------------------------------------------------*/
;*    bdb! ::jump-ex-it ...                                            */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (bdb! exit)
      (bdb! value)))

;*---------------------------------------------------------------------*/
;*    bdb! ::make-box ...                                              */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::make-box)
   (with-access::make-box node (value)
      (bdb! value)))

;*---------------------------------------------------------------------*/
;*    bdb! ::box-set! ...                                              */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::box-set!)
   (with-access::box-set! node (value)
      (bdb! value)))

;*---------------------------------------------------------------------*/
;*    bdb! ::app-ly ...                                                */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::app-ly)
   (with-access::app-ly node (fun arg)
      (bdb! fun)
      (bdb! arg)))

;*---------------------------------------------------------------------*/
;*    bdb! ::funcall ...                                               */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::funcall)
   (with-access::funcall node (fun args)
      (bdb! fun)
      (bdb*! args)))
		
;*---------------------------------------------------------------------*/
;*    bdb*! ...                                                        */
;*---------------------------------------------------------------------*/
(define (bdb*! nodes)
   (let loop ((hook nodes))
      (if (null? hook)
	  'done
	  (begin
	     (bdb! (car hook))
	     (loop (cdr hook))))))

;*---------------------------------------------------------------------*/
;*    bdb! ::app ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (bdb! node::app)
   (with-access::app node (args)
      (bdb*! args)))
	      
