;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/var.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May 30 15:12:51 1996                          */
;*    Last change :  Thu May 21 14:43:43 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The variable class definition                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_var

   (import engine_param
	   type_type)

   (export (class value)
	   
	   (class variable::object
	      ;; the variable identifier
	      (id::symbol read-only)
	      ;; the target name
	      (name (default #f))
	      ;; the variable type or the function type result
	      (type::type (default *_*))
	      ;; its type
	      value::value
	      ;; its access mode
	      (access (default 'read)
		      [assert (access) (memq access '(read
						      write
						      cell-callcc
						      cell-gobalize
						      cell-integrate))])
	      ;; a slot for fast alpha conversion
	      (fast-alpha (default #unspecified))
	      ;; does this variable can be removed
	      (removable (default 'now))
	      ;; the variable number of occurrences
	      (occurrence::long (default 0)))
	   
	   (final-class global::variable
	      ;; the global's module
	      (module::symbol read-only)
	      ;; the global's importation (is mutated in make_heap@heap_make)
	      (import [assert (import)
			      (memq import '(static export eval foreign))])
	      ;; is this global can be known by eval ?
	      (evaluable?::bool (default #t))
	      ;; is it a library variable ?
	      (library?::bool (default *lib-mode*))
	      ;; does this global variable belongs to the user ? this field
	      ;; is used mostly for default entry point of generic functions
	      ;; and unit initialization functions. the user? field is only
	      ;; used when compiling for -gbdb mode.
	      (user?::bool (default #t))
	      ;; a user pragma about the variable
	      (pragma::obj read-only (default '()))
	      ;; declaration source
	      src::obj)

	   (final-class local::variable
	      ;; does this local variable belongs to the user ?
	      (user?::bool (default #f))
	      ;; the local's identification key
	      (key::long read-only))

	   (class fun::value
	      ;; the function arity
	      (arity::long read-only)
	      ;; side effect field
	      (side-effect? (default #unspecified))
	      ;; if this function is a predicate, the type tested
	      (predicate-of (default #f))
	      ;; an associated stack allocator
	      (stack-allocator (default #f))
	      ;; is this function `top' its arguments (for the cfa)
	      (top?::bool (default #t))
	      ;; the associated closure
	      (the-closure (default #unspecified)))

	   (final-class sfun::fun
	      ;; a property list
	      (property::obj (default '()))
	      ;; the formals parameters
	      (args (default '()))
	      ;; the body
	      (body (default #unspecified))
	      ;; a class
	      (class [assert (class) (memq class '(sfun
						   sifun
						   snifun
						   sgfun
						   smfun))])
	      ;; dsssl keyword arguments encoding
	      (dsssl-keywords (default '()))
	      ;; the location, in the source file, of the function declaration.
	      ;; this field is not read-only because it will be set when
	      ;; encountering the global define which will occur after the
	      ;; global declaration (the module clause).
	      (loc (default #unspecified)))

	   (final-class cfun::fun
	      ;; the formal parameters' type
	      (args-type read-only)
	      ;; is it a macro function
	      (macro?::bool read-only)
	      ;; is it an infix macro ?
	      (infix?::bool (default #f)))

	   (final-class svar::value
	      ;; the location, in the source file, of the variable declaration
	      (loc (default #unspecified)))

	   (final-class scnst::value
	      ;; a possible variable value
	      (node read-only)
	      ;; a class
	      (class [assert (class) (memq class '(sgfun
						   sfun
						   sstring
						   sreal
						   stvector))])
	      ;; the location, in the source file, of the variable declaration
	      (loc (default #unspecified)))

	   (final-class cvar::value
	      ;; is it a macro variable
	      (macro?::bool read-only))

	   (final-class sexit::value
	      ;; the associated handling function
	      handler::obj
	      ;; is the handler detached (after globalize)
	      (detached?::bool (default #f)))))
