/*===========================================================================*/
/*   (Ast/remove.scm)                                                        */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>


/* Object type definitions */
typedef struct type
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     obj_t size;
     obj_t class;
     obj_t coerce_to_204;
     obj_t parents;
     bool_t init__47;
     bool_t magic__53;
     obj_t __57;
     obj_t alias;
     obj_t pointed_to_by_76;
     obj_t tvector;
  }
    *type_t;

typedef struct value
  {
     header_t header;
     obj_t widening;
  }
     *value_t;

typedef struct variable
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
  }
        *variable_t;

typedef struct global
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     obj_t module;
     obj_t import;
     bool_t evaluable__248;
     bool_t library__255;
     bool_t user__32;
     obj_t pragma;
     obj_t src;
  }
      *global_t;

typedef struct local
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     bool_t user__32;
     long key;
  }
     *local_t;

typedef struct fun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
  }
   *fun_t;

typedef struct sfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t property;
     obj_t args;
     obj_t body;
     obj_t class;
     obj_t dsssl_keywords_243;
     obj_t loc;
  }
    *sfun_t;

typedef struct cfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t args_type_205;
     bool_t macro__33;
     bool_t infix__163;
  }
    *cfun_t;

typedef struct svar
  {
     header_t header;
     obj_t widening;
     obj_t loc;
  }
    *svar_t;

typedef struct scnst
  {
     header_t header;
     obj_t widening;
     obj_t node;
     obj_t class;
     obj_t loc;
  }
     *scnst_t;

typedef struct cvar
  {
     header_t header;
     obj_t widening;
     bool_t macro__33;
  }
    *cvar_t;

typedef struct sexit
  {
     header_t header;
     obj_t widening;
     obj_t handler;
     bool_t detached__120;
  }
     *sexit_t;

typedef struct node
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
  }
    *node_t;

typedef struct node_effect_213
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
  }
               *node_effect_213_t;

typedef struct atom
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
    *atom_t;

typedef struct var
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
   *var_t;

typedef struct closure
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
       *closure_t;

typedef struct kwote
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
     *kwote_t;

typedef struct sequence
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t nodes;
  }
        *sequence_t;

typedef struct app
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *fun;
     obj_t args;
     obj_t stack_info_255;
  }
   *app_t;

typedef struct app_ly_162
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     struct node *arg;
  }
          *app_ly_162_t;

typedef struct funcall
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     obj_t args;
     obj_t strength;
  }
       *funcall_t;

typedef struct pragma
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t format;
     obj_t args;
  }
      *pragma_t;

typedef struct cast
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *arg;
  }
    *cast_t;

typedef struct setq
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
    *setq_t;

typedef struct conditional
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     struct node *true;
     struct node *false;
  }
           *conditional_t;

typedef struct fail
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *proc;
     struct node *msg;
     struct node *obj;
  }
    *fail_t;

typedef struct select
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     obj_t clauses;
     struct type *item_type_130;
  }
      *select_t;

typedef struct let_fun_218
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t locals;
     struct node *body;
  }
           *let_fun_218_t;

typedef struct let_var_6
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t bindings;
     struct node *body;
     bool_t removable__42;
  }
         *let_var_6_t;

typedef struct set_ex_it_116
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *body;
  }
             *set_ex_it_116_t;

typedef struct jump_ex_it_184
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *exit;
     struct node *value;
  }
              *jump_ex_it_184_t;

typedef struct make_box_202
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *value;
  }
            *make_box_202_t;

typedef struct box_ref_242
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *var;
  }
           *box_ref_242_t;

typedef struct box_set__221
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
            *box_set__221_t;


static obj_t method_init_76_ast_remove();
extern obj_t make_box_202_ast_node;
extern obj_t funcall_ast_node;
extern long add_inlined_method__244___object(obj_t, obj_t, long);
extern obj_t fail_ast_node;
static obj_t _remove_var_213_ast_remove(obj_t, obj_t, obj_t);
extern obj_t box_ref_242_ast_node;
extern obj_t sequence_ast_node;
extern obj_t let_var_6_ast_node;
extern obj_t var_ast_node;
extern obj_t pragma_ast_node;
extern obj_t set_ex_it_116_ast_node;
static node_t node_remove__162_ast_remove(node_t);
extern obj_t verbose_tools_speek(obj_t, obj_t);
extern bool_t is_a__118___object(obj_t, obj_t);
static obj_t _remove_var_from__39_ast_remove(obj_t, obj_t, obj_t);
extern obj_t module_initialization_70_ast_remove(long, char *);
extern obj_t module_initialization_70_type_type(long, char *);
extern obj_t module_initialization_70_ast_var(long, char *);
extern obj_t module_initialization_70_ast_node(long, char *);
extern obj_t module_initialization_70_tools_error(long, char *);
extern obj_t module_initialization_70_tools_speek(long, char *);
extern obj_t module_initialization_70_tools_shape(long, char *);
extern obj_t module_initialization_70_effect_effect(long, char *);
extern obj_t module_initialization_70_ast_occur(long, char *);
extern obj_t module_initialization_70___object(long, char *);
extern obj_t module_initialization_70___reader(long, char *);
extern obj_t module_initialization_70___r4_pairs_and_lists_6_3(long, char *);
extern obj_t module_initialization_70___r4_strings_6_7(long, char *);
extern obj_t remove_var_from__148_ast_remove(obj_t, variable_t);
extern obj_t let_fun_218_ast_node;
static obj_t imported_modules_init_94_ast_remove();
extern obj_t string_append_106___r4_strings_6_7(obj_t);
extern obj_t app_ly_162_ast_node;
extern obj_t add_generic__110___object(obj_t, obj_t);
static obj_t _node_remove__224_ast_remove(obj_t, obj_t);
static obj_t _node_remove__default1439_49_ast_remove(obj_t, obj_t);
extern obj_t app_ast_node;
static obj_t library_modules_init_112_ast_remove();
extern obj_t occur_var_108_ast_occur(obj_t);
extern obj_t atom_ast_node;
extern obj_t cast_ast_node;
static obj_t toplevel_init_63_ast_remove();
extern obj_t jump_ex_it_184_ast_node;
extern obj_t open_input_string(obj_t);
extern obj_t kwote_ast_node;
extern bool_t side_effect__165_effect_effect(node_t);
extern obj_t setq_ast_node;
static node_t node_remove__default1439_46_ast_remove(node_t);
extern obj_t box_set__221_ast_node;
extern obj_t memq___r4_pairs_and_lists_6_3(obj_t, obj_t);
extern obj_t shape_tools_shape(obj_t);
extern obj_t remove_var_123_ast_remove(obj_t, obj_t);
extern obj_t internal_error_43_tools_error(obj_t, obj_t, obj_t);
extern obj_t _classes__134___object;
extern obj_t select_ast_node;
extern obj_t read___reader(obj_t);
static obj_t require_initialization_114_ast_remove = BUNSPEC;
extern obj_t conditional_ast_node;
static obj_t node_remove___45_ast_remove(obj_t);
static obj_t cnst_init_137_ast_remove();
extern obj_t reverse__39___r4_pairs_and_lists_6_3(obj_t);
static obj_t __cnst[6];

DEFINE_STATIC_GENERIC(node_remove__env_197_ast_remove, _node_remove__224_ast_remove1790, _node_remove__224_ast_remove, 0L, 1);
DEFINE_EXPORT_PROCEDURE(remove_var_env_229_ast_remove, _remove_var_213_ast_remove1791, _remove_var_213_ast_remove, 0L, 2);
DEFINE_EXPORT_PROCEDURE(remove_var_from__env_82_ast_remove, _remove_var_from__39_ast_remove1792, _remove_var_from__39_ast_remove, 0L, 2);
DEFINE_STATIC_PROCEDURE(node_remove__default1439_env_28_ast_remove, _node_remove__default1439_49_ast_remove1793, _node_remove__default1439_49_ast_remove, 0L, 1);
DEFINE_STRING(string1783_ast_remove, string1783_ast_remove1794, "NODE-REMOVE!-DEFAULT1439 DONE NO-REMOVE EXPORT OK NOW ", 54);
DEFINE_STRING(string1782_ast_remove, string1782_ast_remove1795, "No method for this object", 25);
DEFINE_STRING(string1781_ast_remove, string1781_ast_remove1796, "        ", 8);
DEFINE_STRING(string1779_ast_remove, string1779_ast_remove1797, "         removing ", 18);
DEFINE_STRING(string1780_ast_remove, string1780_ast_remove1798, " removed", 8);
DEFINE_STRING(string1778_ast_remove, string1778_ast_remove1799, "already removable variable", 26);
DEFINE_STRING(string1777_ast_remove, string1777_ast_remove1800, "remove-var-from!", 16);
DEFINE_STRING(string1776_ast_remove, string1776_ast_remove1801, "/", 1);


/* module-initialization */ obj_t 
module_initialization_70_ast_remove(long checksum_1511, char *from_1512)
{
   if (CBOOL(require_initialization_114_ast_remove))
     {
	require_initialization_114_ast_remove = BBOOL(((bool_t) 0));
	library_modules_init_112_ast_remove();
	cnst_init_137_ast_remove();
	imported_modules_init_94_ast_remove();
	method_init_76_ast_remove();
	toplevel_init_63_ast_remove();
	return BUNSPEC;
     }
   else
     {
	return BUNSPEC;
     }
}


/* library-modules-init */ obj_t 
library_modules_init_112_ast_remove()
{
   module_initialization_70___object(((long) 0), "AST_REMOVE");
   module_initialization_70___r4_strings_6_7(((long) 0), "AST_REMOVE");
   module_initialization_70___r4_pairs_and_lists_6_3(((long) 0), "AST_REMOVE");
   module_initialization_70___reader(((long) 0), "AST_REMOVE");
   return BUNSPEC;
}


/* cnst-init */ obj_t 
cnst_init_137_ast_remove()
{
   {
      obj_t cnst_port_138_1503;
      cnst_port_138_1503 = open_input_string(string1783_ast_remove);
      {
	 long i_1504;
	 i_1504 = ((long) 5);
       loop_1505:
	 {
	    bool_t test1784_1506;
	    test1784_1506 = (i_1504 == ((long) -1));
	    if (test1784_1506)
	      {
		 return BUNSPEC;
	      }
	    else
	      {
		 {
		    obj_t arg1786_1507;
		    {
		       obj_t list1787_1508;
		       {
			  obj_t arg1788_1509;
			  arg1788_1509 = BNIL;
			  list1787_1508 = MAKE_PAIR(cnst_port_138_1503, arg1788_1509);
		       }
		       arg1786_1507 = read___reader(list1787_1508);
		    }
		    CNST_TABLE_SET(i_1504, arg1786_1507);
		 }
		 {
		    int aux_1510;
		    {
		       long aux_1531;
		       aux_1531 = (i_1504 - ((long) 1));
		       aux_1510 = (int) (aux_1531);
		    }
		    {
		       long i_1534;
		       i_1534 = (long) (aux_1510);
		       i_1504 = i_1534;
		       goto loop_1505;
		    }
		 }
	      }
	 }
      }
   }
}


/* toplevel-init */ obj_t 
toplevel_init_63_ast_remove()
{
   return BUNSPEC;
}


/* remove-var-from! */ obj_t 
remove_var_from__148_ast_remove(obj_t pass_1, variable_t var_2)
{
   {
      obj_t old_719;
      old_719 = (((variable_t) CREF(var_2))->removable);
      {
	 bool_t test_1537;
	 {
	    obj_t aux_1538;
	    aux_1538 = CNST_TABLE_REF(((long) 0));
	    test_1537 = (old_719 == aux_1538);
	 }
	 if (test_1537)
	   {
	      {
		 global_t obj_1275;
		 obj_1275 = (global_t) (var_2);
		 return ((((global_t) CREF(obj_1275))->removable) = ((obj_t) pass_1), BUNSPEC);
	      }
	   }
	 else
	   {
	      if ((old_719 == pass_1))
		{
		   return CNST_TABLE_REF(((long) 1));
		}
	      else
		{
		   bool_t test_1546;
		   {
		      obj_t aux_1547;
		      aux_1547 = CNST_TABLE_REF(((long) 0));
		      test_1546 = (pass_1 == aux_1547);
		   }
		   if (test_1546)
		     {
			return CNST_TABLE_REF(((long) 1));
		     }
		   else
		     {
			{
			   obj_t arg1465_725;
			   {
			      obj_t arg1466_726;
			      obj_t arg1468_728;
			      arg1466_726 = SYMBOL_TO_STRING(old_719);
			      arg1468_728 = SYMBOL_TO_STRING(pass_1);
			      {
				 obj_t list1469_729;
				 {
				    obj_t arg1470_730;
				    {
				       obj_t arg1471_731;
				       arg1471_731 = MAKE_PAIR(arg1468_728, BNIL);
				       arg1470_730 = MAKE_PAIR(string1776_ast_remove, arg1471_731);
				    }
				    list1469_729 = MAKE_PAIR(arg1466_726, arg1470_730);
				 }
				 arg1465_725 = string_append_106___r4_strings_6_7(list1469_729);
			      }
			   }
			   return internal_error_43_tools_error(string1777_ast_remove, string1778_ast_remove, arg1465_725);
			}
		     }
		}
	   }
      }
   }
}


/* _remove-var-from! */ obj_t 
_remove_var_from__39_ast_remove(obj_t env_1493, obj_t pass_1494, obj_t var_1495)
{
   return remove_var_from__148_ast_remove(pass_1494, (variable_t) (var_1495));
}


/* remove-var */ obj_t 
remove_var_123_ast_remove(obj_t pass_3, obj_t globals_4)
{
   occur_var_108_ast_occur(globals_4);
   {
      obj_t globals_735;
      obj_t res_736;
      globals_735 = globals_4;
      res_736 = BNIL;
    loop_737:
      if (NULLP(globals_735))
	{
	   return reverse__39___r4_pairs_and_lists_6_3(res_736);
	}
      else
	{
	   obj_t global_740;
	   global_740 = CAR(globals_735);
	   {
	      bool_t test_1565;
	      {
		 obj_t aux_1569;
		 obj_t aux_1566;
		 aux_1569 = CNST_TABLE_REF(((long) 2));
		 {
		    global_t obj_1285;
		    obj_1285 = (global_t) (global_740);
		    aux_1566 = (((global_t) CREF(obj_1285))->import);
		 }
		 test_1565 = (aux_1566 == aux_1569);
	      }
	      if (test_1565)
		{
		   {
		      value_t sfun_742;
		      {
			 global_t obj_1288;
			 obj_1288 = (global_t) (global_740);
			 sfun_742 = (((global_t) CREF(obj_1288))->value);
		      }
		      {
			 node_t arg1479_743;
			 {
			    node_t aux_1574;
			    {
			       obj_t aux_1575;
			       {
				  sfun_t obj_1289;
				  obj_1289 = (sfun_t) (sfun_742);
				  aux_1575 = (((sfun_t) CREF(obj_1289))->body);
			       }
			       aux_1574 = (node_t) (aux_1575);
			    }
			    arg1479_743 = node_remove__162_ast_remove(aux_1574);
			 }
			 {
			    sfun_t obj_1290;
			    obj_t val1135_1291;
			    obj_1290 = (sfun_t) (sfun_742);
			    val1135_1291 = (obj_t) (arg1479_743);
			    ((((sfun_t) CREF(obj_1290))->body) = ((obj_t) val1135_1291), BUNSPEC);
			 }
		      }
		   }
		   {
		      obj_t arg1481_745;
		      obj_t arg1483_746;
		      arg1481_745 = CDR(globals_735);
		      arg1483_746 = MAKE_PAIR(global_740, res_736);
		      {
			 obj_t res_1586;
			 obj_t globals_1585;
			 globals_1585 = arg1481_745;
			 res_1586 = arg1483_746;
			 res_736 = res_1586;
			 globals_735 = globals_1585;
			 goto loop_737;
		      }
		   }
		}
	      else
		{
		   bool_t test_1587;
		   {
		      bool_t test_1588;
		      {
			 obj_t aux_1589;
			 {
			    global_t obj_1295;
			    obj_1295 = (global_t) (global_740);
			    aux_1589 = (((global_t) CREF(obj_1295))->removable);
			 }
			 test_1588 = (aux_1589 == pass_3);
		      }
		      if (test_1588)
			{
			   test_1587 = ((bool_t) 1);
			}
		      else
			{
			   obj_t aux_1593;
			   {
			      obj_t aux_1594;
			      {
				 global_t obj_1298;
				 obj_1298 = (global_t) (global_740);
				 aux_1594 = (((global_t) CREF(obj_1298))->removable);
			      }
			      aux_1593 = memq___r4_pairs_and_lists_6_3(aux_1594, pass_3);
			   }
			   test_1587 = CBOOL(aux_1593);
			}
		   }
		   if (test_1587)
		     {
			{
			   bool_t test_1599;
			   {
			      long aux_1600;
			      {
				 global_t obj_1299;
				 obj_1299 = (global_t) (global_740);
				 aux_1600 = (((global_t) CREF(obj_1299))->occurrence);
			      }
			      test_1599 = (aux_1600 <= ((long) 0));
			   }
			   if (test_1599)
			     {
				{
				   obj_t arg1488_751;
				   arg1488_751 = shape_tools_shape(global_740);
				   {
				      obj_t list1489_752;
				      {
					 obj_t arg1490_753;
					 {
					    obj_t arg1491_754;
					    {
					       obj_t aux_1605;
					       aux_1605 = BCHAR(((unsigned char) '\n'));
					       arg1491_754 = MAKE_PAIR(aux_1605, BNIL);
					    }
					    arg1490_753 = MAKE_PAIR(arg1488_751, arg1491_754);
					 }
					 list1489_752 = MAKE_PAIR(string1779_ast_remove, arg1490_753);
				      }
				      verbose_tools_speek(BINT(((long) 3)), list1489_752);
				   }
				}
				{
				   obj_t globals_1612;
				   globals_1612 = CDR(globals_735);
				   globals_735 = globals_1612;
				   goto loop_737;
				}
			     }
			   else
			     {
				value_t sfun_757;
				{
				   global_t obj_1303;
				   obj_1303 = (global_t) (global_740);
				   sfun_757 = (((global_t) CREF(obj_1303))->value);
				}
				{
				   obj_t arg1497_758;
				   arg1497_758 = CNST_TABLE_REF(((long) 0));
				   {
				      global_t obj_1304;
				      obj_1304 = (global_t) (global_740);
				      ((((global_t) CREF(obj_1304))->removable) = ((obj_t) arg1497_758), BUNSPEC);
				   }
				}
				{
				   node_t arg1498_759;
				   {
				      node_t aux_1619;
				      {
					 obj_t aux_1620;
					 {
					    sfun_t obj_1306;
					    obj_1306 = (sfun_t) (sfun_757);
					    aux_1620 = (((sfun_t) CREF(obj_1306))->body);
					 }
					 aux_1619 = (node_t) (aux_1620);
				      }
				      arg1498_759 = node_remove__162_ast_remove(aux_1619);
				   }
				   {
				      sfun_t obj_1307;
				      obj_t val1135_1308;
				      obj_1307 = (sfun_t) (sfun_757);
				      val1135_1308 = (obj_t) (arg1498_759);
				      ((((sfun_t) CREF(obj_1307))->body) = ((obj_t) val1135_1308), BUNSPEC);
				   }
				}
				{
				   obj_t arg1500_761;
				   obj_t arg1501_762;
				   arg1500_761 = CDR(globals_735);
				   arg1501_762 = MAKE_PAIR(global_740, res_736);
				   {
				      obj_t res_1631;
				      obj_t globals_1630;
				      globals_1630 = arg1500_761;
				      res_1631 = arg1501_762;
				      res_736 = res_1631;
				      globals_735 = globals_1630;
				      goto loop_737;
				   }
				}
			     }
			}
		     }
		   else
		     {
			bool_t test_1632;
			{
			   bool_t test_1633;
			   {
			      long aux_1634;
			      {
				 global_t obj_1312;
				 obj_1312 = (global_t) (global_740);
				 aux_1634 = (((global_t) CREF(obj_1312))->occurrence);
			      }
			      test_1633 = (aux_1634 <= ((long) 0));
			   }
			   if (test_1633)
			     {
				bool_t test_1638;
				{
				   obj_t aux_1642;
				   obj_t aux_1639;
				   aux_1642 = CNST_TABLE_REF(((long) 0));
				   {
				      global_t obj_1315;
				      obj_1315 = (global_t) (global_740);
				      aux_1639 = (((global_t) CREF(obj_1315))->removable);
				   }
				   test_1638 = (aux_1639 == aux_1642);
				}
				if (test_1638)
				  {
				     bool_t test_1645;
				     {
					obj_t aux_1646;
					aux_1646 = CNST_TABLE_REF(((long) 3));
					test_1645 = (pass_3 == aux_1646);
				     }
				     if (test_1645)
				       {
					  test_1632 = ((bool_t) 0);
				       }
				     else
				       {
					  test_1632 = ((bool_t) 1);
				       }
				  }
				else
				  {
				     test_1632 = ((bool_t) 0);
				  }
			     }
			   else
			     {
				test_1632 = ((bool_t) 0);
			     }
			}
			if (test_1632)
			  {
			     {
				obj_t arg1510_768;
				arg1510_768 = shape_tools_shape(global_740);
				{
				   obj_t list1512_770;
				   {
				      obj_t arg1513_771;
				      {
					 obj_t arg1514_772;
					 {
					    obj_t arg1515_773;
					    {
					       obj_t aux_1650;
					       aux_1650 = BCHAR(((unsigned char) '\n'));
					       arg1515_773 = MAKE_PAIR(aux_1650, BNIL);
					    }
					    arg1514_772 = MAKE_PAIR(string1780_ast_remove, arg1515_773);
					 }
					 arg1513_771 = MAKE_PAIR(arg1510_768, arg1514_772);
				      }
				      list1512_770 = MAKE_PAIR(string1781_ast_remove, arg1513_771);
				   }
				   verbose_tools_speek(BINT(((long) 3)), list1512_770);
				}
			     }
			     {
				obj_t globals_1658;
				globals_1658 = CDR(globals_735);
				globals_735 = globals_1658;
				goto loop_737;
			     }
			  }
			else
			  {
			     {
				value_t sfun_776;
				{
				   global_t obj_1321;
				   obj_1321 = (global_t) (global_740);
				   sfun_776 = (((global_t) CREF(obj_1321))->value);
				}
				{
				   node_t arg1518_777;
				   {
				      node_t aux_1662;
				      {
					 obj_t aux_1663;
					 {
					    sfun_t obj_1322;
					    obj_1322 = (sfun_t) (sfun_776);
					    aux_1663 = (((sfun_t) CREF(obj_1322))->body);
					 }
					 aux_1662 = (node_t) (aux_1663);
				      }
				      arg1518_777 = node_remove__162_ast_remove(aux_1662);
				   }
				   {
				      sfun_t obj_1323;
				      obj_t val1135_1324;
				      obj_1323 = (sfun_t) (sfun_776);
				      val1135_1324 = (obj_t) (arg1518_777);
				      ((((sfun_t) CREF(obj_1323))->body) = ((obj_t) val1135_1324), BUNSPEC);
				   }
				}
				{
				   obj_t arg1522_779;
				   obj_t arg1524_780;
				   arg1522_779 = CDR(globals_735);
				   arg1524_780 = MAKE_PAIR(global_740, res_736);
				   {
				      obj_t res_1674;
				      obj_t globals_1673;
				      globals_1673 = arg1522_779;
				      res_1674 = arg1524_780;
				      res_736 = res_1674;
				      globals_735 = globals_1673;
				      goto loop_737;
				   }
				}
			     }
			  }
		     }
		}
	   }
	}
   }
}


/* _remove-var */ obj_t 
_remove_var_213_ast_remove(obj_t env_1496, obj_t pass_1497, obj_t globals_1498)
{
   return remove_var_123_ast_remove(pass_1497, globals_1498);
}


/* node-remove*! */ obj_t 
node_remove___45_ast_remove(obj_t node__221_27)
{
 node_remove___45_ast_remove:
   if (NULLP(node__221_27))
     {
	return CNST_TABLE_REF(((long) 4));
     }
   else
     {
	{
	   node_t arg1539_795;
	   {
	      node_t aux_1679;
	      {
		 obj_t aux_1680;
		 aux_1680 = CAR(node__221_27);
		 aux_1679 = (node_t) (aux_1680);
	      }
	      arg1539_795 = node_remove__162_ast_remove(aux_1679);
	   }
	   {
	      obj_t aux_1684;
	      aux_1684 = (obj_t) (arg1539_795);
	      SET_CAR(node__221_27, aux_1684);
	   }
	}
	{
	   obj_t node__221_1687;
	   node__221_1687 = CDR(node__221_27);
	   node__221_27 = node__221_1687;
	   goto node_remove___45_ast_remove;
	}
     }
}


/* method-init */ obj_t 
method_init_76_ast_remove()
{
   add_generic__110___object(node_remove__env_197_ast_remove, node_remove__default1439_env_28_ast_remove);
   add_inlined_method__244___object(node_remove__env_197_ast_remove, atom_ast_node, ((long) 0));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, var_ast_node, ((long) 1));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, kwote_ast_node, ((long) 2));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, sequence_ast_node, ((long) 3));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, app_ast_node, ((long) 4));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, app_ly_162_ast_node, ((long) 5));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, funcall_ast_node, ((long) 6));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, pragma_ast_node, ((long) 7));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, cast_ast_node, ((long) 8));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, setq_ast_node, ((long) 9));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, conditional_ast_node, ((long) 10));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, fail_ast_node, ((long) 11));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, select_ast_node, ((long) 12));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, make_box_202_ast_node, ((long) 13));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, box_ref_242_ast_node, ((long) 14));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, box_set__221_ast_node, ((long) 15));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, let_fun_218_ast_node, ((long) 16));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, let_var_6_ast_node, ((long) 17));
   add_inlined_method__244___object(node_remove__env_197_ast_remove, set_ex_it_116_ast_node, ((long) 18));
   {
      long aux_1709;
      aux_1709 = add_inlined_method__244___object(node_remove__env_197_ast_remove, jump_ex_it_184_ast_node, ((long) 19));
      return BINT(aux_1709);
   }
}


/* node-remove! */ node_t 
node_remove__162_ast_remove(node_t node_5)
{
   {
      obj_t method1646_1129;
      obj_t class1651_1130;
      {
	 obj_t arg1654_1127;
	 obj_t arg1655_1128;
	 {
	    object_t obj_1333;
	    obj_1333 = (object_t) (node_5);
	    {
	       obj_t pre_method_105_1334;
	       pre_method_105_1334 = PROCEDURE_REF(node_remove__env_197_ast_remove, ((long) 2));
	       if (INTEGERP(pre_method_105_1334))
		 {
		    PROCEDURE_SET(node_remove__env_197_ast_remove, ((long) 2), BUNSPEC);
		    arg1654_1127 = pre_method_105_1334;
		 }
	       else
		 {
		    long obj_class_num_177_1339;
		    obj_class_num_177_1339 = TYPE(obj_1333);
		    {
		       obj_t arg1177_1340;
		       arg1177_1340 = PROCEDURE_REF(node_remove__env_197_ast_remove, ((long) 1));
		       {
			  long arg1178_1344;
			  {
			     long arg1179_1345;
			     arg1179_1345 = OBJECT_TYPE;
			     arg1178_1344 = (obj_class_num_177_1339 - arg1179_1345);
			  }
			  arg1654_1127 = VECTOR_REF(arg1177_1340, arg1178_1344);
		       }
		    }
		 }
	    }
	 }
	 {
	    object_t object_1350;
	    object_1350 = (object_t) (node_5);
	    {
	       long arg1180_1351;
	       {
		  long arg1181_1352;
		  long arg1182_1353;
		  arg1181_1352 = TYPE(object_1350);
		  arg1182_1353 = OBJECT_TYPE;
		  arg1180_1351 = (arg1181_1352 - arg1182_1353);
	       }
	       {
		  obj_t vector_1357;
		  vector_1357 = _classes__134___object;
		  arg1655_1128 = VECTOR_REF(vector_1357, arg1180_1351);
	       }
	    }
	 }
	 {
	    obj_t aux_1727;
	    method1646_1129 = arg1654_1127;
	    class1651_1130 = arg1655_1128;
	    {
	       if (INTEGERP(method1646_1129))
		 {
		    switch ((long) CINT(method1646_1129))
		      {
		      case ((long) 0):
			 {
			    atom_t aux_1730;
			    aux_1730 = (atom_t) (node_5);
			    aux_1727 = (obj_t) (aux_1730);
			 }
			 break;
		      case ((long) 1):
			 {
			    var_t aux_1733;
			    aux_1733 = (var_t) (node_5);
			    aux_1727 = (obj_t) (aux_1733);
			 }
			 break;
		      case ((long) 2):
			 {
			    kwote_t aux_1736;
			    aux_1736 = (kwote_t) (node_5);
			    aux_1727 = (obj_t) (aux_1736);
			 }
			 break;
		      case ((long) 3):
			 {
			    sequence_t node_1139;
			    node_1139 = (sequence_t) (node_5);
			    node_remove___45_ast_remove((((sequence_t) CREF(node_1139))->nodes));
			    aux_1727 = (obj_t) (node_1139);
			 }
			 break;
		      case ((long) 4):
			 {
			    app_t node_1141;
			    node_1141 = (app_t) (node_5);
			    {
			       node_t arg1659_1142;
			       {
				  node_t aux_1744;
				  {
				     var_t aux_1745;
				     aux_1745 = (((app_t) CREF(node_1141))->fun);
				     aux_1744 = (node_t) (aux_1745);
				  }
				  arg1659_1142 = node_remove__162_ast_remove(aux_1744);
			       }
			       {
				  var_t val1252_1362;
				  val1252_1362 = (var_t) (arg1659_1142);
				  ((((app_t) CREF(node_1141))->fun) = ((var_t) val1252_1362), BUNSPEC);
			       }
			    }
			    node_remove___45_ast_remove((((app_t) CREF(node_1141))->args));
			    aux_1727 = (obj_t) (node_1141);
			 }
			 break;
		      case ((long) 5):
			 {
			    app_ly_162_t node_1145;
			    node_1145 = (app_ly_162_t) (node_5);
			    {
			       node_t arg1665_1146;
			       arg1665_1146 = node_remove__162_ast_remove((((app_ly_162_t) CREF(node_1145))->fun));
			       ((((app_ly_162_t) CREF(node_1145))->fun) = ((node_t) arg1665_1146), BUNSPEC);
			    }
			    {
			       node_t arg1667_1148;
			       arg1667_1148 = node_remove__162_ast_remove((((app_ly_162_t) CREF(node_1145))->arg));
			       ((((app_ly_162_t) CREF(node_1145))->arg) = ((node_t) arg1667_1148), BUNSPEC);
			    }
			    aux_1727 = (obj_t) (node_1145);
			 }
			 break;
		      case ((long) 6):
			 {
			    funcall_t node_1150;
			    node_1150 = (funcall_t) (node_5);
			    {
			       node_t arg1669_1151;
			       arg1669_1151 = node_remove__162_ast_remove((((funcall_t) CREF(node_1150))->fun));
			       ((((funcall_t) CREF(node_1150))->fun) = ((node_t) arg1669_1151), BUNSPEC);
			    }
			    node_remove___45_ast_remove((((funcall_t) CREF(node_1150))->args));
			    aux_1727 = (obj_t) (node_1150);
			 }
			 break;
		      case ((long) 7):
			 {
			    pragma_t node_1154;
			    node_1154 = (pragma_t) (node_5);
			    node_remove___45_ast_remove((((pragma_t) CREF(node_1154))->args));
			    aux_1727 = (obj_t) (node_1154);
			 }
			 break;
		      case ((long) 8):
			 {
			    cast_t node_1156;
			    node_1156 = (cast_t) (node_5);
			    node_remove__162_ast_remove((((cast_t) CREF(node_1156))->arg));
			    aux_1727 = (obj_t) (node_1156);
			 }
			 break;
		      case ((long) 9):
			 {
			    setq_t node_1158;
			    node_1158 = (setq_t) (node_5);
			    {
			       node_t arg1676_1159;
			       arg1676_1159 = node_remove__162_ast_remove((((setq_t) CREF(node_1158))->value));
			       ((((setq_t) CREF(node_1158))->value) = ((node_t) arg1676_1159), BUNSPEC);
			    }
			    aux_1727 = (obj_t) (node_1158);
			 }
			 break;
		      case ((long) 10):
			 {
			    conditional_t node_1161;
			    node_1161 = (conditional_t) (node_5);
			    {
			       node_t arg1678_1162;
			       arg1678_1162 = node_remove__162_ast_remove((((conditional_t) CREF(node_1161))->test));
			       ((((conditional_t) CREF(node_1161))->test) = ((node_t) arg1678_1162), BUNSPEC);
			    }
			    {
			       node_t arg1680_1164;
			       arg1680_1164 = node_remove__162_ast_remove((((conditional_t) CREF(node_1161))->true));
			       ((((conditional_t) CREF(node_1161))->true) = ((node_t) arg1680_1164), BUNSPEC);
			    }
			    {
			       node_t arg1682_1166;
			       arg1682_1166 = node_remove__162_ast_remove((((conditional_t) CREF(node_1161))->false));
			       ((((conditional_t) CREF(node_1161))->false) = ((node_t) arg1682_1166), BUNSPEC);
			    }
			    aux_1727 = (obj_t) (node_1161);
			 }
			 break;
		      case ((long) 11):
			 {
			    fail_t node_1168;
			    node_1168 = (fail_t) (node_5);
			    {
			       node_t arg1684_1169;
			       arg1684_1169 = node_remove__162_ast_remove((((fail_t) CREF(node_1168))->proc));
			       ((((fail_t) CREF(node_1168))->proc) = ((node_t) arg1684_1169), BUNSPEC);
			    }
			    {
			       node_t arg1686_1171;
			       arg1686_1171 = node_remove__162_ast_remove((((fail_t) CREF(node_1168))->msg));
			       ((((fail_t) CREF(node_1168))->msg) = ((node_t) arg1686_1171), BUNSPEC);
			    }
			    {
			       node_t arg1689_1173;
			       arg1689_1173 = node_remove__162_ast_remove((((fail_t) CREF(node_1168))->obj));
			       ((((fail_t) CREF(node_1168))->obj) = ((node_t) arg1689_1173), BUNSPEC);
			    }
			    aux_1727 = (obj_t) (node_1168);
			 }
			 break;
		      case ((long) 12):
			 {
			    select_t node_1175;
			    node_1175 = (select_t) (node_5);
			    {
			       node_t arg1692_1176;
			       arg1692_1176 = node_remove__162_ast_remove((((select_t) CREF(node_1175))->test));
			       ((((select_t) CREF(node_1175))->test) = ((node_t) arg1692_1176), BUNSPEC);
			    }
			    {
			       obj_t l1435_1178;
			       l1435_1178 = (((select_t) CREF(node_1175))->clauses);
			     lname1436_1179:
			       if (PAIRP(l1435_1178))
				 {
				    {
				       obj_t clause_1182;
				       clause_1182 = CAR(l1435_1178);
				       {
					  node_t arg1697_1183;
					  {
					     node_t aux_1811;
					     {
						obj_t aux_1812;
						aux_1812 = CDR(clause_1182);
						aux_1811 = (node_t) (aux_1812);
					     }
					     arg1697_1183 = node_remove__162_ast_remove(aux_1811);
					  }
					  {
					     obj_t aux_1816;
					     aux_1816 = (obj_t) (arg1697_1183);
					     SET_CDR(clause_1182, aux_1816);
					  }
				       }
				    }
				    {
				       obj_t l1435_1819;
				       l1435_1819 = CDR(l1435_1178);
				       l1435_1178 = l1435_1819;
				       goto lname1436_1179;
				    }
				 }
			       else
				 {
				    ((bool_t) 1);
				 }
			    }
			    aux_1727 = (obj_t) (node_1175);
			 }
			 break;
		      case ((long) 13):
			 {
			    make_box_202_t node_1186;
			    node_1186 = (make_box_202_t) (node_5);
			    {
			       node_t arg1700_1187;
			       arg1700_1187 = node_remove__162_ast_remove((((make_box_202_t) CREF(node_1186))->value));
			       ((((make_box_202_t) CREF(node_1186))->value) = ((node_t) arg1700_1187), BUNSPEC);
			    }
			    aux_1727 = (obj_t) (node_1186);
			 }
			 break;
		      case ((long) 14):
			 {
			    box_ref_242_t node_1189;
			    node_1189 = (box_ref_242_t) (node_5);
			    {
			       node_t arg1702_1190;
			       {
				  node_t aux_1829;
				  {
				     var_t aux_1830;
				     aux_1830 = (((box_ref_242_t) CREF(node_1189))->var);
				     aux_1829 = (node_t) (aux_1830);
				  }
				  arg1702_1190 = node_remove__162_ast_remove(aux_1829);
			       }
			       {
				  var_t val1423_1412;
				  val1423_1412 = (var_t) (arg1702_1190);
				  ((((box_ref_242_t) CREF(node_1189))->var) = ((var_t) val1423_1412), BUNSPEC);
			       }
			    }
			    aux_1727 = (obj_t) (node_1189);
			 }
			 break;
		      case ((long) 15):
			 {
			    box_set__221_t node_1192;
			    node_1192 = (box_set__221_t) (node_5);
			    {
			       node_t arg1704_1193;
			       {
				  node_t aux_1838;
				  {
				     var_t aux_1839;
				     aux_1839 = (((box_set__221_t) CREF(node_1192))->var);
				     aux_1838 = (node_t) (aux_1839);
				  }
				  arg1704_1193 = node_remove__162_ast_remove(aux_1838);
			       }
			       {
				  var_t val1432_1415;
				  val1432_1415 = (var_t) (arg1704_1193);
				  ((((box_set__221_t) CREF(node_1192))->var) = ((var_t) val1432_1415), BUNSPEC);
			       }
			    }
			    {
			       node_t arg1706_1195;
			       arg1706_1195 = node_remove__162_ast_remove((((box_set__221_t) CREF(node_1192))->value));
			       ((((box_set__221_t) CREF(node_1192))->value) = ((node_t) arg1706_1195), BUNSPEC);
			    }
			    aux_1727 = (obj_t) (node_1192);
			 }
			 break;
		      case ((long) 16):
			 {
			    let_fun_218_t node_1197;
			    node_1197 = (let_fun_218_t) (node_5);
			    {
			       node_t arg1708_1199;
			       arg1708_1199 = node_remove__162_ast_remove((((let_fun_218_t) CREF(node_1197))->body));
			       ((((let_fun_218_t) CREF(node_1197))->body) = ((node_t) arg1708_1199), BUNSPEC);
			    }
			    {
			       obj_t old_locals_255_1201;
			       obj_t new_locals_179_1202;
			       old_locals_255_1201 = (((let_fun_218_t) CREF(node_1197))->locals);
			       new_locals_179_1202 = BNIL;
			     loop_1203:
			       if (NULLP(old_locals_255_1201))
				 {
				    if (NULLP(new_locals_179_1202))
				      {
					 node_t aux_1857;
					 aux_1857 = (((let_fun_218_t) CREF(node_1197))->body);
					 aux_1727 = (obj_t) (aux_1857);
				      }
				    else
				      {
					 {
					    obj_t arg1714_1208;
					    arg1714_1208 = reverse__39___r4_pairs_and_lists_6_3(new_locals_179_1202);
					    ((((let_fun_218_t) CREF(node_1197))->locals) = ((obj_t) arg1714_1208), BUNSPEC);
					 }
					 aux_1727 = (obj_t) (node_1197);
				      }
				 }
			       else
				 {
				    obj_t local_1209;
				    local_1209 = CAR(old_locals_255_1201);
				    {
				       bool_t test_1864;
				       {
					  long aux_1865;
					  {
					     local_t obj_1429;
					     obj_1429 = (local_t) (local_1209);
					     aux_1865 = (((local_t) CREF(obj_1429))->occurrence);
					  }
					  test_1864 = (aux_1865 <= ((long) 0));
				       }
				       if (test_1864)
					 {
					    obj_t old_locals_255_1869;
					    old_locals_255_1869 = CDR(old_locals_255_1201);
					    old_locals_255_1201 = old_locals_255_1869;
					    goto loop_1203;
					 }
				       else
					 {
					    value_t sfun_1212;
					    {
					       local_t obj_1433;
					       obj_1433 = (local_t) (local_1209);
					       sfun_1212 = (((local_t) CREF(obj_1433))->value);
					    }
					    {
					       node_t arg1717_1213;
					       {
						  node_t aux_1873;
						  {
						     obj_t aux_1874;
						     {
							sfun_t obj_1434;
							obj_1434 = (sfun_t) (sfun_1212);
							aux_1874 = (((sfun_t) CREF(obj_1434))->body);
						     }
						     aux_1873 = (node_t) (aux_1874);
						  }
						  arg1717_1213 = node_remove__162_ast_remove(aux_1873);
					       }
					       {
						  sfun_t obj_1435;
						  obj_t val1135_1436;
						  obj_1435 = (sfun_t) (sfun_1212);
						  val1135_1436 = (obj_t) (arg1717_1213);
						  ((((sfun_t) CREF(obj_1435))->body) = ((obj_t) val1135_1436), BUNSPEC);
					       }
					    }
					    {
					       obj_t arg1720_1215;
					       obj_t arg1721_1216;
					       arg1720_1215 = CDR(old_locals_255_1201);
					       arg1721_1216 = MAKE_PAIR(local_1209, new_locals_179_1202);
					       {
						  obj_t new_locals_179_1885;
						  obj_t old_locals_255_1884;
						  old_locals_255_1884 = arg1720_1215;
						  new_locals_179_1885 = arg1721_1216;
						  new_locals_179_1202 = new_locals_179_1885;
						  old_locals_255_1201 = old_locals_255_1884;
						  goto loop_1203;
					       }
					    }
					 }
				    }
				 }
			    }
			 }
			 break;
		      case ((long) 17):
			 {
			    let_var_6_t node_1219;
			    node_1219 = (let_var_6_t) (node_5);
			    {
			       node_t arg1724_1221;
			       arg1724_1221 = node_remove__162_ast_remove((((let_var_6_t) CREF(node_1219))->body));
			       ((((let_var_6_t) CREF(node_1219))->body) = ((node_t) arg1724_1221), BUNSPEC);
			    }
			    {
			       obj_t old_bindings_65_1223;
			       obj_t new_bindings_102_1224;
			       old_bindings_65_1223 = (((let_var_6_t) CREF(node_1219))->bindings);
			       new_bindings_102_1224 = BNIL;
			     loop_1225:
			       if (NULLP(old_bindings_65_1223))
				 {
				    if (NULLP(new_bindings_102_1224))
				      {
					 if ((((let_var_6_t) CREF(node_1219))->removable__42))
					   {
					      node_t aux_1897;
					      aux_1897 = (((let_var_6_t) CREF(node_1219))->body);
					      aux_1727 = (obj_t) (aux_1897);
					   }
					 else
					   {
					      ((((let_var_6_t) CREF(node_1219))->bindings) = ((obj_t) BNIL), BUNSPEC);
					      aux_1727 = (obj_t) (node_1219);
					   }
				      }
				    else
				      {
					 {
					    obj_t arg1732_1232;
					    arg1732_1232 = reverse__39___r4_pairs_and_lists_6_3(new_bindings_102_1224);
					    ((((let_var_6_t) CREF(node_1219))->bindings) = ((obj_t) arg1732_1232), BUNSPEC);
					 }
					 aux_1727 = (obj_t) (node_1219);
				      }
				 }
			       else
				 {
				    obj_t binding_1233;
				    binding_1233 = CAR(old_bindings_65_1223);
				    {
				       obj_t var_1234;
				       var_1234 = CAR(binding_1233);
				       {
					  node_t val_1235;
					  {
					     node_t aux_1907;
					     {
						obj_t aux_1908;
						aux_1908 = CDR(binding_1233);
						aux_1907 = (node_t) (aux_1908);
					     }
					     val_1235 = node_remove__162_ast_remove(aux_1907);
					  }
					  {
					     {
						bool_t test1733_1236;
						{
						   bool_t test_1912;
						   {
						      long aux_1913;
						      {
							 local_t obj_1455;
							 obj_1455 = (local_t) (var_1234);
							 aux_1913 = (((local_t) CREF(obj_1455))->occurrence);
						      }
						      test_1912 = (aux_1913 <= ((long) 0));
						   }
						   if (test_1912)
						     {
							bool_t test1747_1246;
							test1747_1246 = side_effect__165_effect_effect(val_1235);
							if (test1747_1246)
							  {
							     test1733_1236 = ((bool_t) 0);
							  }
							else
							  {
							     test1733_1236 = ((bool_t) 1);
							  }
						     }
						   else
						     {
							test1733_1236 = ((bool_t) 0);
						     }
						}
						if (test1733_1236)
						  {
						     {
							bool_t test1734_1237;
							test1734_1237 = is_a__118___object((obj_t) (val_1235), var_ast_node);
							if (test1734_1237)
							  {
							     variable_t v_1238;
							     {
								var_t obj_1459;
								obj_1459 = (var_t) (val_1235);
								v_1238 = (((var_t) CREF(obj_1459))->variable);
							     }
							     {
								long arg1738_1239;
								{
								   long aux_1925;
								   aux_1925 = (((variable_t) CREF(v_1238))->occurrence);
								   arg1738_1239 = (aux_1925 - ((long) 1));
								}
								((((variable_t) CREF(v_1238))->occurrence) = ((long) arg1738_1239), BUNSPEC);
							     }
							  }
							else
							  {
							     BUNSPEC;
							  }
						     }
						     {
							obj_t old_bindings_65_1929;
							old_bindings_65_1929 = CDR(old_bindings_65_1223);
							old_bindings_65_1223 = old_bindings_65_1929;
							goto loop_1225;
						     }
						  }
						else
						  {
						     {
							obj_t aux_1931;
							aux_1931 = (obj_t) (val_1235);
							SET_CDR(binding_1233, aux_1931);
						     }
						     {
							obj_t arg1744_1243;
							obj_t arg1745_1244;
							arg1744_1243 = CDR(old_bindings_65_1223);
							arg1745_1244 = MAKE_PAIR(binding_1233, new_bindings_102_1224);
							{
							   obj_t new_bindings_102_1937;
							   obj_t old_bindings_65_1936;
							   old_bindings_65_1936 = arg1744_1243;
							   new_bindings_102_1937 = arg1745_1244;
							   new_bindings_102_1224 = new_bindings_102_1937;
							   old_bindings_65_1223 = old_bindings_65_1936;
							   goto loop_1225;
							}
						     }
						  }
					     }
					  }
				       }
				    }
				 }
			    }
			 }
			 break;
		      case ((long) 18):
			 {
			    set_ex_it_116_t node_1250;
			    node_1250 = (set_ex_it_116_t) (node_5);
			    {
			       node_t arg1755_1251;
			       arg1755_1251 = node_remove__162_ast_remove((((set_ex_it_116_t) CREF(node_1250))->body));
			       ((((set_ex_it_116_t) CREF(node_1250))->body) = ((node_t) arg1755_1251), BUNSPEC);
			    }
			    {
			       bool_t test_1943;
			       {
				  long aux_1944;
				  {
				     local_t obj_1476;
				     {
					variable_t aux_1945;
					{
					   var_t arg1765_1257;
					   arg1765_1257 = (((set_ex_it_116_t) CREF(node_1250))->var);
					   aux_1945 = (((var_t) CREF(arg1765_1257))->variable);
					}
					obj_1476 = (local_t) (aux_1945);
				     }
				     aux_1944 = (((local_t) CREF(obj_1476))->occurrence);
				  }
				  test_1943 = (aux_1944 <= ((long) 0));
			       }
			       if (test_1943)
				 {
				    node_t aux_1951;
				    aux_1951 = (((set_ex_it_116_t) CREF(node_1250))->body);
				    aux_1727 = (obj_t) (aux_1951);
				 }
			       else
				 {
				    aux_1727 = (obj_t) (node_1250);
				 }
			    }
			 }
			 break;
		      case ((long) 19):
			 {
			    jump_ex_it_184_t node_1258;
			    node_1258 = (jump_ex_it_184_t) (node_5);
			    {
			       node_t arg1766_1259;
			       arg1766_1259 = node_remove__162_ast_remove((((jump_ex_it_184_t) CREF(node_1258))->exit));
			       ((((jump_ex_it_184_t) CREF(node_1258))->exit) = ((node_t) arg1766_1259), BUNSPEC);
			    }
			    {
			       node_t arg1768_1261;
			       arg1768_1261 = node_remove__162_ast_remove((((jump_ex_it_184_t) CREF(node_1258))->value));
			       ((((jump_ex_it_184_t) CREF(node_1258))->value) = ((node_t) arg1768_1261), BUNSPEC);
			    }
			    aux_1727 = (obj_t) (node_1258);
			 }
			 break;
		      default:
		       case_else1652_1133:
			 if (PROCEDUREP(method1646_1129))
			   {
			      aux_1727 = PROCEDURE_ENTRY(method1646_1129) (method1646_1129, (obj_t) (node_5), BEOA);
			   }
			 else
			   {
			      obj_t fun1640_1123;
			      fun1640_1123 = PROCEDURE_REF(node_remove__env_197_ast_remove, ((long) 0));
			      aux_1727 = PROCEDURE_ENTRY(fun1640_1123) (fun1640_1123, (obj_t) (node_5), BEOA);
			   }
		      }
		 }
	       else
		 {
		    goto case_else1652_1133;
		 }
	    }
	    return (node_t) (aux_1727);
	 }
      }
   }
}


/* _node-remove! */ obj_t 
_node_remove__224_ast_remove(obj_t env_1499, obj_t node_1500)
{
   {
      node_t aux_1975;
      aux_1975 = node_remove__162_ast_remove((node_t) (node_1500));
      return (obj_t) (aux_1975);
   }
}


/* node-remove!-default1439 */ node_t 
node_remove__default1439_46_ast_remove(node_t node_6)
{
   FAILURE(CNST_TABLE_REF(((long) 5)), string1782_ast_remove, (obj_t) (node_6));
}


/* _node-remove!-default1439 */ obj_t 
_node_remove__default1439_49_ast_remove(obj_t env_1501, obj_t node_1502)
{
   {
      node_t aux_1982;
      aux_1982 = node_remove__default1439_46_ast_remove((node_t) (node_1502));
      return (obj_t) (aux_1982);
   }
}


/* imported-modules-init */ obj_t 
imported_modules_init_94_ast_remove()
{
   module_initialization_70_type_type(((long) 0), "AST_REMOVE");
   module_initialization_70_ast_var(((long) 0), "AST_REMOVE");
   module_initialization_70_ast_node(((long) 0), "AST_REMOVE");
   module_initialization_70_tools_error(((long) 0), "AST_REMOVE");
   module_initialization_70_tools_speek(((long) 0), "AST_REMOVE");
   module_initialization_70_tools_shape(((long) 0), "AST_REMOVE");
   module_initialization_70_effect_effect(((long) 0), "AST_REMOVE");
   return module_initialization_70_ast_occur(((long) 0), "AST_REMOVE");
}
