;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/pragma.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 15:11:13 1996                          */
;*    Last change :  Mon Sep 21 13:51:54 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The creation of pragma forms.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_pragma
   (include "Ast/node.sch")
   (import  tools_error
	    tools_location
 	    ast_sexp)
   (export (pragma/type->node::node ::bool ::type exp stack ::obj ::symbol)))

;*---------------------------------------------------------------------*/
;*    pragma/type->node ...                                            */
;*---------------------------------------------------------------------*/
(define (pragma/type->node free type exp stack loc site)
   (match-case exp
      ((?- (and (? string?) ?format) . ?values)
       (let ((max-index (get-max-index format))
	     (loc       (find-location/loc exp loc)))
	  (if (not (=fx max-index (length values)))
	      (error-sexp->node "Wrong number of arguments in `pragma' form"
				exp
				loc)
	      (let loop ((exps values)
			 (nodes '()))
		 (if (null? exps)
		     (instantiate::pragma (loc          loc)
					  (type         type)
					  (format       format)
					  (args         (reverse! nodes))
					  (side-effect? (not free)))
		     (loop (cdr exps)
			   (cons
			    (sexp->node (car exps)
					stack
					(find-location/loc (car exps) loc)
					'value)
			    nodes)))))))
      (else
       (error-sexp->node "Illegal `pragma' form" exp loc))))

;*---------------------------------------------------------------------*/
;*    get-max-index ...                                                */
;*---------------------------------------------------------------------*/
(define (get-max-index format)
   (let ((parser (regular-grammar ()
		    ((: #\$ (+ (in (#\0 #\9))))
		     (string->number (the-substring 1 (the-length))))
 		    ((+ (out #\$))
		     (ignore))
		    (else
		     (the-failure))))
	 (port   (open-input-string format)))
      (let loop ((exp (read/rp parser port))
		 (max 0))
	 (cond
	    ((eof-object? exp)
	     max)
	    ((char? exp)
	     (loop (read/rp parser port) max))
	    (else
	     (loop (read/rp parser port) (if (>fx exp max) exp max)))))))
   

