/*===========================================================================*/
/*   (Ast/pragma.scm)                                                        */
/*   Bigloo (2.0)                                                            */
/*   Manuel Serrano (c)       Thu Feb 11 22:46:22 CET 1999                   */
/*===========================================================================*/

/* GC selection */
#define THE_GC BOEHM_GC

#include <bigloo2.0a.h>


/* Object type definitions */
typedef struct type
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     obj_t size;
     obj_t class;
     obj_t coerce_to_204;
     obj_t parents;
     bool_t init__47;
     bool_t magic__53;
     obj_t __57;
     obj_t alias;
     obj_t pointed_to_by_76;
     obj_t tvector;
  }
    *type_t;

typedef struct value
  {
     header_t header;
     obj_t widening;
  }
     *value_t;

typedef struct variable
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
  }
        *variable_t;

typedef struct global
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     obj_t module;
     obj_t import;
     bool_t evaluable__248;
     bool_t library__255;
     bool_t user__32;
     obj_t pragma;
     obj_t src;
  }
      *global_t;

typedef struct local
  {
     header_t header;
     obj_t widening;
     obj_t id;
     obj_t name;
     struct type *type;
     struct value *value;
     obj_t access;
     obj_t fast_alpha_7;
     obj_t removable;
     long occurrence;
     bool_t user__32;
     long key;
  }
     *local_t;

typedef struct fun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
  }
   *fun_t;

typedef struct sfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t property;
     obj_t args;
     obj_t body;
     obj_t class;
     obj_t dsssl_keywords_243;
     obj_t loc;
  }
    *sfun_t;

typedef struct cfun
  {
     header_t header;
     obj_t widening;
     long arity;
     obj_t side_effect__165;
     obj_t predicate_of_78;
     obj_t stack_allocator_172;
     bool_t top__138;
     obj_t the_closure_238;
     obj_t args_type_205;
     bool_t macro__33;
     bool_t infix__163;
  }
    *cfun_t;

typedef struct svar
  {
     header_t header;
     obj_t widening;
     obj_t loc;
  }
    *svar_t;

typedef struct scnst
  {
     header_t header;
     obj_t widening;
     obj_t node;
     obj_t class;
     obj_t loc;
  }
     *scnst_t;

typedef struct cvar
  {
     header_t header;
     obj_t widening;
     bool_t macro__33;
  }
    *cvar_t;

typedef struct sexit
  {
     header_t header;
     obj_t widening;
     obj_t handler;
     bool_t detached__120;
  }
     *sexit_t;

typedef struct node
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
  }
    *node_t;

typedef struct node_effect_213
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
  }
               *node_effect_213_t;

typedef struct atom
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
    *atom_t;

typedef struct var
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
   *var_t;

typedef struct closure
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct variable *variable;
  }
       *closure_t;

typedef struct kwote
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t value;
  }
     *kwote_t;

typedef struct sequence
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t nodes;
  }
        *sequence_t;

typedef struct app
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *fun;
     obj_t args;
     obj_t stack_info_255;
  }
   *app_t;

typedef struct app_ly_162
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     struct node *arg;
  }
          *app_ly_162_t;

typedef struct funcall
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *fun;
     obj_t args;
     obj_t strength;
  }
       *funcall_t;

typedef struct pragma
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t format;
     obj_t args;
  }
      *pragma_t;

typedef struct cast
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *arg;
  }
    *cast_t;

typedef struct setq
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
    *setq_t;

typedef struct conditional
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     struct node *true;
     struct node *false;
  }
           *conditional_t;

typedef struct fail
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *proc;
     struct node *msg;
     struct node *obj;
  }
    *fail_t;

typedef struct select
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *test;
     obj_t clauses;
     struct type *item_type_130;
  }
      *select_t;

typedef struct let_fun_218
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t locals;
     struct node *body;
  }
           *let_fun_218_t;

typedef struct let_var_6
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     obj_t bindings;
     struct node *body;
     bool_t removable__42;
  }
         *let_var_6_t;

typedef struct set_ex_it_116
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *body;
  }
             *set_ex_it_116_t;

typedef struct jump_ex_it_184
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct node *exit;
     struct node *value;
  }
              *jump_ex_it_184_t;

typedef struct make_box_202
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct node *value;
  }
            *make_box_202_t;

typedef struct box_ref_242
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     obj_t side_effect__165;
     obj_t key;
     struct var *var;
  }
           *box_ref_242_t;

typedef struct box_set__221
  {
     header_t header;
     obj_t widening;
     obj_t loc;
     struct type *type;
     struct var *var;
     struct node *value;
  }
            *box_set__221_t;


static obj_t method_init_76_ast_pragma();
extern obj_t find_location_loc_243_tools_location(obj_t, obj_t);
static obj_t get_max_index_90_ast_pragma(obj_t);
static obj_t _pragma_type__node1647_94_ast_pragma(obj_t, obj_t, obj_t, obj_t, obj_t, obj_t, obj_t);
extern bool_t rgc_fill_buffer(obj_t);
extern obj_t pragma_ast_node;
extern node_t pragma_type__node_160_ast_pragma(bool_t, type_t, obj_t, obj_t, obj_t, obj_t);
extern obj_t module_initialization_70_ast_pragma(long, char *);
extern obj_t module_initialization_70_type_type(long, char *);
extern obj_t module_initialization_70_ast_var(long, char *);
extern obj_t module_initialization_70_ast_node(long, char *);
extern obj_t module_initialization_70_tools_error(long, char *);
extern obj_t module_initialization_70_tools_location(long, char *);
extern obj_t module_initialization_70_ast_sexp(long, char *);
extern obj_t module_initialization_70___object(long, char *);
extern obj_t module_initialization_70___reader(long, char *);
extern obj_t module_initialization_70___r4_pairs_and_lists_6_3(long, char *);
extern obj_t module_initialization_70___r4_numbers_6_5(long, char *);
extern long list_length(obj_t);
extern long class_num_218___object(obj_t);
static obj_t imported_modules_init_94_ast_pragma();
static obj_t library_modules_init_112_ast_pragma();
extern obj_t rgc_buffer_substring(obj_t, int, int);
extern node_t sexp__node_235_ast_sexp(obj_t, obj_t, obj_t, obj_t);
extern obj_t open_input_string(obj_t);
static obj_t lambda1478_ast_pragma(obj_t, obj_t);
extern node_t error_sexp__node_157_ast_sexp(obj_t, obj_t, obj_t);
extern obj_t string__number_104___r4_numbers_6_5(obj_t, obj_t);
extern obj_t read___reader(obj_t);
static obj_t require_initialization_114_ast_pragma = BUNSPEC;
static obj_t cnst_init_137_ast_pragma();
extern obj_t reverse__39___r4_pairs_and_lists_6_3(obj_t);
static obj_t __cnst[1];

DEFINE_STATIC_PROCEDURE(proc1650_ast_pragma, lambda1478_ast_pragma1661, lambda1478_ast_pragma, 0L, 1);
DEFINE_EXPORT_PROCEDURE(pragma_type__node_env_157_ast_pragma, _pragma_type__node1647_94_ast_pragma1662, _pragma_type__node1647_94_ast_pragma, 0L, 6);
DEFINE_STRING(string1655_ast_pragma, string1655_ast_pragma1663, "VALUE ", 6);
DEFINE_STRING(string1654_ast_pragma, string1654_ast_pragma1664, "Illegal range", 13);
DEFINE_STRING(string1653_ast_pragma, string1653_ast_pragma1665, "the-substring", 13);
DEFINE_STRING(string1652_ast_pragma, string1652_ast_pragma1666, "Illegal match", 13);
DEFINE_STRING(string1651_ast_pragma, string1651_ast_pragma1667, "regular-grammar", 15);
DEFINE_STRING(string1649_ast_pragma, string1649_ast_pragma1668, "Illegal `pragma' form", 21);
DEFINE_STRING(string1648_ast_pragma, string1648_ast_pragma1669, "Wrong number of arguments in `pragma' form", 42);


/* module-initialization */ obj_t 
module_initialization_70_ast_pragma(long checksum_1345, char *from_1346)
{
   if (CBOOL(require_initialization_114_ast_pragma))
     {
	require_initialization_114_ast_pragma = BBOOL(((bool_t) 0));
	library_modules_init_112_ast_pragma();
	cnst_init_137_ast_pragma();
	imported_modules_init_94_ast_pragma();
	method_init_76_ast_pragma();
	return BUNSPEC;
     }
   else
     {
	return BUNSPEC;
     }
}


/* library-modules-init */ obj_t 
library_modules_init_112_ast_pragma()
{
   module_initialization_70___r4_pairs_and_lists_6_3(((long) 0), "AST_PRAGMA");
   module_initialization_70___object(((long) 0), "AST_PRAGMA");
   module_initialization_70___r4_numbers_6_5(((long) 0), "AST_PRAGMA");
   module_initialization_70___reader(((long) 0), "AST_PRAGMA");
   return BUNSPEC;
}


/* cnst-init */ obj_t 
cnst_init_137_ast_pragma()
{
   {
      obj_t cnst_port_138_1337;
      cnst_port_138_1337 = open_input_string(string1655_ast_pragma);
      {
	 long i_1338;
	 i_1338 = ((long) 0);
       loop_1339:
	 {
	    bool_t test1656_1340;
	    test1656_1340 = (i_1338 == ((long) -1));
	    if (test1656_1340)
	      {
		 return BUNSPEC;
	      }
	    else
	      {
		 {
		    obj_t arg1657_1341;
		    {
		       obj_t list1658_1342;
		       {
			  obj_t arg1659_1343;
			  arg1659_1343 = BNIL;
			  list1658_1342 = MAKE_PAIR(cnst_port_138_1337, arg1659_1343);
		       }
		       arg1657_1341 = read___reader(list1658_1342);
		    }
		    CNST_TABLE_SET(i_1338, arg1657_1341);
		 }
		 {
		    int aux_1344;
		    {
		       long aux_1364;
		       aux_1364 = (i_1338 - ((long) 1));
		       aux_1344 = (int) (aux_1364);
		    }
		    {
		       long i_1367;
		       i_1367 = (long) (aux_1344);
		       i_1338 = i_1367;
		       goto loop_1339;
		    }
		 }
	      }
	 }
      }
   }
}


/* pragma/type->node */ node_t 
pragma_type__node_160_ast_pragma(bool_t free_1, type_t type_2, obj_t exp_3, obj_t stack_4, obj_t loc_5, obj_t site_6)
{
   {
      obj_t format_699;
      obj_t values_700;
      if (PAIRP(exp_3))
	{
	   obj_t cdr_109_69_705;
	   cdr_109_69_705 = CDR(exp_3);
	   if (PAIRP(cdr_109_69_705))
	     {
		obj_t car_112_152_707;
		car_112_152_707 = CAR(cdr_109_69_705);
		if (STRINGP(car_112_152_707))
		  {
		     obj_t aux_1377;
		     format_699 = car_112_152_707;
		     values_700 = CDR(cdr_109_69_705);
		     {
			obj_t max_index_167_710;
			obj_t loc_711;
			max_index_167_710 = get_max_index_90_ast_pragma(format_699);
			loc_711 = find_location_loc_243_tools_location(exp_3, loc_5);
			{
			   bool_t test_1380;
			   {
			      long aux_1383;
			      long aux_1381;
			      aux_1383 = list_length(values_700);
			      aux_1381 = (long) CINT(max_index_167_710);
			      test_1380 = (aux_1381 == aux_1383);
			   }
			   if (test_1380)
			     {
				obj_t exps_713;
				obj_t nodes_714;
				{
				   pragma_t aux_1386;
				   exps_713 = values_700;
				   nodes_714 = BNIL;
				 loop_715:
				   if (NULLP(exps_713))
				     {
					bool_t arg1455_720;
					obj_t arg1460_723;
					if (free_1)
					  {
					     arg1455_720 = ((bool_t) 0);
					  }
					else
					  {
					     arg1455_720 = ((bool_t) 1);
					  }
					arg1460_723 = reverse__39___r4_pairs_and_lists_6_3(nodes_714);
					{
					   pragma_t res1640_1217;
					   {
					      obj_t side_effect__165_1203;
					      obj_t key_1204;
					      side_effect__165_1203 = BBOOL(arg1455_720);
					      key_1204 = BINT(((long) -1));
					      {
						 pragma_t new1278_1207;
						 new1278_1207 = ((pragma_t) BREF(GC_MALLOC(sizeof(struct pragma))));
						 {
						    long arg1578_1208;
						    arg1578_1208 = class_num_218___object(pragma_ast_node);
						    {
						       obj_t obj_1215;
						       obj_1215 = (obj_t) (new1278_1207);
						       (((obj_t) CREF(obj_1215))->header = MAKE_HEADER(arg1578_1208, 0), BUNSPEC);
						    }
						 }
						 {
						    object_t aux_1397;
						    aux_1397 = (object_t) (new1278_1207);
						    OBJECT_WIDENING_SET(aux_1397, BFALSE);
						 }
						 ((((pragma_t) CREF(new1278_1207))->loc) = ((obj_t) loc_711), BUNSPEC);
						 ((((pragma_t) CREF(new1278_1207))->type) = ((type_t) type_2), BUNSPEC);
						 ((((pragma_t) CREF(new1278_1207))->side_effect__165) = ((obj_t) side_effect__165_1203), BUNSPEC);
						 ((((pragma_t) CREF(new1278_1207))->key) = ((obj_t) key_1204), BUNSPEC);
						 ((((pragma_t) CREF(new1278_1207))->format) = ((obj_t) format_699), BUNSPEC);
						 ((((pragma_t) CREF(new1278_1207))->args) = ((obj_t) arg1460_723), BUNSPEC);
						 res1640_1217 = new1278_1207;
					      }
					   }
					   aux_1386 = res1640_1217;
					}
				     }
				   else
				     {
					obj_t arg1461_724;
					obj_t arg1463_725;
					arg1461_724 = CDR(exps_713);
					{
					   node_t arg1464_726;
					   {
					      obj_t arg1465_727;
					      obj_t arg1466_728;
					      obj_t arg1467_729;
					      arg1465_727 = CAR(exps_713);
					      arg1466_728 = find_location_loc_243_tools_location(CAR(exps_713), loc_711);
					      arg1467_729 = CNST_TABLE_REF(((long) 0));
					      arg1464_726 = sexp__node_235_ast_sexp(arg1465_727, stack_4, arg1466_728, arg1467_729);
					   }
					   {
					      obj_t aux_1412;
					      aux_1412 = (obj_t) (arg1464_726);
					      arg1463_725 = MAKE_PAIR(aux_1412, nodes_714);
					   }
					}
					{
					   obj_t nodes_1416;
					   obj_t exps_1415;
					   exps_1415 = arg1461_724;
					   nodes_1416 = arg1463_725;
					   nodes_714 = nodes_1416;
					   exps_713 = exps_1415;
					   goto loop_715;
					}
				     }
				   aux_1377 = (obj_t) (aux_1386);
				}
			     }
			   else
			     {
				node_t aux_1418;
				aux_1418 = error_sexp__node_157_ast_sexp(string1648_ast_pragma, exp_3, loc_711);
				aux_1377 = (obj_t) (aux_1418);
			     }
			}
		     }
		     return (node_t) (aux_1377);
		  }
		else
		  {
		   tag_102_241_702:
		     return error_sexp__node_157_ast_sexp(string1649_ast_pragma, exp_3, loc_5);
		  }
	     }
	   else
	     {
		goto tag_102_241_702;
	     }
	}
      else
	{
	   goto tag_102_241_702;
	}
   }
}


/* _pragma/type->node1647 */ obj_t 
_pragma_type__node1647_94_ast_pragma(obj_t env_1327, obj_t free_1328, obj_t type_1329, obj_t exp_1330, obj_t stack_1331, obj_t loc_1332, obj_t site_1333)
{
   {
      node_t aux_1424;
      aux_1424 = pragma_type__node_160_ast_pragma(CBOOL(free_1328), (type_t) (type_1329), exp_1330, stack_1331, loc_1332, site_1333);
      return (obj_t) (aux_1424);
   }
}


/* get-max-index */ obj_t 
get_max_index_90_ast_pragma(obj_t format_7)
{
   {
      obj_t parser_732;
      obj_t port_733;
      {
	 obj_t lambda1478_1334;
	 lambda1478_1334 = proc1650_ast_pragma;
	 parser_732 = lambda1478_1334;
      }
      port_733 = open_input_string(format_7);
      {
	 obj_t exp_734;
	 obj_t max_735;
	 {
	    obj_t arg1470_737;
	    arg1470_737 = PROCEDURE_ENTRY(parser_732) (parser_732, port_733, BEOA);
	    exp_734 = arg1470_737;
	    max_735 = BINT(((long) 0));
	  loop_736:
	    {
	       bool_t test1472_739;
	       test1472_739 = EOF_OBJECTP(exp_734);
	       if (test1472_739)
		 {
		    return max_735;
		 }
	       else
		 {
		    if (CHARP(exp_734))
		      {
			 {
			    obj_t arg1474_741;
			    arg1474_741 = PROCEDURE_ENTRY(parser_732) (parser_732, port_733, BEOA);
			    {
			       obj_t exp_1438;
			       exp_1438 = arg1474_741;
			       exp_734 = exp_1438;
			       goto loop_736;
			    }
			 }
		      }
		    else
		      {
			 {
			    obj_t arg1475_742;
			    arg1475_742 = PROCEDURE_ENTRY(parser_732) (parser_732, port_733, BEOA);
			    {
			       obj_t max_1442;
			       obj_t exp_1441;
			       exp_1441 = arg1475_742;
			       {
				  bool_t test_1443;
				  {
				     long aux_1446;
				     long aux_1444;
				     aux_1446 = (long) CINT(max_735);
				     aux_1444 = (long) CINT(exp_734);
				     test_1443 = (aux_1444 > aux_1446);
				  }
				  if (test_1443)
				    {
				       max_1442 = exp_734;
				    }
				  else
				    {
				       max_1442 = max_735;
				    }
			       }
			       max_735 = max_1442;
			       exp_734 = exp_1441;
			       goto loop_736;
			    }
			 }
		      }
		 }
	    }
	 }
      }
   }
}


/* lambda1478 */ obj_t 
lambda1478_ast_pragma(obj_t env_1335, obj_t input_port_219_1336)
{
   {
      obj_t input_port_219_746;
      input_port_219_746 = input_port_219_1336;
      {
	 long last_match_133_838;
	 long last_match_133_830;
	 long last_match_133_822;
	 long last_match_133_815;
	 long last_match_133_807;
	 long min_793;
	 int max_794;
       ignore_866:
	 RGC_START_MATCH(input_port_219_746);
	 {
	    int match_768;
	    {
	       long aux_1451;
	       last_match_133_815 = ((long) 2);
	     state_0_1436_239_852:
	       {
		  int current_char_37_817;
		  current_char_37_817 = RGC_BUFFER_GET_CHAR(input_port_219_746);
		  {
		     bool_t test_1453;
		     {
			long aux_1454;
			aux_1454 = (long) (current_char_37_817);
			test_1453 = (aux_1454 == ((long) 0));
		     }
		     if (test_1453)
		       {
			  {
			     bool_t test1525_819;
			     test1525_819 = RGC_BUFFER_EMPTY(input_port_219_746);
			     if (test1525_819)
			       {
				  bool_t test1526_820;
				  test1526_820 = rgc_fill_buffer(input_port_219_746);
				  if (test1526_820)
				    {
				       goto state_0_1436_239_852;
				    }
				  else
				    {
				       aux_1451 = last_match_133_815;
				    }
			       }
			     else
			       {
				  last_match_133_822 = last_match_133_815;
				state_1_1437_184_851:
				  {
				     long new_match_93_824;
				     RGC_STOP_MATCH(input_port_219_746);
				     new_match_93_824 = ((long) 1);
				     {
					int current_char_37_825;
					current_char_37_825 = RGC_BUFFER_GET_CHAR(input_port_219_746);
					{
					   bool_t test_1463;
					   {
					      long aux_1464;
					      aux_1464 = (long) (current_char_37_825);
					      test_1463 = (aux_1464 == ((long) 0));
					   }
					   if (test_1463)
					     {
						{
						   bool_t test1530_827;
						   test1530_827 = RGC_BUFFER_EMPTY(input_port_219_746);
						   if (test1530_827)
						     {
							bool_t test1531_828;
							test1531_828 = rgc_fill_buffer(input_port_219_746);
							if (test1531_828)
							  {
							     goto state_1_1437_184_851;
							  }
							else
							  {
							     aux_1451 = new_match_93_824;
							  }
						     }
						   else
						     {
							last_match_133_830 = new_match_93_824;
						      state_5_1441_210_850:
							{
							   long new_match_93_832;
							   RGC_STOP_MATCH(input_port_219_746);
							   new_match_93_832 = ((long) 1);
							   {
							      int current_char_37_833;
							      current_char_37_833 = RGC_BUFFER_GET_CHAR(input_port_219_746);
							      {
								 bool_t test_1473;
								 {
								    long aux_1474;
								    aux_1474 = (long) (current_char_37_833);
								    test_1473 = (aux_1474 == ((long) 0));
								 }
								 if (test_1473)
								   {
								      {
									 bool_t test1535_835;
									 test1535_835 = RGC_BUFFER_EMPTY(input_port_219_746);
									 if (test1535_835)
									   {
									      bool_t test1536_836;
									      test1536_836 = rgc_fill_buffer(input_port_219_746);
									      if (test1536_836)
										{
										   goto state_5_1441_210_850;
										}
									      else
										{
										   aux_1451 = new_match_93_832;
										}
									   }
									 else
									   {
									      long last_match_133_1481;
									      last_match_133_1481 = new_match_93_832;
									      last_match_133_830 = last_match_133_1481;
									      goto state_5_1441_210_850;
									   }
								      }
								   }
								 else
								   {
								      bool_t test_1482;
								      {
									 long aux_1483;
									 aux_1483 = (long) (current_char_37_833);
									 test_1482 = (aux_1483 == ((long) 36));
								      }
								      if (test_1482)
									{
									   aux_1451 = new_match_93_832;
									}
								      else
									{
									   {
									      long last_match_133_1486;
									      last_match_133_1486 = new_match_93_832;
									      last_match_133_830 = last_match_133_1486;
									      goto state_5_1441_210_850;
									   }
									}
								   }
							      }
							   }
							}
						     }
						}
					     }
					   else
					     {
						bool_t test_1487;
						{
						   long aux_1488;
						   aux_1488 = (long) (current_char_37_825);
						   test_1487 = (aux_1488 == ((long) 36));
						}
						if (test_1487)
						  {
						     aux_1451 = new_match_93_824;
						  }
						else
						  {
						     {
							long last_match_133_1491;
							last_match_133_1491 = new_match_93_824;
							last_match_133_830 = last_match_133_1491;
							goto state_5_1441_210_850;
						     }
						  }
					     }
					}
				     }
				  }
			       }
			  }
		       }
		     else
		       {
			  bool_t test_1492;
			  {
			     long aux_1493;
			     aux_1493 = (long) (current_char_37_817);
			     test_1492 = (aux_1493 == ((long) 36));
			  }
			  if (test_1492)
			    {
			       last_match_133_838 = last_match_133_815;
			     state_2_1438_114_849:
			       {
				  long new_match_93_840;
				  RGC_STOP_MATCH(input_port_219_746);
				  new_match_93_840 = ((long) 2);
				  {
				     int current_char_37_841;
				     current_char_37_841 = RGC_BUFFER_GET_CHAR(input_port_219_746);
				     {
					bool_t test_1498;
					{
					   long aux_1499;
					   aux_1499 = (long) (current_char_37_841);
					   test_1498 = (aux_1499 == ((long) 0));
					}
					if (test_1498)
					  {
					     {
						bool_t test1540_843;
						{
						   bool_t res1646_1301;
						   {
						      bool_t _andtest_1006_1298;
						      _andtest_1006_1298 = RGC_BUFFER_EMPTY(input_port_219_746);
						      if (_andtest_1006_1298)
							{
							   res1646_1301 = rgc_fill_buffer(input_port_219_746);
							}
						      else
							{
							   res1646_1301 = ((bool_t) 0);
							}
						   }
						   test1540_843 = res1646_1301;
						}
						if (test1540_843)
						  {
						     goto state_2_1438_114_849;
						  }
						else
						  {
						     aux_1451 = new_match_93_840;
						  }
					     }
					  }
					else
					  {
					     bool_t test_1506;
					     {
						bool_t test_1507;
						{
						   long aux_1508;
						   aux_1508 = (long) (current_char_37_841);
						   test_1507 = (aux_1508 >= ((long) 48));
						}
						if (test_1507)
						  {
						     long aux_1511;
						     aux_1511 = (long) (current_char_37_841);
						     test_1506 = (aux_1511 < ((long) 58));
						  }
						else
						  {
						     test_1506 = ((bool_t) 0);
						  }
					     }
					     if (test_1506)
					       {
						  last_match_133_807 = new_match_93_840;
						state_3_1439_125_853:
						  {
						     long new_match_93_809;
						     RGC_STOP_MATCH(input_port_219_746);
						     new_match_93_809 = ((long) 0);
						     {
							int current_char_37_810;
							current_char_37_810 = RGC_BUFFER_GET_CHAR(input_port_219_746);
							{
							   bool_t test_1516;
							   {
							      long aux_1517;
							      aux_1517 = (long) (current_char_37_810);
							      test_1516 = (aux_1517 == ((long) 0));
							   }
							   if (test_1516)
							     {
								{
								   bool_t test1520_812;
								   {
								      bool_t res1645_1265;
								      {
									 bool_t _andtest_1006_1262;
									 _andtest_1006_1262 = RGC_BUFFER_EMPTY(input_port_219_746);
									 if (_andtest_1006_1262)
									   {
									      res1645_1265 = rgc_fill_buffer(input_port_219_746);
									   }
									 else
									   {
									      res1645_1265 = ((bool_t) 0);
									   }
								      }
								      test1520_812 = res1645_1265;
								   }
								   if (test1520_812)
								     {
									goto state_3_1439_125_853;
								     }
								   else
								     {
									aux_1451 = new_match_93_809;
								     }
								}
							     }
							   else
							     {
								bool_t test_1524;
								{
								   bool_t test_1525;
								   {
								      long aux_1526;
								      aux_1526 = (long) (current_char_37_810);
								      test_1525 = (aux_1526 >= ((long) 48));
								   }
								   if (test_1525)
								     {
									long aux_1529;
									aux_1529 = (long) (current_char_37_810);
									test_1524 = (aux_1529 < ((long) 58));
								     }
								   else
								     {
									test_1524 = ((bool_t) 0);
								     }
								}
								if (test_1524)
								  {
								     {
									long last_match_133_1532;
									last_match_133_1532 = new_match_93_809;
									last_match_133_807 = last_match_133_1532;
									goto state_3_1439_125_853;
								     }
								  }
								else
								  {
								     aux_1451 = new_match_93_809;
								  }
							     }
							}
						     }
						  }
					       }
					     else
					       {
						  aux_1451 = new_match_93_840;
					       }
					  }
				     }
				  }
			       }
			    }
			  else
			    {
			       {
				  long last_match_133_1533;
				  last_match_133_1533 = last_match_133_815;
				  last_match_133_822 = last_match_133_1533;
				  goto state_1_1437_184_851;
			       }
			    }
		       }
		  }
	       }
	       match_768 = (int) (aux_1451);
	    }
	    {
	       switch ((long) (match_768))
		 {
		 case ((long) 2):
		    {
		       bool_t test1490_783;
		       {
			  int arg1496_786;
			  {
			     int res1642_1230;
			     {
				long aux_1535;
				aux_1535 = RGC_BUFFER_LENGTH(input_port_219_746);
				res1642_1230 = (int) (aux_1535);
			     }
			     arg1496_786 = res1642_1230;
			  }
			  {
			     long aux_1538;
			     aux_1538 = (long) (arg1496_786);
			     test1490_783 = (aux_1538 == ((long) 0));
			  }
		       }
		       if (test1490_783)
			 {
			    return BCNST(256);
			 }
		       else
			 {
			    obj_t arg1491_784;
			    {
			       int arg1516_805;
			       {
				  int res1644_1253;
				  {
				     long aux_1542;
				     aux_1542 = RGC_BUFFER_LENGTH(input_port_219_746);
				     res1644_1253 = (int) (aux_1542);
				  }
				  arg1516_805 = res1644_1253;
			       }
			       {
				  int aux_1545;
				  aux_1545 = (int) (((long) 0));
				  arg1491_784 = rgc_buffer_substring(input_port_219_746, aux_1545, arg1516_805);
			       }
			    }
			    {
			       unsigned char aux_1548;
			       aux_1548 = STRING_REF(arg1491_784, ((long) 0));
			       return BCHAR(aux_1548);
			    }
			 }
		    }
		    break;
		 case ((long) 1):
		    goto ignore_866;
		    break;
		 case ((long) 0):
		    {
		       obj_t arg1481_772;
		       {
			  int arg1484_775;
			  {
			     int res1641_1225;
			     {
				long aux_1551;
				aux_1551 = RGC_BUFFER_LENGTH(input_port_219_746);
				res1641_1225 = (int) (aux_1551);
			     }
			     arg1484_775 = res1641_1225;
			  }
			  min_793 = ((long) 1);
			  max_794 = arg1484_775;
			  {
			     bool_t test1504_796;
			     if ((min_793 >= ((long) 0)))
			       {
				  bool_t test1512_801;
				  {
				     int arg1513_802;
				     {
					int res1643_1239;
					{
					   long aux_1556;
					   aux_1556 = RGC_BUFFER_LENGTH(input_port_219_746);
					   res1643_1239 = (int) (aux_1556);
					}
					arg1513_802 = res1643_1239;
				     }
				     {
					long aux_1561;
					long aux_1559;
					aux_1561 = (long) (arg1513_802);
					aux_1559 = (long) (max_794);
					test1512_801 = (aux_1559 <= aux_1561);
				     }
				  }
				  if (test1512_801)
				    {
				       long aux_1565;
				       aux_1565 = (long) (max_794);
				       test1504_796 = (aux_1565 >= min_793);
				    }
				  else
				    {
				       test1504_796 = ((bool_t) 0);
				    }
			       }
			     else
			       {
				  test1504_796 = ((bool_t) 0);
			       }
			     if (test1504_796)
			       {
				  int aux_1569;
				  aux_1569 = (int) (min_793);
				  arg1481_772 = rgc_buffer_substring(input_port_219_746, aux_1569, max_794);
			       }
			     else
			       {
				  obj_t arg1510_799;
				  {
				     obj_t aux_1574;
				     obj_t aux_1572;
				     aux_1574 = BINT(max_794);
				     aux_1572 = BINT(min_793);
				     arg1510_799 = MAKE_PAIR(aux_1572, aux_1574);
				  }
				  FAILURE(string1653_ast_pragma, string1654_ast_pragma, arg1510_799);
			       }
			  }
		       }
		       return string__number_104___r4_numbers_6_5(arg1481_772, BNIL);
		    }
		    break;
		 default:
		    FAILURE(string1651_ast_pragma, string1652_ast_pragma, BINT(match_768));
		 }
	    }
	 }
      }
   }
}


/* method-init */ obj_t 
method_init_76_ast_pragma()
{
   return BUNSPEC;
}


/* imported-modules-init */ obj_t 
imported_modules_init_94_ast_pragma()
{
   module_initialization_70_type_type(((long) 0), "AST_PRAGMA");
   module_initialization_70_ast_var(((long) 0), "AST_PRAGMA");
   module_initialization_70_ast_node(((long) 0), "AST_PRAGMA");
   module_initialization_70_tools_error(((long) 0), "AST_PRAGMA");
   module_initialization_70_tools_location(((long) 0), "AST_PRAGMA");
   return module_initialization_70_ast_sexp(((long) 0), "AST_PRAGMA");
}
