;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/occur.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan  6 11:09:14 1995                          */
;*    Last change :  Tue Oct 27 09:29:50 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The substitution tools module                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_occur
   (include "Ast/node.sch")
   (import  tools_error
	    tools_shape
	    ast_sexp
	    ast_env
	    ast_local)
   (export  (occur-var globals)
	    (occur-node-in! ::node ::global)))

;*---------------------------------------------------------------------*/
;*    occur-var ...                                                    */
;*---------------------------------------------------------------------*/
(define (occur-var globals)
   ;; first, we rester the counter.
   (for-each-global! (lambda (global) (global-occurrence-set! global 0)))
   ;; then we recompute the global occurrences.
   (for-each (lambda (global)
		(occur-node-in! (sfun-body (global-value global)) global))
	     globals))

;*---------------------------------------------------------------------*/
;*    occur-node-in! ...                                               */
;*---------------------------------------------------------------------*/
(define (occur-node-in! node global)
   (set! *global* global)
   (occur-node! node))
   
;*---------------------------------------------------------------------*/
;*    *global* ...                                                     */
;*---------------------------------------------------------------------*/
(define *global* #unspecified)

;*---------------------------------------------------------------------*/
;*    occur-node! ...                                                  */
;*---------------------------------------------------------------------*/
(define-generic (occur-node! node::node)
   'done)

;*---------------------------------------------------------------------*/
;*    occur-node! ::var ...                                            */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::var)
   (let ((v (var-variable node)))
      (let ((value (variable-value v)))
	 (if (and (scnst? value) (node? (scnst-node value)))
	     (occur-node! (scnst-node value))))
      (if (not (eq? v *global*))
	  (variable-occurrence-set! v (+fx (variable-occurrence  v) 1)))))

;*---------------------------------------------------------------------*/
;*    occur-node! ::sequence ...                                       */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::sequence)
   (occur-node*! (sequence-nodes node)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::app ...                                            */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::app)
   (with-access::app node (fun args)
      (occur-node! fun)
      (occur-node*! args)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::app-ly ...                                          */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::app-ly)
   (with-access::app-ly node (fun arg)
      (occur-node! fun)
      (occur-node! arg)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::funcall ...                                        */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::funcall)
   (with-access::funcall node (fun args)
      (occur-node! fun)
      (occur-node*! args)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::pragma ...                                         */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::pragma)
   (occur-node*! (pragma-args node)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::cast ...                                           */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::cast)
   (occur-node! (cast-arg node)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::setq ...                                           */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::setq)
   (with-access::setq node (var value)
      (occur-node! var)
      (occur-node! value)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::conditional ...                                    */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::conditional)
   (with-access::conditional node (test true false)
      (occur-node! test)
      (occur-node! true)
      (occur-node! false)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::fail ...                                           */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::fail)
   (with-access::fail node (proc msg obj)
      (occur-node! proc)
      (occur-node! msg)
      (occur-node! obj)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::select ...                                         */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::select)
   (with-access::select node (test clauses)
      (occur-node! test)
      (for-each (lambda (clause)
		   (occur-node! (cdr clause)))
		clauses)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::let-fun ...                                        */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each (lambda (local)
		   (local-occurrence-set! local 0)
		   (for-each (lambda (a) (local-occurrence-set! a 1))
			     (sfun-args (local-value local))))
		locals)
      (for-each (lambda (local)
		   (let ((old (local-occurrence local)))
		      (occur-node! (sfun-body (local-value local)))
		      (local-occurrence-set! local old)))
		locals)
      (occur-node! body)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::let-var ...                                        */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::let-var)
   (with-access::let-var node (body bindings)
      (for-each (lambda (binding)
		   (local-occurrence-set! (car binding) 0)
		   (occur-node! (cdr binding)))
		bindings)
      (occur-node! body)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::set-ex-it ...                                      */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::set-ex-it)
   (with-access::set-ex-it node (var value)
      (local-occurrence-set! (var-variable var) 0)
      (occur-node! (set-ex-it-body node))))

;*---------------------------------------------------------------------*/
;*    occur-node! ::jump-ex-it ...                                     */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (occur-node! exit)
      (occur-node! value)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::make-box ...                                       */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::make-box)
   (occur-node! (make-box-value node)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::box-ref ...                                        */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::box-ref)
   (occur-node! (box-ref-var node)))

;*---------------------------------------------------------------------*/
;*    occur-node! ::box-set! ...                                       */
;*---------------------------------------------------------------------*/
(define-method (occur-node! node::box-set!)
   (with-access::box-set! node (var value)
      (occur-node! var)
      (occur-node! value)))

;*---------------------------------------------------------------------*/
;*    occur-node*! ...                                                 */
;*---------------------------------------------------------------------*/
(define (occur-node*! node*)
   (for-each occur-node! node*))
