;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/lvtype.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  3 11:58:06 1996                          */
;*    Last change :  Fri Dec 18 07:28:30 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We type an node (straightforward typing used by Coerce and Cnst, */
;*    i.e. passes which occur after the Cfa). This pass only types     */
;*    local variables introduced in let-var.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_lvtype
   (import  type_type
	    type_cache
	    tools_shape
	    tools_error
	    coerce_typeof
	    ast_var
	    ast_node)
   (export  (generic lvtype-node! ::node)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (lvtype-node! node::node))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::atom ...                                          */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::atom)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::kwote ...                                         */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::kwote)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::var ...                                           */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::var)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::closure ...                                       */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::closure)
   (internal-error "lvtype-node!" "Unexpected closure" (shape node)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::sequence ...                                      */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::sequence)
   (with-access::sequence node (nodes)
      (lvtype-node*! nodes)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::app ...                                           */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::app)
   (with-access::app node (args)
      (lvtype-node*! args)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::app-ly ...                                        */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::app-ly)
   (with-access::app-ly node (fun arg)
      (lvtype-node! fun)
      (lvtype-node! arg)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::funcall ...                                       */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::funcall)
   (with-access::funcall node (fun args)
      (lvtype-node! fun)
      (lvtype-node*! args)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::pragma ...                                        */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::pragma)
   (with-access::pragma node (args type)
      (lvtype-node*! args)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::cast ...                                          */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::cast)
   (with-access::cast node (arg type)
      (lvtype-node! arg)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::setq ...                                          */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::setq)
   (with-access::setq node (var value)
      (lvtype-node! value)
      (lvtype-node! var)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::conditional ...                                   */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::conditional)
   (with-access::conditional node (test true false)
       (lvtype-node! test)
       (lvtype-node! true)
       (lvtype-node! false)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::fail ...                                          */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::fail)
   (with-access::fail node (type proc msg obj)
      (lvtype-node! proc)
      (lvtype-node! msg)
      (lvtype-node! obj)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::select ...                                        */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::select)
   (with-access::select node (clauses test)
      (lvtype-node! test)
      (for-each (lambda (clause)
		   (lvtype-node! (cdr clause)))
		clauses)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::let-fun ...                                       */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each (lambda (local)
		   (lvtype-node! (sfun-body (local-value local))))
		locals)
      (lvtype-node! body)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::let-var ...                                       */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::let-var)
   (with-access::let-var node (body bindings)
      (for-each (lambda (binding)
		   (let ((var (car binding))
			 (val (cdr binding)))
		      (lvtype-node! val)
		      (set-variable-type! var (typeof val))))
		bindings)
      (lvtype-node! body)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::set-ex-it ...                                     */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::set-ex-it)
   (with-access::set-ex-it node (var body)
      (lvtype-node! body)
      (lvtype-node! var)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::jump-ex-it ...                                    */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (lvtype-node! exit) 
      (lvtype-node! value)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::make-box ...                                      */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::make-box)
   (with-access::make-box node (value)
      (lvtype-node! value)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::box-set! ...                                      */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::box-set!)
   (with-access::box-set! node (var value)
      (lvtype-node! var)
      (lvtype-node! value)))

;*---------------------------------------------------------------------*/
;*    lvtype-node! ::box-ref ...                                       */
;*---------------------------------------------------------------------*/
(define-method (lvtype-node! node::box-ref)
   (with-access::box-ref node (var)
      (lvtype-node! var)))

;*---------------------------------------------------------------------*/
;*    lvtype-node*! ...                                                */
;*---------------------------------------------------------------------*/
(define (lvtype-node*! node*)
   (for-each lvtype-node! node*))
   
;*---------------------------------------------------------------------*/
;*    set-variable-type! ...                                           */
;*---------------------------------------------------------------------*/
(define (set-variable-type! variable::variable type::type)
   (let ((ntype (if (eq? type *_*) *obj* type))
	 (otype (variable-type variable))) 
      (if (eq? otype *_*)
	  (variable-type-set! variable ntype))))

