;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/ident.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun  3 09:33:09 1996                          */
;*    Last change :  Thu Feb 11 13:44:39 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The identifier managment                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_ident
   (import tools_error
	   tools_dsssl
	   type_type
	   type_env
	   type_cache)
   (export (type-of-id::type              ::obj)
	   (id-of-id::symbol              ::obj)
	   (fast-id-of-id::symbol         ::obj)
	   (parse-id::pair                ::obj)
	   (parse-dsssl::pair             ::obj)
	   (check-id::pair                ::pair ::obj)
	   (id->name::bstring             ::obj)
	   (local-id->name::bstring       ::symbol)
	   (mark-symbol-non-user!::symbol ::symbol)
	   (user-symbol?::bool            ::symbol)))

;*---------------------------------------------------------------------*/
;*    type-of-id ...                                                   */
;*---------------------------------------------------------------------*/
(define (type-of-id::type id)
   (if (not (symbol? id))
       (user-error "Illegal identifier" "`'" id)
       (cdr (parse-id id))))

;*---------------------------------------------------------------------*/
;*    id-of-id ...                                                     */
;*---------------------------------------------------------------------*/
(define (id-of-id::symbol id)
   (if (not (symbol? id))
       (user-error "parse" "Illegal identifier" id)
       (car (parse-id id))))

;*---------------------------------------------------------------------*/
;*    fast-id-of-id ...                                                */
;*---------------------------------------------------------------------*/
(define (fast-id-of-id::symbol id)
   (cond
      ((dsssl-named-constant? id)
       (gensym 'dsssl))
      ((and (pair? id) (symbol? (car id)))
       (car id))
      ((not (symbol? id))
       (user-error "parse" "Illegal identifier" id))
      (else
       (let* ((string (symbol->string id))
	      (len    (string-length string)))
	  (let loop ((walker  0))
	     (cond
		((=fx walker len)
		 id)
		((and (char=? (string-ref string walker) #\:)
		      (<fx walker (-fx len 1))
		      (char=? (string-ref string (+fx walker 1)) #\:))
		 (string->symbol (substring string 0 walker)))
		(else
		 (loop (+fx walker 1)))))))))

;*---------------------------------------------------------------------*/
;*    parse-id ...                                                     */
;*---------------------------------------------------------------------*/
(define (parse-id::pair id)
   (if (not (symbol? id))
       (user-error "parse" "Illegal identifier" id)
       (let* ((string (symbol->string id))
	      (len    (string-length string)))
	  (let loop ((walker     0)
		     (id-stop    0)
		     (type-start 0))
	     (cond
		((=fx walker len)
		 (cond
		    ((and (=fx id-stop 0) (>fx type-start 0))
		     ;; this empty name variable can be useful to declare
		     ;; prototype so it is legal.
		     (let ((id  (string->symbol ""))
			   (tid (string->symbol (substring string
							   type-start
							   len))))
			(cons id (use-type! tid))))
		    ((=fx id-stop 0)
		     (cons id (get-default-type)))
		    ((=fx type-start len)
		     ;; empty type are erroneous
		     (user-error "type-of-id"
				 "Illegal formal identifier"
				 id
				 (cons 'error-ident (get-default-type))))
		    (else
		     (let ((id  (string->symbol (substring string 0 id-stop)))
			   (tid (string->symbol (substring string
							   type-start
							   len))))
			(cons id (use-type! tid))))))
		((and (char=? (string-ref string walker) #\:)
		      (<fx walker (-fx len 1))
		      (char=? (string-ref string (+fx walker 1)) #\:))
		 (if (>fx type-start 0)
		     (user-error "type-of-id"
				 "Illegal formal identifier"
				 id
				 (cons 'error-ident (get-default-type)))
		     (loop (+fx walker 2) walker (+fx walker 2))))
		(else
		 (loop (+fx walker 1) id-stop type-start)))))))

;*---------------------------------------------------------------------*/
;*    id->name ...                                                     */
;*---------------------------------------------------------------------*/
(define (id->name::bstring id)
   (if (not (symbol? id))
       (user-error "parse" "Illegal identifier" id)
       (let ((name (string-downcase (symbol->string id))))
	  (scheme-id->c-id name
			   (memq (string->symbol name) *c-keyword-list*)))))

;*---------------------------------------------------------------------*/
;*    *c-keyword-list*                                                 */
;*---------------------------------------------------------------------*/
(define *c-keyword-list*
   (map string->symbol
	'("asm" "auto" "break" "case" "char" "const" "continue" "default"
	  "do" "double" "else" "entry" "enum" "extern" "float" "for"
	  "fortran" "goto" "if" "int" "long" "register" "return" "short"
	  "signed" "sizeof" "static" "struct" "switch" "typedef" "union"
	  "unsigned" "void" "volatile" "while" "main")))

;*---------------------------------------------------------------------*/
;*    local-id->name ...                                               */
;*---------------------------------------------------------------------*/
(define (local-id->name::bstring id::symbol)
   (let ((name (string-downcase (symbol->string id))))
      (scheme-id->c-id name #f)))

;*---------------------------------------------------------------------*/
;*    scheme-id->c-id ...                                              */
;*---------------------------------------------------------------------*/
(define (scheme-id->c-id::bstring string::bstring rg)
   ;; is the first char a legal C identifier starting char
   (define (legal-c-starting-identifier-char? c)
      (or (char-alphabetic? c) (char=? c #\_)))
   ;; in a first time, we check if we have to compute a new identifier
   (define (require-new-name? string)
      (or rg
	  (not (legal-c-starting-identifier-char? (string-ref string 0)))
	  (let ((len (string-length string)))
	     (let loop ((i 0))
		(if (=fx i len)
		    #f
		    (let ((c (string-ref string i)))
		       (if (or (char-alphabetic? c)
			       (char-numeric? c)
			       (char=? c #\_))
			   (loop (+fx i 1))
			   #t)))))))
   ;; we start converting
   (let ((len (string-length string)))
      (cond
	 ((=fx len 0)
	  "_")
	 ((not (require-new-name? string))
	  (if (char=? (string-ref string 0) #\_)
	      (remove__ string)
	      string))
	 (else
	  (let* ((len (string-length string))
		 (res (make-string len)))
	     (let loop ((i 0))
		(if (=fx i len)
		    (let* ((str (string-append
				 res
				 "_"
				 (integer->string (string->0..255 string))))
			   (cs  (string-ref str 0)))
		       (cond
			  ((char=? cs #\_)
			   (remove__ str))
			  ((legal-c-starting-identifier-char? cs)
			   str)
			  (else
			   (string-append "_" str))))
		    (let ((c (string-ref string i)))
		       (if (or (char-alphabetic? c)
			       (char-numeric? c)
			       (char=? c #\_))
			   (begin
			      (string-set! res i (string-ref string i))
			      (loop (+fx i 1)))
			   (begin
			      (string-set! res i #\_) 
			      (loop (+fx i 1))))))))))))
	  
;*---------------------------------------------------------------------*/
;*    remove__ ...                                                     */
;*    -------------------------------------------------------------    */
;*    On some architecture (alpha and mips) __init has a special       */
;*    meaning, in order to prevent all this strange cases, we change   */
;*    ident which start by __init.                                     */
;*---------------------------------------------------------------------*/
(define (remove__ string::bstring)
   (cond
      ((not (>=fx (string-length string) 6))
       string)
      ((not (char=? (string-ref string 0) #\_))
       string)
      ((not (char=? (string-ref string 1) #\_))
       string)
      ((and (not (char=? (string-ref string 2) #\i))
	    (not (char=? (string-ref string 2) #\f)))
       string)
      ((and (not (char=? (string-ref string 3) #\n))
	    (not (char=? (string-ref string 3) #\i)))
       string)
      ((and (not (char=? (string-ref string 4) #\i))
	    (not (char=? (string-ref string 4) #\n)))
       string)
      ((and (not (char=? (string-ref string 5) #\t))
	    (not (char=? (string-ref string 5) #\i)))
       string)
      ((not (char=? (string-ref string 6) #\_))
       string)
      (else
       (string-append "_n_o_f_u_c_k_i_n_g___init_or_fini" string))))

;*---------------------------------------------------------------------*/
;*    check-id ...                                                     */
;*---------------------------------------------------------------------*/
(define (check-id id src)
   (if (eq? (car id) (string->symbol ""))
       (user-error "Illegal identifier" "`'" src)
       id))

;*---------------------------------------------------------------------*/
;*    parse-dsssl ...                                                  */
;*---------------------------------------------------------------------*/
(define (parse-dsssl obj)
   (cond
    ((dsssl-named-constant? obj)
     (cons obj *obj*))
    ((dsssl-defaulted-formal? obj)
     (cons obj *obj*))
    (else
     (user-error "Illegal formal parameter" "" obj))))

;*---------------------------------------------------------------------*/
;*    mark-symbol-non-user! ...                                        */
;*    -------------------------------------------------------------    */
;*    Mark a symbol as a compiler identifier.                          */
;*    -------------------------------------------------------------    */
;*    if this property has to be changed (if non-user has to be        */
;*    changed the modification has to be set inside the                */
;*    @path ../../runtime/Eval/expd-bool.scm@ file                     */
;*    (the __expander_bool library module).                            */
;*---------------------------------------------------------------------*/
(define (mark-symbol-non-user! sym)
   (putprop! sym 'non-user #t)
   sym)

;*---------------------------------------------------------------------*/
;*    user-symbol? ...                                                 */
;*    -------------------------------------------------------------    */
;*    Is a symbol a user symbol?                                       */
;*---------------------------------------------------------------------*/
(define (user-symbol? symbol)
   (not (getprop symbol 'non-user)))
