;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/hrtype.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  3 11:58:06 1996                          */
;*    Last change :  Sat Dec 19 14:14:33 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This function hrtype-node! is used for inlined functions         */
;*    that are restore from additional heap. These bodies still        */
;*    contain references to their old definition types. New pointers   */
;*    have to be restored.                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_hrtype
   (import  type_type
	    type_env
	    tools_shape
	    tools_error
	    coerce_typeof
	    ast_var
	    ast_node)
   (export  (generic hrtype-node! ::node)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (hrtype-node! node::node))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::atom ...                                          */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::atom)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::kwote ...                                         */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::kwote)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::var ...                                           */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::var)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::closure ...                                       */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::closure)
   (internal-error "hrtype-node!" "Unexpected closure" (shape node)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::sequence ...                                      */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::sequence)
   (with-access::sequence node (nodes)
      (hrtype-node*! nodes)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::app ...                                           */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::app)
   (with-access::app node (args)
      (hrtype-node*! args)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::app-ly ...                                        */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::app-ly)
   (with-access::app-ly node (fun arg)
      (hrtype-node! fun)
      (hrtype-node! arg)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::funcall ...                                       */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::funcall)
   (with-access::funcall node (fun args)
      (hrtype-node! fun)
      (hrtype-node*! args)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::pragma ...                                        */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::pragma)
   (with-access::pragma node (args type)
      (if (type? type)
	  (set! type (find-type (type-id type))))
      (hrtype-node*! args)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::cast ...                                          */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::cast)
   (with-access::cast node (arg type)
      (hrtype-node! arg)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::setq ...                                          */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::setq)
   (with-access::setq node (var value)
      (hrtype-node! value)
      (hrtype-node! var)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::conditional ...                                   */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::conditional)
   (with-access::conditional node (test true false)
       (hrtype-node! test)
       (hrtype-node! true)
       (hrtype-node! false)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::fail ...                                          */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::fail)
   (with-access::fail node (type proc msg obj)
      (hrtype-node! proc)
      (hrtype-node! msg)
      (hrtype-node! obj)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::select ...                                        */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::select)
   (with-access::select node (clauses test)
      (hrtype-node! test)
      (for-each (lambda (clause)
		   (hrtype-node! (cdr clause)))
		clauses)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::let-fun ...                                       */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each (lambda (local)
		   (let ((sfun (local-value local)))
		      (let loop ((args (sfun-args sfun)))
			 (if (pair? args)
			     (let ((arg (car args)))
				(cond
				   ((type? arg)
				    (set-car! args (find-type (type-id arg))))
				   ((local? arg)
				    (restore-variable-type! arg))
				   (else
				    (error "hrtype-node!"
					   "Illegal argument"
					   (shape arg))))
				(loop (cdr args)))))
		      (restore-variable-type! local)
		      (hrtype-node! (sfun-body sfun))))
		locals)
      (hrtype-node! body)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::let-var ...                                       */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::let-var)
   (with-access::let-var node (body bindings)
      (for-each (lambda (binding)
		   (let ((var (car binding))
			 (val (cdr binding)))
		      (hrtype-node! val)
		      (restore-variable-type! var)))
		bindings)
      (hrtype-node! body)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::set-ex-it ...                                     */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::set-ex-it)
   (with-access::set-ex-it node (var body)
      (restore-variable-type! (var-variable var))
      (hrtype-node! body)
      (hrtype-node! var)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::jump-ex-it ...                                    */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (hrtype-node! exit) 
      (hrtype-node! value)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::make-box ...                                      */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::make-box)
   (with-access::make-box node (value)
      (hrtype-node! value)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::box-set! ...                                      */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::box-set!)
   (with-access::box-set! node (var value)
      (hrtype-node! var)
      (hrtype-node! value)))

;*---------------------------------------------------------------------*/
;*    hrtype-node! ::box-ref ...                                       */
;*---------------------------------------------------------------------*/
(define-method (hrtype-node! node::box-ref)
   (with-access::box-ref node (var)
      (hrtype-node! var)))

;*---------------------------------------------------------------------*/
;*    hrtype-node*! ...                                                */
;*---------------------------------------------------------------------*/
(define (hrtype-node*! node*)
   (for-each hrtype-node! node*))
   
;*---------------------------------------------------------------------*/
;*    restore-variable-type! ...                                       */
;*---------------------------------------------------------------------*/
(define (restore-variable-type! variable::variable)
   (let ((type (variable-type variable)))
      (if (type? type)
	  (variable-type-set! variable (find-type (type-id type))))))

