;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/dump.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 07:26:21 1994                          */
;*    Last change :  Wed Apr  8 09:20:47 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast->sexp translator                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_dump
   (include "Tvector/tvector.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    tools_args
	    tools_misc
	    tools_location
	    engine_param)
   (export  (generic node->sexp ::node)))

;*---------------------------------------------------------------------*/
;*    node->sexp ...                                                   */
;*---------------------------------------------------------------------*/
(define-generic (node->sexp node::node))

;*---------------------------------------------------------------------*/
;*    node->sexp ::atom ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::atom)
   (if (null? (atom-value node))
       ''()
       (location-shape (node-loc node) (atom-value node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::var)
   (location-shape (node-loc node) (shape (var-variable node))))
		     
;*---------------------------------------------------------------------*/
;*    node->sexp ::closure ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::closure)
   (location-shape (node-loc node)
		   `(function ,(shape (closure-variable node)))))
 
;*---------------------------------------------------------------------*/
;*    node->sexp ::kwote ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::kwote)
   (location-shape (node-loc node)
		   (let ((value (kwote-value node)))
		      (if (a-tvector? value)
			  `(quote ,(a-tvector (shape (a-tvector-type value))
					      (a-tvector-vector value)))
			  `(quote ,value)))))
       
;*---------------------------------------------------------------------*/
;*    node->sexp ::sequence ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::sequence)
   (location-shape (node-loc node)
		   `(begin
		       ,@(map node->sexp (sequence-nodes node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::app ...                                             */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::app)
   (location-shape (node-loc node)
		   `(,(node->sexp (app-fun node))
		     ,@(map node->sexp (app-args node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::app-ly ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::app-ly)
   (location-shape (node-loc node)
		   `(apply ,(node->sexp (app-ly-fun node))
			   ,(node->sexp (app-ly-arg node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::funcall ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::funcall)
   (location-shape (node-loc node)
		   `(,(case (funcall-strength node)
			 ((light)
			  'funcall-l)
			 ((elight)
			  'funcall-el)
			 (else
			  'funcall))
		     ,(node->sexp (funcall-fun node))
		     ,@(map node->sexp (funcall-args node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::pragma ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::pragma)
   (location-shape (node-loc node)
		   (let ((p (if (pragma-side-effect? node)
				'pragma
				'free-pragma)))
		      `(,(if *type-shape?*
			     (symbol-append p 4dots (type-id (node-type node)))
			     p)
			,(pragma-format node)
			,@(map node->sexp (pragma-args node))))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::cast ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::cast)
   (with-access::cast node (type arg)
      `(,(symbol-append 'cast 4dots (type-id type)) ,(node->sexp arg))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::setq ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::setq)
   (location-shape (node-loc node)
		   `(set! ,(node->sexp (setq-var node))
			  ,(node->sexp (setq-value node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::conditional ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::conditional) 
   (location-shape (node-loc node)
		   `(if ,(node->sexp (conditional-test node))
			,(node->sexp (conditional-true node))
			,(node->sexp (conditional-false node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::fail ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::fail)
   (location-shape (node-loc node)
		   `(failure ,(node->sexp (fail-proc node))
			     ,(node->sexp (fail-msg node))
			     ,(node->sexp (fail-obj node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::select ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::select)
   (location-shape (node-loc node)
		   `(case ,(node->sexp (select-test node))
		       ,@(map (lambda (clause)
				 `(,(car clause) ,(node->sexp (cdr clause))))
			      (select-clauses node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::let-fun ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::let-fun)
   (location-shape (node-loc node)
		   `(labels ,(map (lambda (fun)
				     `(,(shape fun)
				       ,(args-list->args*
					 (map shape
					      (sfun-args (local-value fun)))
					 (sfun-arity (local-value fun)))
				       ,(node->sexp
					 (sfun-body (local-value fun)))))
				  (let-fun-locals node))
		       ,(node->sexp (let-fun-body node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::let-var ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::let-var)
   (location-shape (node-loc node)
		   `(let ,(map (lambda (b)
				  `(,(shape (car b)) ,(node->sexp (cdr b))))
			       (let-var-bindings node))
		       ,(node->sexp (let-var-body node)))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::set-ex-it ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::set-ex-it)
   `(set-exit ,(node->sexp (set-ex-it-var node))
	      ,(node->sexp (set-ex-it-body node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::jump-ex-it ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::jump-ex-it)
   `(jump-exit ,(node->sexp (jump-ex-it-exit node))
	       ,(node->sexp (jump-ex-it-value node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::make-box ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::make-box)
   `(make-box ,(node->sexp (make-box-value node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::box-ref ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::box-ref)
   `(box-ref ,(node->sexp (box-ref-var node))))

;*---------------------------------------------------------------------*/
;*    node->sexp ::box-set! ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node->sexp node::box-set!)
   `(box-set! ,(node->sexp (box-set!-var node))
	      ,(node->sexp (box-set!-value node))))
		  
	

     
   
