;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Ast/build.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 14:00:21 1996                          */
;*    Last change :  Thu Aug  8 16:34:59 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    From the code definition, we build the Ast                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_build
   (include "Engine/pass.sch"
	    "Ast/node.sch")
   (import  ast_unit
	    ast_sexp
	    ast_env
	    ast_find-gdefs
	    ast_remove
	    ast_local
	    object_inline
	    tools_args
	    tools_progn
	    tools_location
	    tools_error
	    tools_shape)
   (export  (build-ast             ::obj)
	    (build-ast-sans-remove ::obj)))

;*---------------------------------------------------------------------*/
;*    build-ast ...                                                    */
;*    -------------------------------------------------------------    */
;*    All global variables are now bound, we can now, build the ast.   */
;*---------------------------------------------------------------------*/
(define (build-ast units)
   (remove-var 'ast (build-ast-sans-remove units)))

;*---------------------------------------------------------------------*/
;*    build-ast-sans-remove ...                                        */
;*    -------------------------------------------------------------    */
;*    All global variables are now bound, we can now, build the ast.   */
;*---------------------------------------------------------------------*/
(define (build-ast-sans-remove units)
   (pass-prelude "Ast")
   ;; there are two separate `map' because we can't build
   ;; node of the ast _until_ all the units have been processed
   ;; (otherwise some global variables could be unbound).
   (let ((defs (apply append (map unit->defs units))))
      ;; we can now check if all declared global variables are defined.
      (check-to-be-define)
      ;; and build the regular ast
      (let ((ast (map sfun-def->ast defs)))
	 ;; we inline method into generic functions (this just makes side
	 ;; effects on the body of the generic functions)...
	 (inline-methods!)
	 ;; and we return the constructed ast
	 (pass-postlude ast))))

;*---------------------------------------------------------------------*/
;*    sfun-def->ast ...                                                */
;*---------------------------------------------------------------------*/
(define (sfun-def->ast::global def::global)
   (enter-function (global-id def))
   (let* ((sfun          (global-value def))
	  (sfun-args     (sfun-args sfun))
	  (sfun-body-exp (sfun-body sfun))
	  (def-loc       (find-location (global-src def)))
	  (body          (sexp->node sfun-body-exp
				     sfun-args
				     (find-location/loc sfun-body-exp
							def-loc)
				     'value)))
      (sfun-body-set! sfun body)
      (leave-function)
      def))

