;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/cigloo/Translate/expr.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 29 15:49:22 1995                          */
;*    Last change :  Mon Dec  4 14:48:26 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The expression handling                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module translate_expr
   (include "Translate/ast.sch"
	    "Translate/type.sch")
   (import  translate_type
	    translate_tspec
	    translate_decl)
   (export  (expr->scheme-id expr)))

;*---------------------------------------------------------------------*/
;*    expr->scheme-id ...                                              */
;*---------------------------------------------------------------------*/
(define (expr->scheme-id expr)
   (string->scheme-id (expr->string expr)))

;*---------------------------------------------------------------------*/
;*    expr->string ...                                                 */
;*---------------------------------------------------------------------*/
(define (expr->string expr)
   (cond
      ((symbol? expr)
       (symbol->string expr))
      ((number? expr)
       (number->string expr))
      ((string? expr)
       expr)
      ((pair? expr)
       (let loop ((expr (reverse! expr))
		  (res  ""))
	  (if (null? expr)
	      res
	      (loop (cdr expr)
		    (string-append (expr->string (car expr)) res)))))
      (else
       (if (ast? expr)
	   (ast-case expr
	      ((t-name)
	       (let ((t (let ((t (tspec->type (t-name-type-spec-list expr))))
			   (if (t-name-adecl expr)
			       (type+adecl->type t (t-name-adecl expr))
			       t))))
		  (if (type-$ t)
		      (replace-$ (type-c-name t) "")
		      (type-c-name t))))
	      (else
	       "_"))
	   "_"))))

;*---------------------------------------------------------------------*/
;*    string->scheme-id ...                                            */
;*---------------------------------------------------------------------*/
(define (string->scheme-id string)
   (define (correct-char? char)
      (cond
	 ((char-alphabetic? char)
	  #t)
	 ((char-numeric? char)
	  #t)
	 ((memq char '(#\! #\@ #\# #\$ #\% #\^ #\& #\* #\_ #\+ #\=
		       #\| #\\ #\~ #\: #\< #\> #\? #\/))
	  #t)
	 (else
	  #f)))
   (let loop ((i (-fx (string-length string) 1)))
      (cond
	 ((=fx i -1)
	  string)
	 ((correct-char? (string-ref string i))
	  (loop (-fx i 1)))
	 (else
	  (string-set! string i #\-)
	  (loop (-fx i 1))))))
