/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/cigloo/Example/c-file.c              */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Thu Dec  7 13:08:17 1995                          */
/*    Last change :  Wed Apr  1 08:05:42 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    The C part                                                       */
/*=====================================================================*/

#include "c-file.h"

double
vect_norm( Vect *vect )
{
   double d1 = (vect->p1.x - vect->p2.x);
   double d2 = (vect->p1.x - vect->p2.y);
   
   return sqrt( (d1 * d1) + (d2 * d2) );
}

Vect *
vect_neg( Vect *v )
{
   Vect *new;

   new = malloc( sizeof( struct vect ) );

   new->p1.x = -v->p1.x;
   new->p1.y = -v->p1.y;
   new->p2.x = -v->p2.x;
   new->p2.y = -v->p2.y;
   
   return new;
}

Vect *
vect_add( Vect *v1, Vect *v2 )
{
   Vect *new;

   new = malloc( sizeof( struct vect ) );

   new->p1.x = (v1->p1.x + v2->p1.x);
   new->p1.y = (v1->p1.y + v2->p1.y);
   new->p2.x = (v1->p2.x + v2->p2.x);
   new->p2.y = (v1->p2.y + v2->p2.y);
   
   return new;
}
