;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo/Engine/param.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 29 11:45:41 1995                          */
;*    Last change :  Sat May  9 12:07:22 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Configuration variables                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  tools_date)
   (export  *cigloo-version*
	    *cigloo-name*
	    *cigloo-level*
	    *cigloo-args*
	    *cigloo-rest-args*
	    *cigloo-author*
	    *cigloo-email*
	    *cigloo-date*
	    *cigloo-tmp*
	    *verbose*
	    *src*
	    *src-dirname*
	    *dest*
	    *iname*
	    *oport*
	    *scan-include*
	    *open-include*
	    *include-path*
	    *hookfile*
	    *c-type-alist*
	    *c-unsigned-type-alist*
	    *c-signed-type-alist*
	    *default-type*
	    *no-type*
	    *macro-variable*
	    *macro-function*
	    *directives*
	    *include-directive*
	    *define*
	    *define-fun*
	    *eval-stub?*
	    *gcc-extensions?*))
 
;*---------------------------------------------------------------------*/
;*    compiler and author names ...                                    */
;*---------------------------------------------------------------------*/
(define *cigloo-version*    "0.5")
(define *cigloo-name*       (string-append "Cigloo (v" *cigloo-version* ")"))
(define *cigloo-level*      #f)
(define *cigloo-cmd-name*   'nothing-yet)
(define *cigloo-args*       'nothing-yet)
(define *cigloo-rest-args*  '())
(define *cigloo-author*     "Manuel Serrano")
(define *cigloo-email*      "Manuel.Serrano@unice.fr")
(define *cigloo-date*       (cigloo-date))
(define *cigloo-tmp*        (let ((Venv (getenv "TMPDIR")))
			      (if (string? Venv)
				  Venv
				  "/tmp")))

;*---------------------------------------------------------------------*/
;*    Compiler controls                                                */
;*---------------------------------------------------------------------*/
(define *verbose*        0)

;*---------------------------------------------------------------------*/
;*    file names                                                       */
;*---------------------------------------------------------------------*/
(define *src*            '())
(define *src-dirname*    #f)
(define *iname*          "")
(define *dest*           #f)
(define *oport*          (current-output-port))

;*---------------------------------------------------------------------*/
;*    The includes                                                     */
;*---------------------------------------------------------------------*/
(define *include-path*   '())
(define *scan-include*   '())
(define *open-include*   '())

;*---------------------------------------------------------------------*/
;*    Hooks                                                            */
;*---------------------------------------------------------------------*/
(define *hookfile*       #f)

;*---------------------------------------------------------------------*/
;*    *c-type-alist* ...                                               */
;*    -------------------------------------------------------------    */
;*    This list defines the Bigloo name of the C type. This list       */
;*    can be enlarged by user.                                         */
;*---------------------------------------------------------------------*/
(define *c-type-alist*
   '((obj         . "obj")
     (bchar       . "bchar")
     (blong       . "blong")
     (procedure   . "procedure")    
     (pair        . "pair")         
     (nil         . "nil")          
     (bint        . "bint")         
     (blong       . "blong")        
     (bbool       . "bbool")        
     (cnst        . "cnst")         
     (bstring     . "bstring")      
     (bchar       . "bchar")        
     (real        . "real")         
     (vector      . "vector")             
     (tvector     . "tvector")      
     (struct      . "struct")       
     (tstruct     . "tstruct")      
     (output-port . "output-port" )
     (input-port  . "input-port"  )
     (binary-port . "binary-port")  
     (unspecified . "unspecified")  
     (symbol      . "symbol")       
     (cell        . "cell")         
     (exit        . "exit")         
     (foreign     . "foreign")      
     (char        . "char")
     (char*       . "string")
     (short       . "short")
     (int         . "int")
     (long        . "long")
     (longlong    . "llong") 
     (signed      . "sint")
     (unsigned    . "uint")
     (float       . "float")
     (double      . "double")
     (const       . "int")
     (volatile    . "int")))

(define *c-unsigned-type-alist*
   '((char     . "uchar")
     (short    . "ushort")
     (int      . "uint")
     (long     . "ulong")))

   
(define *c-signed-type-alist*
   '((char     . "schar")
     (short    . "short")
     (int      . "int")
     (long     . "long")))

(define *default-type* "int")

(define *no-type*      '())

;*---------------------------------------------------------------------*/
;*    *macro* ...                                                      */
;*---------------------------------------------------------------------*/
(define *macro-function* #f)
(define *macro-variable* #f)

;*---------------------------------------------------------------------*/
;*    *directives* ...                                                 */
;*---------------------------------------------------------------------*/
(define *directives*        #t)
(define *include-directive* #f)

;*---------------------------------------------------------------------*/
;*    The cpp commands ...                                             */
;*---------------------------------------------------------------------*/
(define *define*           #t)
(define *define-fun*       #t)   

;*---------------------------------------------------------------------*/
;*    Stub production                                                  */
;*---------------------------------------------------------------------*/
(define *eval-stub?*       #f)

;*---------------------------------------------------------------------*/
;*    *gcc-extensions?* ...                                            */
;*---------------------------------------------------------------------*/
(define *gcc-extensions?*  #f)
