;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo/Engine/engine.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul 12 15:53:47 1995                          */
;*    Last change :  Thu Sep 24 08:13:52 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We have read the argument line. We start the real compilation    */
;*    process.                                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_engine
   (export (cigloo)
	   (translate-file <string> <bool> <symbol>))
   (import tools_speek
	   tools_file
	   engine_param
	   engine_translate
	   translate_eval
	   parser_lexer))

;*---------------------------------------------------------------------*/
;*    bigloo-name                                                      */
;*---------------------------------------------------------------------*/
(define-macro (bigloo-name)
   *bigloo-name*)

;*---------------------------------------------------------------------*/
;*    cigloo ...                                                       */
;*---------------------------------------------------------------------*/
(define (cigloo)
   ;; the reader settup
   (init-lexer!)
   (if (string? *dest*)
       (begin
	  (set! *oport* (open-output-file *dest*))
	  (if (not (output-port? *oport*))
	      (error "cigloo" "Can't open file for output" *dest*)
	      (unwind-protect (engine) (close-output-port *oport*))))
       (begin
	  ;; when emiting on stdout we switch to a silent mode
	  (set! *verbose* -1)
	  (engine))))

;*---------------------------------------------------------------------*/
;*    *file-processed* ...                                             */
;*---------------------------------------------------------------------*/
(define *file-processed* '())

;*---------------------------------------------------------------------*/
;*    engine ...                                                       */
;*---------------------------------------------------------------------*/
(define (engine)
   ;; first of all, we emit identification comment and
   ;; the include Bigloo clauses.
   (if (>=fx *verbose* 0)
       (fprint *oport* ";; " *cigloo-name*
	       ", to be used with " (bigloo-name) "."))
   (if *directives*
       (fprint *oport* "(directives"))
   (fprint *oport* " (extern")
   (if (null? *src*)
       (translate-stdin 'emit)
       (for-each (lambda (fname) (translate-file fname 'file 'open))
		 (reverse! *src*)))
   ;; and we close include clauses
   (if *directives*
       (if *eval-stub?*
	   (begin
	      (fprint *oport* "   )")
	      (translate-eval-declarations)
	      (fprint *oport* "   )")
	      (translate-eval-stubs))
	   (fprint *oport* "   ))"))
       (fprint *oport* "   )")))

;*---------------------------------------------------------------------*/
;*    translate-stdin ...                                              */
;*---------------------------------------------------------------------*/
(define (translate-stdin mode)
   (translate (current-input-port) "stdin" mode))
 
;*---------------------------------------------------------------------*/
;*    translate-file ...                                               */
;*---------------------------------------------------------------------*/
(define (translate-file fname path mode)
   [assert check (mode) (or (eq? mode 'open) (eq? mode 'scan))]
   (let ((fname (cond
		   ((eq? path '<include>)
		    (find-file/path (if *src-dirname*
					(string-append *src-dirname* "/" fname)
					fname)
				    *include-path*))
		   ((eq? path 'include)
		    (if *src-dirname*
			(string-append *src-dirname* "/" fname)
			fname))
		   (else
		    (set! *src-dirname* (dirname fname))
		    (if (string=? *src-dirname* ".")
			(set! *src-dirname* #f))
		    fname))))
      (cond
	 ((or (not (string? fname)) (not (file-exists? fname)))
	  (error "cigloo" "Can't find file " fname))
	 ((member fname *file-processed*)
	  'done)
	 (else
	  (set! *file-processed* (cons fname *file-processed*))
	  (let ((port (open-input-file fname)))
	     (if (not (input-port? port))
		 (error "cigloo" "Can't open file for input" fname)
		 (unwind-protect (translate port fname mode)
				 (close-input-port port))))))))
   


