;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-tools.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Nov  8 11:52:51 1998                          */
;*    Last change :  Fri Dec 11 18:21:44 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Various tools for Ude.                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-tools)
(require 'ude-custom)

;*---------------------------------------------------------------------*/
;*    ude-string-suffix ...                                            */
;*---------------------------------------------------------------------*/
(defun ude-string-suffix (string)
  (if (string-match ".+[.]\\([^.]*\\)" string)
      (substring string (match-beginning 1) (match-end 1))
    string))

;*---------------------------------------------------------------------*/
;*    ude-string-prefix ...                                            */
;*---------------------------------------------------------------------*/
(defun ude-string-prefix (string)
  (if (string-match "\\(.+\\)[.][^.]*" string)
      (substring string (match-beginning 1) (match-end 1))
    string))

;*---------------------------------------------------------------------*/
;*    ude-one-window-p ...                                             */
;*---------------------------------------------------------------------*/
(defun ude-one-window-p (win)
  (let* ((frame (window-frame win))
	 (wins  (window-list frame nil win))
	 (res   t))
    (while (and res (consp wins))
      (cond
       ((eq (car wins) win)
	(setq wins (cdr wins)))
       ((window-minibuffer-p (car wins))
	(setq wins (cdr wins)))
       (t
	(setq res nil))))
    res))

;*---------------------------------------------------------------------*/
;*    ude-delete-buffer-window-frame ...                               */
;*    -------------------------------------------------------------    */
;*    Delete a buffer, its window and its frame if it is a one         */
;*    window frame.                                                    */
;*---------------------------------------------------------------------*/
(defun ude-delete-buffer-window-frame (buffer)
  "Delete a buffer, its window and its frame."
  (if (bufferp buffer)
      (let ((window (get-buffer-window buffer t)))
	(if (windowp window)
	    (if (ude-one-window-p window)
		(let ((frame (window-frame window)))
		  (if (framep frame)
		      (delete-frame frame)))
	      (delete-window window))))))

;*---------------------------------------------------------------------*/
;*    ude-one-frame-buffer-p ...                                       */
;*    -------------------------------------------------------------    */
;*    Is FRAME containing only one buffer, BUFFER.                     */
;*---------------------------------------------------------------------*/
(defun ude-one-frame-buffer-p (buffer)
  (if (bufferp buffer)
      (let ((window (get-buffer-window buffer 0)))
	(if (windowp window)
	    (ude-one-window-p window)
	  nil))
    (error "Argument not a buffer %S" buffer)))
  
;*---------------------------------------------------------------------*/
;*    ude-empty-window-p ...                                           */
;*    -------------------------------------------------------------    */
;*    Returns true if the selected window is the only one in its frame */
;*    and if it is empty.                                              */
;*---------------------------------------------------------------------*/
(defun ude-empty-window-p ()
  (and (ude-one-window-p (selected-window)) (= (point-min) (point-max))))

;*---------------------------------------------------------------------*/
;*    ude-region-excerpt ...                                           */
;*---------------------------------------------------------------------*/
(defun ude-region-excerpt (min max)
  (if (< max min)
      (let ((old min))
	(setq min max)
	(setq max old)))
  (if (> (- max min) ude-menu-max-width)
      (let ((half (- (/ ude-menu-max-width 4) 1)))
	(concat (buffer-substring min (+ min half))
		" .. "
		(buffer-substring max (- max half))))
    (buffer-substring min max)))

;*---------------------------------------------------------------------*/
;*    ude-string-excerpt ...                                           */
;*---------------------------------------------------------------------*/
(defun ude-string-excerpt (string)
  (let ((len (length string)))
    (if (> len ude-menu-max-width)
	(let ((half (- (/ ude-menu-max-width 2) 1)))
	  (concat (substring string 0 half)
		  " .. "
		  (substring string (- len half) len)))
      string)))

;*---------------------------------------------------------------------*/
;*    ude-quit-frame-or-emacs ...                                      */
;*---------------------------------------------------------------------*/
(defun ude-quit-frame-or-emacs ()
  (interactive)
  (if (eq (next-frame) (selected-frame))
      (save-buffers-kill-emacs)
    (condition-case nil
        (delete-frame (selected-frame) t)
      (error (save-buffers-kill-emacs)))))

;*---------------------------------------------------------------------*/
;*    ude-first-entries ...                                            */
;*    -------------------------------------------------------------    */
;*    Returns a cons of the first N entries and the NUM-N entries.     */
;*---------------------------------------------------------------------*/
(defun ude-first-entries (n entries)
  (let ((i    1)
	(tail entries))
    (while (and (< i n) (consp tail))
      (setq i (+ i 1))
      (setq tail (cdr tail)))
    (if (consp tail)
	(let ((res (cons entries (cdr tail))))
	  (rplacd tail '())
	  res)
      (cons entries nil))))
  
;*---------------------------------------------------------------------*/
;*    ude-split-menu-entries ...                                       */
;*    -------------------------------------------------------------    */
;*    Split a popup menu into several submenus if it has too much      */
;*    entries.                                                         */
;*---------------------------------------------------------------------*/
(defun ude-split-menu-entries (menu)
  (let ((len (length menu)))
    (if (<= len ude-menu-max-entry)
	menu
      (let ((new-menu '())
	    (old-menu  menu))
	(while (consp old-menu)
	  (let* ((split      (ude-first-entries ude-menu-max-entry old-menu))
		 (subentries (car split))
		 (submenu    (cons (concat (aref (car subentries) 0) "...")
				   subentries)))
	    (setq new-menu (cons submenu new-menu))
	    (setq old-menu (cdr split))))
	(nreverse new-menu)))))
  
