;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/ude-toolbar.el                          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 11 09:18:10 1998                          */
;*    Last change :  Wed Nov 11 20:08:37 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Command Ude Toolbar handling functions and variables.            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-toolbar)
(require 'ude-icon)

;*---------------------------------------------------------------------*/
;*    The close button                                                 */
;*---------------------------------------------------------------------*/
(defvar ude-close-toolbar-button
  (toolbar-make-button-list ude-close-toolbar-icon))

;*---------------------------------------------------------------------*/
;*    The open button                                                  */
;*---------------------------------------------------------------------*/
(defvar ude-open-toolbar-button
  (toolbar-make-button-list ude-open-toolbar-icon))

;*---------------------------------------------------------------------*/
;*    ude-toolbar-height ...                                           */
;*---------------------------------------------------------------------*/
(defun ude-toolbar-height (toolbar)
  (let ((button (aref (car toolbar) 0)))
    (if (toolbar-button-p button)
	(+ 8 (glyph-height (car button)))
      (+ 8 (glyph-height (car (eval button)))))))

;*---------------------------------------------------------------------*/
;*    ude-open-close-toolbar ...                                       */
;*---------------------------------------------------------------------*/
(defun ude-open-close-toolbar (toolbar)
  (let ((old-height (specifier-instance default-toolbar-height))
	(new-height (ude-toolbar-height toolbar)))
    (set-specifier default-toolbar toolbar (current-buffer))
    ;; This following set-spectified should be apply to (current-buffer).
    ;; Unfortunately this does not work with xemacs 20.4
    (set-specifier default-toolbar-height new-height)))

