;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-profile.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Aug 12 08:40:54 1998                          */
;*    Last change :  Thu Jan 28 10:13:24 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The BEE profiler.                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-prof)
(require 'ude-config)
(require 'ude-custom)
(require 'ude-autoload)
(require 'ude-toolbar)

;*---------------------------------------------------------------------*/
;*    ude-compile-for-profile ...                                      */
;*---------------------------------------------------------------------*/
(defun ude-compile-for-profile ()
  (interactive)
  (let ((ude-compile-command (format "%s -f %s %s"
				     ude-make
				     ude-makefile
				     ude-makefile-profile-entry)))
    (ude-compile)))

;*---------------------------------------------------------------------*/
;*    ude-profile-default-args ...                                     */
;*---------------------------------------------------------------------*/
(defvar ude-profile-default-args "")

;*---------------------------------------------------------------------*/
;*    ude-global-profile-highlight-buffer ...                          */
;*---------------------------------------------------------------------*/
(defvar ude-global-profile-highlight-buffer nil)

;*---------------------------------------------------------------------*/
;*    ude-run-for-profile ...                                          */
;*---------------------------------------------------------------------*/
(defun ude-run-for-profile (arg)
  (interactive
   (let ((arg (read-string (format "Profiling run argument: [%s] "
				   ude-profile-default-args))))
     (list (if (and (stringp arg) (> (length arg) 0))
	       arg
	     ude-profile-default-args))))
  ;; we remember the buffer local highlighting function
  (setq ude-global-profile-highlight-buffer ude-profile-highlight-buffer)
  ;; we remember the run argument for later profile
  (setq ude-profile-default-args arg)
  ;; we setup success hook
  (ude-success-hook 'ude-load-profile-file)
  ;; the run for profiling
  (let* ((ude-compile-command (format "%s -f %s %s %s=\"%s\""
				      ude-make
				      ude-makefile
				      ude-makefile-run-profile-entry
				      ude-makefile-run-profile-args
				      arg))) 
    (ude-compile)))

;*---------------------------------------------------------------------*/
;*    ude-open-profile ...                                             */
;*---------------------------------------------------------------------*/
(defun ude-open-profile (fname)
  (interactive "Ffile name: ")
  (find-alternate-file fname)
  (ude-profile-init-buffer (current-buffer)))
  
;*---------------------------------------------------------------------*/
;*    ude-reload-profile ...                                           */
;*---------------------------------------------------------------------*/
(defun ude-reload-profile ()
  (interactive)
  (ude-open-profile (buffer-file-name)))
  
;*---------------------------------------------------------------------*/
;*    Various profile toolbar button                                   */
;*---------------------------------------------------------------------*/
(defvar ude-profile-stop-button
  (toolbar-make-button-list ude-stop-icon))
(defvar ude-profile-button
  (toolbar-make-button-list ude-profile-icon))
(defvar ude-profile-help-button
  (toolbar-make-button-list ude-help-icon))
(defvar ude-profile-quit-button
  (toolbar-make-button-list ude-quit-icon))
(defvar ude-profile-reload-button
  (toolbar-make-button-list ude-dbg-file-icon))
(defvar ude-profile-open-button
  (toolbar-make-button-list ude-open-icon))

;*---------------------------------------------------------------------*/
;*    ude-profile-opened-toolbar ...                                   */
;*---------------------------------------------------------------------*/
(defvar ude-profile-opened-toolbar 
  '(;;close button
    [ude-close-toolbar-button ude-close-profile-toolbar t "Close toolbar"]
    [:style 2d :size 2]
    
    ;; the quit button
    [ude-profile-quit-button delete-frame t "Close Profile Frame"]
    [:style 2d :size 2]

    ;; open profile button
    [ude-profile-reload-button ude-reload-profile t "Reload Profile"]
    [ude-profile-open-button ude-open-profile t "Open Profile"]
    [:style 2d :size 2]
    
    ;; the re profile button
    [ude-profile-button ude-run-for-profile t "Re-profile"]
    [:style 2d :size 2]

    ;; flushing right
    nil
    [:style 2d :size 2]
    ;; the help action
    [ude-profile-help-button describe-mode t "Help"]))

;*---------------------------------------------------------------------*/
;*    ude-profile-closed-toolbar ...                                   */
;*---------------------------------------------------------------------*/
(defvar ude-profile-closed-toolbar
  '([ude-open-toolbar-button ude-open-profile-toolbar t "Open toolbar"]))

;*---------------------------------------------------------------------*/
;*    Opening/closing toolbars ...                                     */
;*---------------------------------------------------------------------*/
(defun ude-close-profile-toolbar ()
  (ude-open-close-toolbar ude-profile-closed-toolbar))

(defun ude-open-profile-toolbar ()
  (ude-open-close-toolbar ude-profile-opened-toolbar))

;*---------------------------------------------------------------------*/
;*    ude-load-profile-file ...                                        */
;*---------------------------------------------------------------------*/
(defun ude-load-profile-file (buffer msg)
  ;; we load the PROF file
  (if (file-exists-p "PROF")
      ;; we have to fetch the function that highlight profile
      ;; buffer while we are in the source buffer because the
      ;; highlighting function is buffer local
      (let ((buffer (let ((buf (find-buffer-visiting "PROF")))
		      (if (bufferp buf)
			  (let ((win (get-buffer-window buf t)))
			    (if (windowp win)
				(progn
				  (select-window win)
				  (switch-to-buffer "*scratch*")))
			    (kill-buffer (buffer-name buf))
			    (find-alternate-file "PROF")
			    (current-buffer))
			(find-file-other-frame "PROF")))))
	(set-buffer buffer)
	(ude-profile-init-buffer buffer)))
  t)

;*---------------------------------------------------------------------*/
;*    ude-profile-init-buffer ...                                      */
;*---------------------------------------------------------------------*/
(defun ude-profile-init-buffer (buffer)
  (ude-profile-init-toolbar buffer)
  ;; the hilighting of the buffer is mode
  ;; specific
  (setq ude-profile-highlight-buffer ude-global-profile-highlight-buffer)
  (if (functionp ude-profile-highlight-buffer)
      (funcall ude-profile-highlight-buffer buffer)))
  
;*---------------------------------------------------------------------*/
;*    ude-profile-init-toolbar ...                                     */
;*    -------------------------------------------------------------    */
;*    This hook simply set the UDE profile toolbar for the buffer      */
;*---------------------------------------------------------------------*/
(defun ude-profile-init-toolbar (buffer)
  (set-specifier default-toolbar-visible-p t)
  (set-specifier default-toolbar ude-profile-opened-toolbar buffer))

  



