;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/ude/ude-paren.el                        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 12 21:15:52 1998                          */
;*    Last change :  Sun Nov 22 07:41:46 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ude paren handling                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-paren)
(require 'mic-paren)

;*---------------------------------------------------------------------*/
;*    ude-paren-initialized-p ...                                      */
;*---------------------------------------------------------------------*/
(defvar ude-paren-initialized-p nil)

;*---------------------------------------------------------------------*/
;*    ude-paren-init ...                                               */
;*---------------------------------------------------------------------*/
(defun ude-paren-init ()
  (if (not ude-paren-initialized-p)
      (progn
	(setq ude-paren-initialized-p t)
	(setq paren-delay nil)
	(setq paren-face
	      (if (and (fboundp 'x-display-color-p)
		       (x-display-color-p))
		  (let ((fn 'paren-face))
		    (copy-face 'default fn)
		    (set-face-background fn "green")
		    fn)
		'modeline))
	(setq paren-mismatch-face
	      (if (and (fboundp 'x-display-color-p)
		       (x-display-color-p))
		  (let ((fn 'paren-mismatch-face))
		    (copy-face 'default fn)
		    (set-face-background fn "red")
		    fn)
		'modeline))
	(setq paren-no-match-face
	      (if (x-display-color-p)
		  (let ((fn 'paren-no-match-face))
		    (copy-face 'default fn)
		    (set-face-background fn "darkorange1")
		    fn)
		'default)))))


	 
