;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/ude/ude-mouse.el                        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Aug  6 11:16:17 1998                          */
;*    Last change :  Sat Nov 14 08:01:43 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The mouse binding.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-mouse)

;*---------------------------------------------------------------------*/
;*    ude-predicate-menus ...                                          */
;*---------------------------------------------------------------------*/
(defvar ude-predicate-menus '()
  "*The list of predicate menus.
A predicate menu is a pair (PRED . MENU).
PRED is a predicate with of one argument, an EVENT.
MENU is a function that popups a menu.")
(make-variable-buffer-local 'ude-predicate-menus)

;*---------------------------------------------------------------------*/
;*    ude-add-menu ...                                                 */
;*---------------------------------------------------------------------*/
(defun ude-add-menu (pred menu)
  (setq ude-predicate-menus (cons (cons pred menu) ude-predicate-menus)))

;*---------------------------------------------------------------------*/
;*    ude-predicate-mouse-event ...                                    */
;*---------------------------------------------------------------------*/
(defun ude-predicate-mouse-event (event)
  (interactive "e")
  (let ((l ude-predicate-menus))
    (while (consp l)
      (if (funcall (car (car l)) event)
	  (progn
	    (funcall (cdr (car l)) event)
	    (setq l nil))
	(setq l (cdr l))))))



