;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/ude/ude-makefile.el                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Nov 13 08:19:36 1998                          */
;*    Last change :  Fri Nov 20 05:43:09 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Ude Makefile handling                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-makefile)
(require 'ude-custom)
(require 'ude-config)

;*---------------------------------------------------------------------*/
;*    ude-fetch-makefile-entries ...                                   */
;*    -------------------------------------------------------------    */
;*    This function scans a Makefile a build the list contains         */
;*    all the Makefile entries.                                        */
;*---------------------------------------------------------------------*/
(defun ude-fetch-makefile-entries ()
  (let ((mkmf (concat ude-root-directory ude-makefile)))
    (if (file-exists-p mkmf)
	(let* ((cmd     (concat ude-egrep " \""
				ude-makefile-entry-regexp
				":\" " mkmf))
	       (entries (exec-to-string cmd))
	       (pat     (concat "^\\(" ude-makefile-entry-regexp "\\):"))
	       (index   0)
	       (res     '()))
	  (setq res '())
	  (while (string-match pat entries index)
	    (let ((entry (substring entries
				    (match-beginning 1)
				    (match-end 1)))
		  (end   (match-end 0)))
	      (if (not (string-match ude-makefile-entry-exclude-regexp entry))
		  (setq res (cons entry res)))
	      (setq index (+ 1 end))))
	  (if ude-sort-makefile-entries
	      (sort res 'string<)
	    (nreverse res))))))

;*---------------------------------------------------------------------*/
;*    ude-fetch-makefile-binary-entry ...                              */
;*---------------------------------------------------------------------*/
(defun ude-fetch-makefile-binary-entry ()
  (interactive)
  (let ((mkmf (concat ude-root-directory ude-makefile)))
    (if (file-exists-p mkmf)
	(let* ((cmd (format "%s -f %s -s %s"
			    ude-make
			    mkmf
			    ude-makefile-binary-entry))
	       (exec (exec-to-string cmd)))
	  (cond
	   ((string= exec "")
	    nil)
	   ((string-match (concat ude-makefile-binary-entry "\\|stop") exec)
	    nil)
	   ((eq (aref exec (- (length exec) 1)) ?\n)
	    (substring exec 0 (- (length exec) 1)))
	   (t
	    exec))))))

;*---------------------------------------------------------------------*/
;*    ude-edit-makefile ...                                            */
;*---------------------------------------------------------------------*/
(defun ude-edit-makefile ()
  (interactive)
  (let ((default-directory ude-root-directory))
    (find-file-other-frame ude-makefile)))

;*---------------------------------------------------------------------*/
;*    ude-make-ude ...                                                 */
;*---------------------------------------------------------------------*/
(defun ude-make-ude ()
  (interactive)
  (if (file-exists-p (concat ude-root-directory ude-makefile))
      (let ((ude-compile-command (format "%s -f %s %s"
					 ude-make
					 ude-makefile
					 ude-make-ude-entry)))
	(ude-compile))
    (ude-error "Can't find %s%s" ude-root-directory ude-makefile)))
  
;*---------------------------------------------------------------------*/
;*    ude-update-makefile ...                                          */
;*---------------------------------------------------------------------*/
(defun ude-update-makefile (&optional name)
  (interactive)
  (if (file-exists-p (concat ude-root-directory ude-makefile))
      (let ((ude-compile-command (format "%s -f %s%s %s; %s -f %s %s"
					 ude-make
					 ude-root-directory
					 ude-makefile
					 ude-makefile-update-entry
					 ude-make
					 ude-makefile
					 ude-make-ude-entry)))
	(ude-compile))
    (ude-error "Can't find %s%s" ude-root-directory ude-makefile)))

;*---------------------------------------------------------------------*/
;*    ude-generate-makefile ...                                        */
;*---------------------------------------------------------------------*/
(defun ude-generate-makefile (option)
  (interactive)
  (if (or (not (file-exists-p (concat ude-root-directory ude-makefile)))
	  (yes-or-no-p-dialog-box "Makefile already exists, overwrite it?"))
      (let ((main (buffer-file-name)))
	(message "Generating Makefile")
	(if (not (file-exists-p main))
	    (message "*** WARNING: Can't find entry file -- %s" main))
	(let ((ude-compile-command (format "%s %s %s -o %s; %s -f %s %s"
					   ude-makemake
					   option
					   (file-relative-name
					    main
					    ude-root-directory)
					   ude-makefile
					   ude-make
					   ude-makefile
					   ude-make-ude-entry)))
	  ;; we do produce the Makefile
	  (ude-compile)))))

;*---------------------------------------------------------------------*/
;*    ude-add-makefile-entry ...                                       */
;*---------------------------------------------------------------------*/
(defun ude-add-makefile-entry (object source)
  (interactive)
  (if (and (stringp ude-makefile) (file-exists-p ude-makefile))
      (progn
	(message "Adding entries to makefile")
	(let* ((cmd (format "%s -o %s %s %s; %s -f %s %s"
			    ude-makemake
			    ude-makefile
			    (if (stringp object)
				(concat "-object " (file-relative-name
						    object
						    ude-root-directory))
			      "")
			    (if (stringp source)
				(concat "-source " (file-relative-name
						    source
						    ude-root-directory))
			      "")
			    ude-make
			    ude-makefile
			    ude-make-ude-entry))
	       (compilation-ask-about-save nil)
	       (ude-compile-command cmd))
	  (ude-compile)))
    (ude-error "Can't bind Makefile.")))

;*---------------------------------------------------------------------*/
;*    ude-add-user-makefile-entry ...                                  */
;*    -------------------------------------------------------------    */
;*    The interactive wrapper for UDE-ADD-MAKEFILE-ENTRY               */
;*---------------------------------------------------------------------*/
(defun ude-add-user-makefile-entry (source)
  (interactive "sSource entry: ")
  (if (string-match "\\(.*\\)\\([.][^.]+\\)$" source)
      (let ((base (substring source (match-beginning 1) (match-end 1)))
	    (suf  (substring source (match-beginning 2) (match-end 2))))
	(ude-add-makefile-entry (concat base ".o") source))
    (ude-add-makefile-entry (read-string "object: ") source)))
  
