;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-ident.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 12 21:43:15 1998                          */
;*    Last change :  Wed Jan  6 11:48:56 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ude identifier handling.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-ident)
(require 'ude-config)

;*---------------------------------------------------------------------*/
;*    ude-ident-regexp ...                                             */
;*---------------------------------------------------------------------*/
(defun ude-ident-regexp ()
  (if (stringp ude-extra-identifier-chars)
      (concat "\\(?:\\w\\|" ude-extra-identifier-chars "\\)")
    "\\w"))

;*---------------------------------------------------------------------*/
;*    ude-fetch-identifier ...                                         */
;*    -------------------------------------------------------------    */
;*    Fetch the identifier at POS.                                     */
;*---------------------------------------------------------------------*/
(defun ude-fetch-identifier (pos)
  "Fetch the Bigloo identifier at POS."
  (interactive "dPosition: ")
  (save-excursion
    ;; we start skipping left until we found a separator
    (let* ((min (save-excursion (beginning-of-line) (point)))
	   (max (save-excursion (end-of-line) (point))))
      (if (looking-at (ude-ident-regexp))
	  ;; we could be located on a identifier we go left until we found
	  ;; a non identifier character
	  (progn
	    (or (save-excursion
		  (backward-char 1)
		  (and (looking-at "\\W")
		       (or (not (stringp ude-extra-identifier-chars))
			   (not (looking-at ude-extra-identifier-chars)))))
		(ude-backward-word))
	    (if (or (= (point) min)
		    (progn
		      (backward-char 1)
		      (looking-at "\\s-\\|(\\|:")))
		(let ((start (if (looking-at "\\s-\\|(\\|:")
				 (+ 1 (point))
			       (point))))
		  ;; we have to look right
		  (goto-char pos)
		  (ude-forward-word)
		  (if (or (= (point) max)
			  (looking-at "\\s-\\|\\s(\\|\\s)\\|::"))
		      ;; we are not sure yet we have to check that it
		      ;; is not a number
		      (let ((end (point)))
			(goto-char start)
			(skip-chars-forward "0-9")
			(if (= (point) end)
			    ;; this is a number
			    nil
			  ;; yes, this is correct
			  (progn
			    (goto-char start)
			    (if (and (> (- end 2) (point))
				     (search-forward "::" (- end 2) t))
				(buffer-substring start (match-beginning 0))
			      (buffer-substring start end)))))
		    nil))
	      nil))
	nil))))

;*---------------------------------------------------------------------*/
;*    ude-forward-word ...                                             */
;*    -------------------------------------------------------------    */
;*    Forward one word using additional identifier chars               */
;*---------------------------------------------------------------------*/
(defun ude-forward-word ()
  (forward-word 1)
  (if (stringp ude-extra-identifier-chars)
      (while (looking-at ude-extra-identifier-chars)
	(forward-word 1))))
  
;*---------------------------------------------------------------------*/
;*    ude-backward-word ...                                            */
;*    -------------------------------------------------------------    */
;*    Forward one word using additional identifier chars               */
;*---------------------------------------------------------------------*/
(defun ude-backward-word ()
  (backward-word 1)
  (if (stringp ude-extra-identifier-chars)
      (while (and (> (point) (point-min))
		  (save-excursion
		    (backward-char 1)
		    (looking-at ude-extra-identifier-chars)))
	(backward-word 1))))

;*---------------------------------------------------------------------*/
;*    ude-interactive-ident ...                                        */
;*---------------------------------------------------------------------*/
(defun ude-interactive-ident (pos prompt)
  (list (ude-fetch-then-request-identifier pos prompt)))
				  
;*---------------------------------------------------------------------*/
;*    ude-fetch-then-request-identifier ...                            */
;*    -------------------------------------------------------------    */
;*    This function try to fetch an identifier. If it fails, the       */
;*    function ask the user for an identifier.                         */
;*---------------------------------------------------------------------*/
(defun ude-fetch-then-request-identifier (pos &optional prompt) 
  "Fetch the identifier at POS and when failure, ask for an identifier."
  (interactive "dPosition: ")
  (let ((ident (ude-fetch-identifier pos)))
    (if (stringp ident)
	ident
      (if (not prompt)
	  (read-string "Find: ")
	(read-string prompt)))))

;*---------------------------------------------------------------------*/
;*    ude-request-identifier-at ...                                    */
;*---------------------------------------------------------------------*/
(defun ude-request-identifier-at (&optional prompt)
  (if (not prompt)
      (setq prompt "Find: "))
  (let ((res (ude-fetch-identifier (point))))
    (if res
	res
      (read-string prompt))))

 
  
