;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-error.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 11 08:19:19 1998                          */
;*    Last change :  Sun Jan  3 08:24:18 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ude error management                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-error)
(require 'ude-custom)

;*---------------------------------------------------------------------*/
;*    ude-error ...                                                    */
;*    -------------------------------------------------------------    */
;*    This function display the error message and, when customized,    */
;*    play the error sound.                                            */
;*---------------------------------------------------------------------*/
(defun ude-error (msg &rest rest)
  ;; play a sound
  (if ude-error-sound-p
      (if (device-sound-enabled-p)
	  (let ((synchronous-sounds nil))
	    (condition-case ()
		(play-sound 'ude-error)
	      (error (beep))))
	(beep)))
  (let ((msg (apply 'format (cons msg rest))))
    ;; display the error message
    (put-text-property 0 (length msg) 'face 'ude-error-face msg)
    (display-message 'no-log msg)
    (sit-for 2 nil)))
    
;*---------------------------------------------------------------------*/
;*    ude-set-error-sound-volume ...                                   */
;*    -------------------------------------------------------------    */
;*    This function adds a sound configuration to the sound-alist.     */
;*    There is no need to first remove the sound from the Xemacs alist */
;*    because if it already exists the old sound is removed by         */
;*    LOAD-SOUND-FILE.                                                 */
;*---------------------------------------------------------------------*/
(defun ude-set-error-sound-volume (symbol value)
  (set-default symbol value)
  (load-sound-file ude-error-sound-file 'ude-error value))
