;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/ude/ude-custom.el                       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Nov  8 07:29:03 1998                          */
;*    Last change :  Fri Nov 20 05:42:26 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `Unix Development Environment' custom environment. This      */
;*    file contains all the Ude defcustom and Ude defface.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-custom)
(require 'ude-autoload)

;*---------------------------------------------------------------------*/
;*    The Ude group                                                    */
;*---------------------------------------------------------------------*/
(defgroup ude nil
  "Unix Development Environment."
  :tag "Ude"
  :prefix "ude-"
  :group 'processes)

;*---------------------------------------------------------------------*/
;*    Grep ...                                                         */
;*---------------------------------------------------------------------*/
(defcustom ude-grep "grep"
  "*The name of the GREP binary file."
  :group 'ude
  :type 'string)

(defcustom ude-grep-w "grep -w -E -e"
  "*The name of the EGREP -w (exact word) command."
  :group 'ude
  :type 'string)

(defcustom ude-egrep "grep -E -e"
  "*The name of the EGREP command."
  :group 'ude
  :type 'string)

(defcustom ude-egrep-n "grep -E -n -e"
  "*The name of the EGREP with number command."
  :group 'ude
  :type 'string)

(defcustom ude-uncase-grep "grep -i"
  "*The name of the case insensitive GREP command."
  :group 'ude
  :type 'string)

;*---------------------------------------------------------------------*/
;*    Root Directory ...                                               */
;*---------------------------------------------------------------------*/
(defcustom ude-root-search-depth 3
  "*The depth search for the Ude Root Directory."
  :group 'ude
  :type 'number)

;*---------------------------------------------------------------------*/
;*    Tags and association files ...                                   */
;*---------------------------------------------------------------------*/
(defcustom ude-tagsfile-name ".etags"
  "*The name for TAGS table file."
  :group 'ude
  :type 'string)

(defcustom ude-afile-name ".afile"
  "*The name of the Ude module association file."
  :group 'ude
  :type 'string)

;*---------------------------------------------------------------------*/
;*    Make and Makefiles ...                                           */
;*---------------------------------------------------------------------*/
(defcustom ude-make "make"
  "*The name of the MAKE binary file."
  :group 'ude
  :type 'string)

(defcustom ude-make-error-output "[*][*][*]\\| Stop"
  "*A regular expression that matches make error (such as `no rule' error)."
  :group 'ude
  :type 'string)

(defcustom ude-makefile "Makefile"
  "*A string, the name of the Makefile file."
  :group 'ude
  :type 'string)

(defcustom ude-sort-makefile-entries nil
  "*True means Makefile entries are sorted for popup."
  :group 'ude
  :type 'boolean)

(defcustom ude-makefile-entry-regexp "^[^.:\t $][^ %$:]*[ \t]*"
  "*The regexp that matches Makefile entry declaration (without the :)."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-entry-exclude-regexp "[.]o[ \t]*$\\|^%."
  "*The regexp for excluding makefile entry matches."
  :group 'ude
  :type 'string)

(defcustom ude-make-ude-entry "ude"
  "*The name of the Makefile entry that compute Ude Makefile entries."
  :group 'ude
  :type 'string)
  
(defcustom ude-makefile-update-entry "updatemakefile"
  "*The name of the Makefile entry that udpates the Makefile."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-binary-entry "getbinary"
  "*The name of the binary file built by the Makefile."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-revision-entry "revision"
  "*The name of the Makefile entry that give the current revision."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-tar-gz-entry "tar.gz"
  "*The name of the Makefile entry that builds a tar.gz file."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-infofile-entry "infofile"
  "*The name of the Makefile entry that give file revision."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-infofile-args "FILE"
  "*The name of the Makefile file variable."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-checkout-entry "checkoutfile"
  "*The name of the Makefile entry that checks a file out."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-fileversion-args "FILEVERSION"
  "*The name of the Makefile file version variable."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-getsources-entry "getsources"
  "*The name of the Makefile entry that checks a file out."
  :group 'ude
  :type 'string)

;*---------------------------------------------------------------------*/
;*    Compilation ...                                                  */
;*---------------------------------------------------------------------*/
(defcustom ude-compilation-window-height window-min-height
  "*Number of lines in a compilation window. If nil, use Emacs default."
  :group 'ude
  :type '(choice number
		 (const nil)))

(defcustom ude-compilation-frame-height (/ (frame-height) 2)
  "*Number of lines in a compilation frame."
  :group 'ude
  :type 'number)

(defcustom ude-delete-compilation-window-on-success t
  "*True means that compilation window are destroyed on success."
  :group 'ude
  :type 'boolean)

(defcustom ude-sound-compilation-on-error t
  "*True means play the error sound when compilation aborts."
  :group 'ude
  :type 'boolean)

(defcustom ude-pop-compilation-frame-on-error nil
  "*True means pop up a new frame printing compilation errors."
  :group 'ude
  :type 'boolean)

(defcustom ude-enlarge-compilation-window-on-error t
  "*True means enlarge the current compilation window on abortion."
  :group 'ude
  :type 'boolean)

;*---------------------------------------------------------------------*/
;*    Profiling ...                                                    */
;*---------------------------------------------------------------------*/
(defcustom ude-makefile-profile-entry "profile_comp"
  "*The name of the Makefile entry that compile for profiling."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-run-profile-entry "profile_run"
  "*The name of the Makefile entry that compile for profiling."
  :group 'ude
  :type 'string)

(defcustom ude-makefile-run-profile-args "PROFILE_ARGS"
  "*The argument for running a profile."
  :group 'ude
  :type 'string)

(defcustom ude-profile-file-name "PROF"
  "*The name of a profile file."
  :group 'ude
  :type 'string)

;*---------------------------------------------------------------------*/
;*    Errors ...                                                       */
;*---------------------------------------------------------------------*/
(defcustom ude-error-sound-p t
  "*True means Ude plays a sound on error"
  :group 'ude
  :type 'boolean)

(defcustom ude-error-sound-file "bass-snap.au"
  "*The file name for the sound to be played on error"
  :group 'ude
  :type 'string)

(defcustom ude-error-sound-volume 80
  "*The volume of error sound"
  :group 'ude
  :type 'number
  :set 'ude-set-error-sound-volume)

(defface ude-error-face
  (list (list '((class color))
	      (list ':foreground "red"
		    ':bold nil))
	'(t (:bold t)))
  "Ude error face"
  :group 'ude)

;*---------------------------------------------------------------------*/
;*    Key bindings and Menus ...                                       */
;*---------------------------------------------------------------------*/
(defcustom ude-mouse-binding [(button3)]
  "*The mouse binding for Bee mouse event."
  :group 'ude
  :type 'vector)

(defcustom ude-menu-max-width 30
  "*The maximum width of bee menus."
  :group 'ude
  :type 'number)

(defcustom ude-menu-max-entry 30
  "*The maximum entry of bee menus."
  :group 'ude
  :type 'number)

;*---------------------------------------------------------------------*/
;*    Font Lock                                                        */
;*---------------------------------------------------------------------*/
(defcustom ude-font-lock-p t
  "*True means uses font lock for Ude buffers."
  :group 'ude
  :type 'boolean)

(defface ude-font-lock-face-1
  '((((class color)) (:foreground "blue" :bold t))
    (t (:bold t)))
  "Bee face 1."
  :group 'ude)

(defface ude-font-lock-face-2
  '((((class color)) (:foreground "tomato2" :bold t))
    (t (:bold t)))
  "Bee face 2."
  :group 'ude)

(defface ude-font-lock-face-3
  '((((class color)) (:foreground "BlueViolet" :bold t))
    (t (:bold t)))
  "Bee face 3."
  :group 'ude)

(defface ude-font-lock-face-4
  '((((class color)) (:foreground "green3" :bold t))
    (t (:bold t)))
  "Bee face 4."
  :group 'ude)

(defface ude-font-lock-face-5
  '((((class color)) (:foreground "DarkGoldenrod" :bold t))
    (t (:bold t)))
  "Bee face 4."
  :group 'ude)

(defface ude-modeline-root-face
  (list (list '((class color))
	      (list ':foreground "red"
		    ':background (face-background 'modeline)
		    ':bold t))
	'(t (:bold t)))
  "Ude modeline Root face."
  :group 'ude)

(defface ude-modeline-no-root-face
  (list (list '((class color))
	      (list ':foreground "blue"
		    ':background (face-background 'modeline)
		    ':bold t))
	'(t (:bold t)))
  "Ude modeline No Root face."
  :group 'ude)

(defface ude-error-face
  '((((class color)) (:foreground "red" :bold t))
    (t (:bold t)))
  "Bee error face."
  :group 'ude)

(defface ude-ok-face
  '((((class color)) (:foreground "green3" :bold t))
    (t (:bold t)))
  "Bee ok face."
  :group 'ude)

(defface ude-italic-face
  '((((class color)) (:bold t :italic t))
    (t (:bold t)))
  "Bee face to display italic text."
  :group 'ude)

;*---------------------------------------------------------------------*/
;*    ude-customize ...                                                */
;*    -------------------------------------------------------------    */
;*    This function invoked UDE customization in a new frame.          */
;*---------------------------------------------------------------------*/
(defun ude-customize ()
  "Invokes Ude customization in a new frame."
  (interactive)
  (if (ude-empty-window-p)
      (customize-group 'ude)
    (let ((pop-up-frames t))
      (customize-group-other-window 'ude))))
