;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-config.el              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Nov  8 07:29:03 1998                          */
;*    Last change :  Fri Jan  8 18:27:58 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `Unix Development Environment' configuration. This file      */
;*    contains nearly all variables that are mode local.               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-config)
(require 'ude-autoload)
(require 'compile)

;; ude version
(defconst ude-version "0.0"
  "*The Ude version.")

;; ude author
(defconst ude-author "Manuel Serrano (c)")
(defconst ude-url "Manuel.Serrano@unice.fr\nhttp://kaolin.unice.fr/~serrano")

;; root directory
(defvar ude-root-directory default-directory
  "*A string, that is the project root directory.")
(make-variable-buffer-local 'ude-root-directory)

;; compile command
(defvar ude-compile-command "make")
(make-variable-buffer-local 'ude-compile-command)

;; profile processing
(defvar ude-prof "gprof")
(make-variable-buffer-local 'ude-prof)

(defvar ude-profile-highlight-buffer '(lambda (buffer) buffer))
(make-variable-buffer-local 'ude-profile-highlight-buffer)

;; mode menu compile
(defvar ude-mode-menu-compile nil
  "Nil or a procedure that processes a mode specific compilation.")
(make-variable-buffer-local 'ude-mode-menu-compile)

;; compile error regexp
(defvar ude-error-regexp nil)
(make-variable-buffer-local 'ude-error-regexp)
  
;; the tools that builds a Makefile
(defvar ude-makemake "makemake"
  "*A string, the name of the binary file that generates Makefile.")
(make-variable-buffer-local 'ude-makemake)

;; identifiers
(defvar ude-extra-identifier-chars nil
  "*A string, a regexp that matches legal identifier chars that are in \W.")
(make-variable-buffer-local 'ude-extra-identifier-chars)

;; repl
(defvar ude-repl "bigloo"
  "*A string, the name of the binary file that implements REPL.")
(make-variable-buffer-local 'ude-repl)
  
(defvar ude-repl-buffer-name "bee"
  "*A string, the name of the REPL buffer.")
(make-variable-buffer-local 'ude-repl-buffer-name)

(defvar ude-repl-prompt ":=>"
  "*A string, the prompt for REPL.")
(make-variable-buffer-local 'ude-repl-prompt)

;; docline
(defvar ude-docline (lambda () (interactive) '())
  "*A function that is called to fetch an online documentation (e.g. repl).")
(make-variable-buffer-local 'ude-docline)

(defvar ude-info-region (lambda (min start) '())
  "*A function that is called when docline is request on a region.")
(make-variable-buffer-local 'ude-info-region)

(defvar ude-info-fontify t
  "*This variable implement a kind of local lock to prevent fontification
will looking for a string in a list of info files.")

(defvar ude-info-file-list '()
  "List of info files scanned when searching a function definition.")

(defvar ude-manual-page-number 1
  "The man section number.")
(make-variable-buffer-local 'ude-manual-page-number)

;; balloon configuration
(defcustom ude-balloon-timeout 1000
  "Display balloon after this many milliseconds of mouse inactivity."
  :group 'ude
  :type 'number)

(defcustom ude-balloon-width 80
  "The maximum number of chars displayed in a balloon window."
  :group 'ude
  :type 'number)

