;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/dbg/dbg-toolbar.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  5 21:03:27 1998                          */
;*    Last change :  Tue Nov 24 19:57:17 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The dbg toolbar system.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'dbg-toolbar)
(require 'dbg-config)
(require 'ude-icon)
(require 'ude-toolbar)
(require 'comint)

;*---------------------------------------------------------------------*/
;*    Toolbar icons ...                                                */
;*---------------------------------------------------------------------*/
(defvar dbg-close-toolbar-button
  (toolbar-make-button-list ude-close-toolbar-icon))
(defvar dbg-file-button
  (toolbar-make-button-list ude-dbg-file-icon))
(defvar dbg-open-button
  (toolbar-make-button-list ude-open-icon))
(defvar dbg-open-toolbar-button
  (toolbar-make-button-list ude-open-toolbar-icon))
(defvar dbg-help-button
  (toolbar-make-button-list ude-help-icon))
(defvar dbg-info-button
  (toolbar-make-button-list ude-info-icon))
(defvar dbg-run-button
  (toolbar-make-button-list ude-dbg-run-icon))
(defvar dbg-continue-button
  (toolbar-make-button-list ude-dbg-continue-icon))
(defvar dbg-step-button
  (toolbar-make-button-list ude-dbg-step-icon))
(defvar dbg-next-button
  (toolbar-make-button-list ude-dbg-next-icon))
(defvar dbg-until-button
  (toolbar-make-button-list ude-dbg-until-icon))
(defvar dbg-finish-button
  (toolbar-make-button-list ude-dbg-finish-icon))
(defvar dbg-show-button
  (toolbar-make-button-list ude-dbg-show-icon))
(defvar dbg-btag-button
  (toolbar-make-button-list ude-tag-icon))
(defvar dbg-usage-button 
  (toolbar-make-button-list ude-declaration-icon))
(defvar dbg-connect-button
  (toolbar-make-button-list ude-dbg-connect-icon))
(defvar dbg-stop-button
  (toolbar-make-button-list ude-stop-icon))
  
;*---------------------------------------------------------------------*/
;*    dbg-tags-find ...                                                */
;*---------------------------------------------------------------------*/
(defun dbg-tags-find ()
  (interactive)
  (call-interactively dbg-mode-tags-find))

;*---------------------------------------------------------------------*/
;*    dbg-usage-find ...                                               */
;*---------------------------------------------------------------------*/
(defun dbg-usage-find ()
  (interactive)
  (call-interactively dbg-mode-usage-find))

;*---------------------------------------------------------------------*/
;*    dbg-open-file ...                                                */
;*---------------------------------------------------------------------*/
(defun dbg-open-file (file)
  (interactive "fbinary file: ")
  (dbg-remote-call (concat "file " file)))

;*---------------------------------------------------------------------*/
;*    dbg toolbars ...                                                 */
;*---------------------------------------------------------------------*/
(defvar dbg-opened-toolbar
  '(;; close button
    [dbg-close-toolbar-button dbg-close-toolbar  t "dbg toolbar"]
    [:style 2d :size 2]
    
    ;; the find buttom
    [dbg-btag-button dbg-tags-find t "Find definition"]
    ;; the doc buttom
    [dbg-usage-button dbg-usage-find t "Definition documentation"]
    [:style 2d :size 2]
    
    ;; the open button
    [dbg-open-button dbg-open-file t "Open binary file"]
    ;; the file button
    [dbg-file-button (dbg-remote-call "file") t "Reload file"]
    [:style 2d :size 2]
    
    ;; the stop button
    [dbg-stop-button comint-interrupt-subjob t "Stop execution"]
    [:style 2d :size 2]
    
    ;; the run button
    [dbg-run-button (dbg-remote-call dbg-run-command) t "Run"]
    ;; the step button
    [dbg-step-button (dbg-remote-call dbg-step-command) t "Step"]
    ;; the continue button
    [dbg-continue-button (dbg-remote-call dbg-cont-command) t "Continue"]
    ;; the next button
    [dbg-next-button (dbg-remote-call dbg-next-command) t "Next"]
    ;; the until button
    [dbg-until-button (dbg-remote-call dbg-until-command) t "until"]
    ;; the finish button
    [dbg-finish-button (dbg-remote-call dbg-finish-command) t "Finish"]
    [:style 2d :size 2]

    ;; the show button
    [dbg-show-button dbg-show t "Show value"]
    [:style 2d :size 2]
    
    ;; the dbg connect button
    [dbg-connect-button dbg-connect-buffer t "Dbg connect buffer"]
    [:style 2d :size 2]

    nil
    ;; the info button
    [dbg-info-button dbg-docline t "The online documentation for Dbg"]))
 
;*---------------------------------------------------------------------*/
;*    dbg-closed-toolbar ...                                           */
;*---------------------------------------------------------------------*/
(defvar dbg-closed-toolbar
  '(;;open button
    [dbg-open-toolbar-button dbg-open-toolbar t "dbg toolbar"]))

;*---------------------------------------------------------------------*/
;*    dbg-closed-toolbar ...                                           */
;*---------------------------------------------------------------------*/
(defvar dbg-closed-toolbar
  '([ude-open-toolbar-button dbg-open-dbg-toolbar t "Open toolbar"]))

;*---------------------------------------------------------------------*/
;*    Opening/closing the Dbg toolbar ...                              */
;*---------------------------------------------------------------------*/
(defun dbg-close-toolbar ()
  (ude-open-close-toolbar dbg-closed-toolbar))

(defun dbg-open-dbg-toolbar ()
  (ude-open-close-toolbar dbg-opened-toolbar))

;*---------------------------------------------------------------------*/
;*    dbg-toolbar-init ...                                             */
;*---------------------------------------------------------------------*/
(defun dbg-toolbar-init ()
  (set-specifier default-toolbar-visible-p t)
  (set-specifier default-toolbar dbg-opened-toolbar (current-buffer)))

