;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/dbg/dbg-process.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Apr 19 15:08:24 1998                          */
;*    Last change :  Tue Nov 24 19:49:10 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The dbg process management.                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'dbg-process)
(require 'dbg-config)
(require 'dbg)

;*---------------------------------------------------------------------*/
;*    dbg-sentinel ...                                                 */
;*    -------------------------------------------------------------    */
;*    This function is called when the dbg running process changes     */
;*    of state. This means that the process has been killed or         */
;*    stopped or anything else like that.                              */
;*---------------------------------------------------------------------*/
(defun dbg-sentinel (proc msg)
  (cond
   ((null (buffer-name (process-buffer proc)))
    ;; the buffer has been killed. We stop displaying
    ;; arrow in the source files.
    (set-process-buffer proc nil))
   ((or (eq (process-status proc) 'signal)
	(not (eq (process-exit-status proc) 0)))
    (let ((msg (format "KILLING dbg because debugger %s" msg)))
      (ude-error msg)
      (message-box msg)
      (dbg-cleanup-dbg)))
   ((eq (process-status proc) 'exit)
    (dbg-cleanup-dbg))))

;*---------------------------------------------------------------------*/
;*    dbg-cleanup-dbg ...                                              */
;*---------------------------------------------------------------------*/
(defun dbg-cleanup-dbg ()
  (let ((window (get-buffer-window dbg-comint-buffer t)))
    (if (one-window-p window)
	(let ((frame (window-frame window)))
	  (delete-frame frame))))
  (dbg-undisplay-source-line)
  (kill-buffer dbg-comint-buffer)
  (setq dbg-comint-buffer nil))

	  
