;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/dbg/dbg-console.el                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Aug 14 09:20:08 1998                          */
;*    Last change :  Sun Nov 15 07:59:37 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This file is for debugging because I'm not able to understand    */
;*    the causality used by comint. I made this small file to trace    */
;*    what dbg is waiting for.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'dbg-console)

;*---------------------------------------------------------------------*/
;*    dbg-console-buffer ...                                           */
;*---------------------------------------------------------------------*/
(defvar dbg-console-buffer nil
  "*The buffer for the dbg console or nil if the console as
not been launched yet.")

;*---------------------------------------------------------------------*/
;*    dbg-console-get-buffer ...                                       */
;*---------------------------------------------------------------------*/
(defun dbg-console-get-buffer ()
  (setq dbg-console-buffer (get-buffer-create "*dbg console*")))

;*---------------------------------------------------------------------*/
;*    dbg-pop-console ...                                              */
;*    -------------------------------------------------------------    */
;*    Raise the dbg console buffer or create one if none exists.       */
;*---------------------------------------------------------------------*/
(defun dbg-pop-console ()
  (interactive)
  (let ((buffer (current-buffer)))
    (if (bufferp dbg-console-buffer)
	(let ((win (get-buffer-window dbg-console-buffer t)))
	  (if (not (windowp win))
	      (pop-to-buffer dbg-console-buffer)))
      (progn
	(dbg-console-get-buffer)
	(pop-to-buffer dbg-console-buffer)))
    (set-buffer buffer)))

;*---------------------------------------------------------------------*/
;*    dbg-console-log-number ...                                       */
;*---------------------------------------------------------------------*/
(defvar dbg-console-log-number 0)

;*---------------------------------------------------------------------*/
;*    dbg-console-log ...                                              */
;*---------------------------------------------------------------------*/
(defun dbg-console-log (prompt msg &optional face)
  (save-window-excursion
    ;; we first allocate a buffer for the logs
    (if (not (bufferp dbg-console-buffer))
	(dbg-console-get-buffer))
    (setq dbg-console-log-number (+ 1 dbg-console-log-number))
    (if face
	(put-text-property 0 (length msg) 'face face msg))
    (set-buffer dbg-console-buffer)
    (goto-char (point-max))
    (let ((num (format "%s (log num %d):\n" prompt dbg-console-log-number)))
      (insert num))
    (insert msg)
    (insert "\n\n"))
  (let ((win (get-buffer-window dbg-console-buffer)))
    (if (windowp win)
	(set-window-point win (point-max)))))

;*---------------------------------------------------------------------*/
;*    dbg-erase-console ...                                            */
;*---------------------------------------------------------------------*/
(defun dbg-erase-console ()
  (interactive)
  (set-buffer dbg-console-buffer)
  (erase-buffer))

;*---------------------------------------------------------------------*/
;*    dbg-recenter-console ...                                         */
;*---------------------------------------------------------------------*/
(defun dbg-recenter-console ()
  (interactive)
  (let ((win (get-buffer-window dbg-console-buffer)))
    (if (windowp win)
	(set-window-point win (point-max)))))

  
  

