;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/bee/bee-toolbar.el                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  5 21:03:27 1998                          */
;*    Last change :  Thu Nov 19 15:46:16 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The bee toolbar system.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-toolbar)
(require 'bee-autoload)
(require 'ude-icon)
(require 'ude-toolbar)
(require 'ude-autoload)
(require 'dbg-autoload)

;*---------------------------------------------------------------------*/
;*    Various compile toolbar button                                   */
;*---------------------------------------------------------------------*/
(defvar bee-tag-button
  (toolbar-make-button-list ude-tag-icon))
(defvar bee-decl-button
  (toolbar-make-button-list ude-declaration-icon))
(defvar bee-indent-button
  (toolbar-make-button-list ude-indent-icon))
(defvar bee-import-button
  (toolbar-make-button-list ude-import-icon))
(defvar bee-export-button
  (toolbar-make-button-list ude-export-icon))
(defvar bee-c-import-button
  (toolbar-make-button-list ude-c-import-icon))
(defvar bee-compile-button
  (toolbar-make-button-list ude-compile-icon))
(defvar bee-root-button
  (toolbar-make-button-list ude-root-icon))
(defvar bee-make-make-button
  (toolbar-make-button-list ude-make-make-icon))
(defvar bee-make-entry-button
  (toolbar-make-button-list ude-make-entry-icon))
(defvar bee-repl-button
  (toolbar-make-button-list ude-repl-icon))
(defvar bee-bdb-button
  (toolbar-make-button-list ude-dbg-icon))
(defvar bee-connect-button
  (toolbar-make-button-list ude-dbg-connect-icon))
(defvar bee-info-button
  (toolbar-make-button-list ude-info-icon))

;*---------------------------------------------------------------------*/
;*    bee opened toolbar ...                                           */
;*---------------------------------------------------------------------*/
(defvar bee-opened-toolbar
  '(;;close button
    [ude-close-toolbar-button bee-close-toolbar t "bee toolbar"]
			      
    [:style 2d :size 2]
    ;; the tag button
    [bee-tag-button bee-tags-find t "Find definition"]
    ;; the doc buttom
    [bee-decl-button bee-usage-find t "Definition documentation"]
    [:style 2d :size 2]

    ;; the indent button
    [bee-indent-button bee-external-indent t "Indent whole buffer"]
    [:style 2d :size 2]

    ;; the import button
    [bee-import-button bee-import-binding t "Import definition"]
    ;; the export button
    [bee-export-button bee-export-definition t "Export definition"]
    ;; the C importation button
    [bee-c-import-button bee-import-c-file t "Import C definition"]
    [:style 2d :size 2]

    ;; the compile button
    [bee-compile-button ude-mode-compile-from-menu t "Compile"]
    ;; the root button
    [bee-root-button ude-user-set-root-directory t "Set new Bee root directory"]
    ;; the bmake button
    [bee-make-make-button bee-generate/update-makefile t "Generate/update Makefile"]
    ;; the bmake entry button
    [bee-make-entry-button ude-add-user-makefile-entry t "Add Makefile entry"]
    [:style 2d :size 2]

    ;; the repl button
    [bee-repl-button ude-repl-other-frame t "Start a read-eval-print loop"]
    [:style 2d :size 2]
    ;; the bdb button
    [bee-bdb-button bdb-other-frame t "Bdb other frame"]
    ;; the bdb connect button
    [bee-connect-button dbg-toggle-connect-buffer t "Bdb connect buffer"]
    [:style 2d :size 2]

    nil
    ;; the info button
    [bee-info-button bee-docline t
    "The online documentation for Bee"]))

;*---------------------------------------------------------------------*/
;*    bee-closed-toolbar ...                                           */
;*---------------------------------------------------------------------*/
(defvar bee-closed-toolbar
  '([ude-open-toolbar-button bee-open-bee-toolbar t "Open toolbar"]))

;*---------------------------------------------------------------------*/
;*    Opening/closing the Bee toolbar ...                              */
;*---------------------------------------------------------------------*/
(defun bee-close-toolbar ()
  (ude-open-close-toolbar bee-closed-toolbar))

(defun bee-open-bee-toolbar ()
  (ude-open-close-toolbar bee-opened-toolbar))

;*---------------------------------------------------------------------*/
;*    bee-toolbar-init ...                                             */
;*---------------------------------------------------------------------*/
(defun bee-toolbar-init ()
  (set-specifier default-toolbar-visible-p t)
  (set-specifier default-toolbar bee-opened-toolbar (current-buffer)))


