;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/bee/bee-repl.el                         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May 25 16:31:35 1998                          */
;*    Last change :  Fri Nov 13 07:32:06 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This file implements a Bigloo repl process embedded in emacs.    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-repl)
(require 'ude-config)
(require 'ude-autoload)

;*---------------------------------------------------------------------*/
;*    bee-repl-send-define ...                                         */
;*---------------------------------------------------------------------*/
(defun bee-repl-send-define ()
  "Send the current definition to the inferior Bigloo process."
  (interactive)
  (save-excursion
    (end-of-defun)
    (let ((end (point)))
      (if (beginning-of-defun)
	  (ude-repl-send-region (point) end)))))

;*---------------------------------------------------------------------*/
;*    bee-repl-send-last-sexp ...                                      */
;*---------------------------------------------------------------------*/
(defun bee-repl-send-last-sexp ()
  "Send the last s-expression to the inferior Bigloo process."
  (interactive)
  (save-excursion
    (forward-sexp -1)
    (let ((start (point)))
      (forward-sexp 1)
      (ude-repl-send-region start (point)))))

;*---------------------------------------------------------------------*/
;*    bee-repl-send-toplevel-sexp ...                                  */
;*---------------------------------------------------------------------*/
(defun bee-repl-send-toplevel-sexp (pos)
  "Send the current at POS s-expression to the inferiror Bigloo process."
  (interactive "dPosition: ")
  (let ((sexp (bee-find-toplevel-sexp pos)))
    (if (consp sexp)
	(ude-repl-send-region (car sexp) (cdr sexp))
      (error "Corrupted toplevel sexp"))))

