;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/ude/bee/bee-profile.el                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 14 12:20:16 1998                          */
;*    Last change :  Sat Nov 14 13:25:20 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Bee specific profiling.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-profile)
(require 'bee-config)
(require 'bee-autoload)
(require 'ude-custom)
(require 'ude-config)
(require 'ude-autoload)

;*---------------------------------------------------------------------*/
;*    doc source keymap                                                */
;*---------------------------------------------------------------------*/
(defvar bee-profile-mouse-map (make-sparse-keymap))
(define-key bee-profile-mouse-map [(button2)]
  (function bee-profile-find))

;*---------------------------------------------------------------------*/
;*    bee-profile-highlight-buffer ...                                 */
;*---------------------------------------------------------------------*/
(defun bee-profile-highlight-buffer (buffer)
  (set-buffer buffer)
  (let* ((scm-id-regexp "^[][0-9./ \t]+\\([A-Z_!?+.0-9@#$%^&*/<>-]+\\)[ \t]*\\(\\[[0-9]+\\]\\)?$")
	 (scm-mod-regexp "^[][0-9./ \t]+@\\([A-Z_!?+.0-9@#$%^&*/<>-]+\\)[ \t]*\\(\\[[0-9]+\\]\\)?$")
	 (c-regexp "^[][0-9./ \t]+[a-zA-Z_0-9]+[ t]*\\(\\[[0-9]+\\]\\)?$")
	 (union-regexp (concat "\\(" scm-id-regexp "\\)\\|\\(" c-regexp "\\)"))
	 (case-fold-search nil))
    (beginning-of-buffer)
    (while (re-search-forward union-regexp (point-max) t)
      (goto-char (match-beginning 0))
      (let ((end (match-end 0)))
	(cond
	 ((re-search-forward scm-mod-regexp end t)
	  ;; a path addition
	  (let ((ident (buffer-substring (match-beginning 1) (match-end 1)))
		(extent (make-extent (match-beginning 0)
				     (match-end 0))))
	    (set-extent-face extent bee-module-profile-face)
	    (set-extent-property extent 'prof (cons 'module ident))
	    (set-extent-property extent 'mouse-face 'highlight)
	    (set-extent-property extent 'keymap bee-profile-mouse-map)))
	 ((re-search-forward scm-id-regexp end t)
	  ;; a path addition
	  (let ((ident (buffer-substring (match-beginning 1) (match-end 1)))
		(extent (make-extent (match-beginning 0)
				     (match-end 0))))
	    (set-extent-face extent bee-ident-profile-face)
	    (set-extent-property extent 'prof (cons 'var ident))
	    (set-extent-property extent 'mouse-face 'highlight)
	    (set-extent-property extent 'keymap bee-profile-mouse-map)))
	 ((re-search-forward c-regexp end t)
	  ;; a C function
	  (let ((extent (make-extent (match-beginning 0)
				     (match-end 0))))
	    (set-extent-face extent 'bee-c-profile-face)))
	 (t
	  (bee-error (format "Illegal match %S" end))))
	(goto-char end)))
    (beginning-of-buffer)))

;*---------------------------------------------------------------------*/
;*    bee-profile-find ...                                             */
;*---------------------------------------------------------------------*/
(defun bee-profile-find (event)
  (interactive "e")
  (let* ((extent (event-glyph-extent event))
	 (point  (event-closest-point event))
	 (buffer (event-buffer event))
	 (extent (extent-at point buffer 'prof))
	 (prop   (extent-property extent 'prof)))
    (cond
     ((and (consp prop) (eq (car prop) 'var))
      (bee-find-definition (cdr prop)))
     ((and (consp prop) (eq (car prop) 'module))
      (bee-find-module (cdr prop))))))
     
      
    
