;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/bee/bee-flock.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May 25 08:00:32 1998                          */
;*    Last change :  Fri Feb 12 08:48:09 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Bee font-lockification                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-flock)
(require 'ude-config)
(require 'ude-autoload)

;*---------------------------------------------------------------------*/
;*    bee font-lock regexps ...                                        */
;*---------------------------------------------------------------------*/
(defvar bee-font-lock-keywords
  (list
   (list (concat "^\(\\(\\(?:define\\|define-inline\\|define-struct"
		 "\\|define-macro\\|define-generic\\|define-method"
		 "\\|define-syntax"
		 "\\|define-command\\)[ ]+\\(\(.*\)\\|[^ \n]+\\)\\)[ \n]")
	 1
	 'font-lock-function-name-face)
   (list "\(\\(\\(?:module\\|directives\\)[ ]+[^ \n]+\\)[ \n]"
         1
	 'ude-font-lock-face-1)
   (cons "\\(?:::[^ \n)]+\\|#![a-zA-Z]+\\)"
	 'ude-font-lock-face-4)
   (list (concat "\(\\(type\\|export\\|import\\|option\\|eval\\|main"
		 "\\|from\\|static\\|use\\|library"
		 "\\|include\\|foreign\\|extern\\|Cforeign\\)[ \n]")
	 1
	 'font-lock-type-face)
   (list (concat "\(\\(class\\|wide-class\\|final-class\\|generic"
		 "\\|inline\\|macro\\|infix[ ]macro\\)[ \n]")
	 1
	 'ude-font-lock-face-3)
   (list (concat "\(\\(let\\|let[*]\\|letrec\\|define"
		 "\\|set[!]\\|with-access\\|instantiate\\|duplicate"
		 "\\|widen[!]\\|shrink!\\|lambda\\|labels"
		 "\\|let-syntax\\|letrec-syntax"
		 "\\|regular-grammar\\|lalr-grammar"
		 "\\|if\\|begin\\|case\\|cond\\|else"
		 "\\|multiple-value-bind\\|values"
		 "\\|match-case\\|match-lambda"
		 "\\|string-case\\|syntax-rules\\)[ :\n]")
	 1
	 'font-lock-keyword-face)
   (cons "\\[assert[^\]]*\\]\\|\(assert[^\)]*\)"
	 'ude-font-lock-face-2)
   (list (concat "\(\\(error\\|warning\\|pragma\\|trace\\|"
		 "bind-exit\\|call/cc\\|try\\|\unwind-protect\\)"
		 "[ \n:]")
	 1
	 'ude-font-lock-face-2)))

;*---------------------------------------------------------------------*/
;*    bee-font-lock-get-info-keywords ...                              */
;*    -------------------------------------------------------------    */
;*    The Bee font lock keyword list for xinfo.                        */
;*---------------------------------------------------------------------*/
(defun bee-font-lock-get-info-keywords ()
  (append
   (list (cons "^[ ]+- \\(?:essential \\|library \\|bigloo \\|[CR][^ ]+ \\)?\\(?:\\(?:rgc \\)?procedure\\|generic\\|variable\\|Name\\|Class\\): .*$"
	       'font-lock-function-name-face)
	 (cons "^ - \\(?:essential \\|library \\|bigloo \\)?syntax: .*$"
	       'ude-font-lock-face-2)
	 (cons "^ - bigloo module clause: .*$"
	       'ude-font-lock-face-3)
	 (cons ":^[*] [^:]+:" 'font-lock-keyword-face)
	 (cons "\\([^=]=>\\|-|\\) .+$" 'ude-italic-face)
	 (cons "^ - bigloo class: .*$"
	       'ude-font-lock-face-4)
	 (cons ";;.*$" 'font-lock-comment-face)
	 (cons "\"[^\"]+\"" 'font-lock-string-face))
   bee-font-lock-keywords))
  
;*---------------------------------------------------------------------*/
;*    bee-html-fontify-html-buffer ...                                 */
;*---------------------------------------------------------------------*/
(defun bee-html-fontify-html-buffer ()
  (interactive)
  (ude-html-fontify-html-buffer 'bee-mode
				'(lambda (beg end)
				   (save-excursion
				     (goto-char beg)
				     (looking-at "[ \n\t]*[;(]"))))
  (save-buffer)
  (set-buffer-modified-p nil))
  
