;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/bee/bee-config.el              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May 25 07:28:09 1998                          */
;*    Last change :  Wed Feb 10 15:01:36 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Bee configuration file.                                      */
;*    -------------------------------------------------------------    */
;*    Bdb configuration is set into bee-bdb.el                         */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-config)
(require 'ude-custom)
(require 'dbg-config)

;; bee version
(defconst bee-version "0.0"
  "*The Bee version.")

;; bee group
(defgroup bee nil
  "Bigloo Emacs Environment."
  :tag "Bee"
  :prefix "bee-"
  :group 'processes)

;; online documentation info pages
(defcustom bee-info-file-list '("bigloo.info" "biglook.info" "r5rs.info")
  "*The info docline pages."
  :group 'bee
  :type '(repeat (string)))

;; compiler and interpreter
(defcustom bee-bigloo "bigloo"
  "*The name of the Bigloo compiler."
  :group 'bee
  :type 'string)

;; C extractor
(defcustom bee-cigloo "cigloo"
  "*The name of the Cigloo binary file."
  :group 'bee
  :type 'string)

;; indentation
(defcustom bee-external-indent "bpp"
  "*The external Bee indent program."
  :group 'bee
  :type 'string)

;; bigloo make-make
(defcustom bee-bmake "bmake"
  "*The name of the Bigloo Makefile generator.
Setting that variable must change the buffer local UDE-MAKEMAKE"
  :group 'bee
  :type 'string
  :set (lambda (symbol value)
	 (set-default symbol value)
	 (setq ude-makemake value)))

;; bee-bmake-application-option
(defcustom bee-bmake-application-option "-fapplication -main"
  "*The name of the bmake option to produce an application Makefile"
  :group 'bee
  :type 'string)

;; bee-bmake-library-option
(defcustom bee-bmake-library-option "-flibrary -heap"
  "*The name of the bmake option to produce a library Makefile"
  :group 'bee
  :type 'string)

;; compile configuration
(defcustom bee-compilation-font-lock-keywords
  '(("^#.*$" . font-lock-comment-face)
    ("^[^: ]+:$" . font-lock-function-name-face)
    ("^[^:]+:$" . font-lock-keyword-face)
    ("[0-9]+ error.? occured, ending.*$" . ude-error-face)
    ("Compilation finished.*$" . ude-ok-face))
  "The regular expressions for compilation font lock errors."
  :group 'bee)

(defcustom bee-error-regexp "^File \"\\([^\"]+\\)\", line \\([0-9]+\\)"
  "*The expression that matches Bigloo errors."
  :group 'bee
  :type 'string)

(defcustom bee-compilation-error-regexp-alist (list bee-error-regexp 1 2)
  "The expression for compilation errors."
  :group 'bee)

;; afile
(defcustom bee-afile-name ".afile"
  "*The name of the Bee afile file."
  :group 'bee
  :type 'string)

(defcustom bee-make-afile (concat ude-make " " bee-afile-name)
  "*The name of the command to build the afile."
  :group 'bee
  :type 'string)

;; tags
(defcustom bee-make-tags (concat ude-make " " ude-tagsfile-name)
  "*The name of the command to build the tagsfile."
  :group 'bee
  :type 'string)

;; profiling faces
(defcustom bee-ident-profile-face 'font-lock-function-name-face
  "The face to display Bigloo identifiers on profile."
  :group 'bee
  :type 'symbol)

(defcustom bee-module-profile-face 'ude-font-lock-face-1
  "The face to display Bigloo modules on profile."
  :group 'bee
  :type 'symbol)

(defface bee-c-profile-face
  '((((class color)) (:foreground "gray75" :bold nil))
    (t (:bold t)))
  "The face to display C identifiers on profile."
  :group 'bee)

;; user menu
(defcustom bee-user-menu nil
  "*Non-nil means a popup menu user part."
  :group 'bee
  :type 'boolean)

;; tmp dir (for macro expansion)
(defcustom bee-tmp-dir (let ((dir (getenv "TMPDIR")))
		      (if (stringp dir)
			  dir
			"/tmp"))
  "*The tmp directory."
  :group 'bee
  :type 'string)

;*---------------------------------------------------------------------*/
;*    bee-customize ...                                                */
;*    -------------------------------------------------------------    */
;*    This function invoked BEE customization in a new frame.          */
;*---------------------------------------------------------------------*/
(defun bee-customize ()
  "Invokes Ude customization in a new frame."
  (interactive)
  (if (ude-empty-window-p)
      (customize-group 'bee)
    (let ((pop-up-frames t))
      (customize-group-other-window 'bee))))






