;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bde/bprof/bprof.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May 31 07:37:29 1998                          */
;*    Last change :  Wed Nov 25 13:43:05 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Bigloo profiler utility.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module bprof
   (include "include/args.sch")
   (main    main))

;*---------------------------------------------------------------------*/
;*    Global parameters                                                */
;*---------------------------------------------------------------------*/
(define *bprof-version*   "0.0")
(define *bprof-verbose*   #f)
(define *bprof-prof*      "gprof")
(define *bprof-prof-args* "")
(define *bprof-bmon*      "bmon.out")

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   ;; we parse command line arguments
   (parse-args argv)
   ;; we have to load now the bmon.out file
   (load-bmon.out)
   ;; we now start prof.
   (gprof))

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args cmd-args)
   (define (usage args-parse-usage level)
      (print "usage: bprof -v [prof options] [ objfile [ gmon.out ] ]")
      (newline)
      (args-parse-usage)
      (newline)
      (exit 0))
   (args-parse (cdr cmd-args)
      (("?")
       (usage args-parse-usage 1))
      (("-help" (synopsis "This help message"))
       (usage args-parse-usage 1))
      (("-v" (synopsis "Be verbose"))
       (set! *bprof-verbose* #t))
      (else
       (set! *bprof-prof-args* (string-append *bprof-prof-args* " " else)))))

;*---------------------------------------------------------------------*/
;*    *demangling-env* ...                                             */
;*---------------------------------------------------------------------*/
(define *demangling-env*
   (make-hash-table 1024
		    (lambda (o) (string->0..2^x-1 o 10))
		    (lambda (x) (cadr x))
		    string=?
		    64))
;*---------------------------------------------------------------------*/
;*    load-bmon.out ...                                                */
;*---------------------------------------------------------------------*/
(define (load-bmon.out)
   (if (not (file-exists? *bprof-bmon*))
       (warning "bmon" "Can't find bmon.out file -- " *bprof-bmon*)
       (let ((iport (open-input-file *bprof-bmon*)))
	  (if (not (input-port? iport))
	      (warning "bmon" "Can't open file for input" *bprof-bmon*)
	      (unwind-protect
		 (let loop ((exp (extra-demangle (read iport))))
		    (if (not (eof-object? exp))
			(begin
			   (if (pair? exp)
			       (put-hash! exp *demangling-env*))
			   (loop (extra-demangle (read iport))))))
		 (close-input-port iport))))))

;*---------------------------------------------------------------------*/
;*    gprof ...                                                        */
;*---------------------------------------------------------------------*/
(define (gprof)
   (let* ((cmd  (string-append *bprof-prof* *bprof-prof-args*))
	  (port (open-input-file (string-append "| " cmd))))
      (unwind-protect
	 (read/rp *gprof-grammar* port)
	 (close-input-port port))))

;*---------------------------------------------------------------------*/
;*    *gprof-grammar* ...                                              */
;*---------------------------------------------------------------------*/
(define *gprof-grammar*
   (regular-grammar ()
      ((+ (out #\Space #\Tab #\Newline))
       (let* ((string (the-string))
	      (cell   (get-hash string *demangling-env*)))
	  (if (pair? cell)
	      (display (car cell))
	      (display string)))
       (ignore))
      ((+ (in #\Space #\Tab #\Newline))
       (display (the-string))
       (ignore))
      (else
       (the-failure))))
	  
;*---------------------------------------------------------------------*/
;*    extra-demangle ...                                               */
;*    -------------------------------------------------------------    */
;*    This function makes some extra demangling and hiding. It does    */
;*    the following transformations:                                   */
;*      1. Remove extra _[0-9]+ expression after Scheme identifiers.   */
;*      2. IMPORTED-MODULES-INIT is forgotten.                         */
;*      3. BIGLOO_MAIN is forgotten.                                   */
;*      4. PROF-INIT is forgotten.                                     */
;*      5. MODULE-INITIALIZATION is translated into @module-name.      */
;*      6. LIBRARY-MODULES-INIT is forgotten.                          */
;*---------------------------------------------------------------------*/
(define (extra-demangle expr)
   (match-case expr
      (((and ?scm (? symbol?)) ?c)
       (cond
	  ((memq scm '(BIGLOO_MAIN IMPORTED-MODULES-INIT
				   PROF-INIT
				   LIBRARY-MODULES-INIT))
	   #unspecified)
	  ((eq? scm 'MODULE-INITIALIZATION)
	   (let ((len (string-length c))
		 (len-min (string-length "module_initialization_")))
	      (if (>fx len len-min)
		  (let loop ((i len-min))
		     (cond
			((=fx i len)
			 #unspecified)
			((char-numeric? (string-ref c i))
			 (loop (+fx i 1)))
			(else
			 (list (string->symbol
				(string-append
				 "@"
				 (string-upcase (substring c (+fx i 1) len))))
			       c))))
		  #unspecified)))
	  (else
	   (let* ((name (symbol->string scm))
		  (len (string-length name)))
	      (let loop ((i (-fx len 1)))
		 (cond
		    ((=fx i 0)
		     expr)
		    ((char-numeric? (string-ref name i))
		     (loop (-fx i 1)))
		    ((char=? (string-ref name i) #\_)
		     (list (string->symbol (substring name 0 i)) c))
		    (else
		     expr)))))))
      (else
       expr)))
