;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bde/afile/afile.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:49:15 1993                          */
;*    Last change :  Thu Oct 29 08:49:56 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Module access file generator.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module afile (main main))

;*---------------------------------------------------------------------*/
;*    Global variables                                                 */
;*---------------------------------------------------------------------*/
(define *verbose*  #f)
(define *suffixes* '("scm" "sch" "bgl"))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (if (or (null?    (cdr argv))
	   (string=? (cadr argv) "-help"))
       (usage)
       (let loop ((files        (cdr argv))
		  (access-list '())
		  (output-file '()))
	  (cond
	     ((null? files)
	      (output access-list output-file))
	     ((string=? (car files) "-v")
	      (set! *verbose* #t)
	      (loop (cdr files) 
		    access-list
		    output-file))
	     ((string=? (car files) "-o")
	      (if (null? (cdr files))
		  (usage)
		  (loop (cddr files)
			access-list
			(cadr files))))
	     ((string=? (car files) "-suffix")
	      (if (null? (cdr files))
		  (usage)
		  (begin
		     (set! *suffixes* (cons (cadr files) *suffixes*))
		     (loop (cddr files)
			   access-list
			   output-file))))
	     (else
	      (loop (cdr files)
		    (cons (car files) access-list)
		    output-file))))))

;*---------------------------------------------------------------------*/
;*    my-open-input-file ...                                           */
;*---------------------------------------------------------------------*/
(define (my-open-input-file file-name)
   (if *verbose*
       (print file-name ":"))
   (open-input-file file-name))
 
;*---------------------------------------------------------------------*/
;*    output ...                                                       */
;*---------------------------------------------------------------------*/
(define (output access-list output-file)
   (let ((port (if (string? output-file)
		   (begin
		      (if (file-exists? output-file)
			  (rename-file output-file
				       (string-append output-file "~")))
		      (open-output-file output-file))
		   (current-output-port))))
      (fprint port
	      ";; " (getenv "PWD") #\Newline
	      ";; " (date) #\Newline
	      #\()
      (let loop ((access-list access-list))
	 (if (null? access-list)
	     (fprint port #\) #\Newline)
	     (begin
		(if (member (suffix (car access-list)) *suffixes*)
		    (fprint port
			    "  ("
			    (string-downcase
			     (symbol->string
			      (find-module-name (car access-list))))
			    " "
			    #\" (car access-list) #\" #\)))
		(loop (cdr access-list)))))))
	  
;*---------------------------------------------------------------------*/
;*    find-module-name ...                                             */
;*---------------------------------------------------------------------*/
(define (find-module-name file)
   (if (not (file-exists? file))
       (begin
	  (fprint (current-error-port) "*** ERROR:afile:" #\Newline
		  "Can't find file -- " file)
	  'no-such-module)
       (let ((port (my-open-input-file file)))
	  (if (not (input-port? port))
	      (begin
		 (fprint (current-error-port) "*** ERROR:afile:" #\Newline
			 "Can't open file -- " file)
		 'no-such-module)
	      (let ((exp (read port)))
		 (match-case exp
		    ((module ?module-name . ?-)
		     (close-input-port port)
		     module-name)
		    (else
		     (close-input-port port)
		     (fprint (current-error-port) "*** ERROR:afile:" #\Newline
			     "Illegal file format -- " file)
		     'illegal-file-format)))))))
	     
;*---------------------------------------------------------------------*/
;*    usage ...                                                        */
;*---------------------------------------------------------------------*/
(define (usage)
   (print "usage: afile [-o output] [-suffix suf] file ...")
   (exit -1))
