;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Tools/regexp.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Apr 13 06:38:26 1998                          */
;*    Last change :  Wed May  6 08:03:09 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The regexp interface.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_regexp
   (import engine_param)
   (extern (include "regex.h")
           (macro c-re_comp::string (::string) "re_comp")
           (macro c-re_exec::int    (::string) "re_exec"))
   (export (regexp-match?::bool ::bstring ::bstring)
	   (bdb-case::bstring ::bstring)))

;*---------------------------------------------------------------------*/
;*    bdb-case ...                                                     */
;*---------------------------------------------------------------------*/
(define (bdb-case string)
   (if *bdb-case-sensitive?*
       string
       (string-upcase string)))

;*---------------------------------------------------------------------*/
;*    *pattern* ...                                                    */
;*---------------------------------------------------------------------*/
(define *pattern* #unspecified)

;*---------------------------------------------------------------------*/
;*    regexp-comp ...                                                  */
;*---------------------------------------------------------------------*/
(define (regexp-comp pattern)
   (set! *pattern* pattern)
   (let ((rc (c-re_comp pattern)))
      (if (string-null? rc)
	  #t
	  (error "bdb" "can't compile regexp" pattern))))

;*---------------------------------------------------------------------*/
;*    regexp-exec ...                                                  */
;*---------------------------------------------------------------------*/
(define (regexp-exec string)
   (let ((rc (c-re_exec string)))
      (case rc
	 ((0) #f)
	 ((1) #t)
	 (else (error "bdb" "can't match string" rc)))))

;*---------------------------------------------------------------------*/
;*    regexp-match? ...                                                */
;*---------------------------------------------------------------------*/
(define (regexp-match? pattern string)
   (if (not (eq? *pattern* pattern))
       (regexp-comp pattern))
   (regexp-exec string))

