;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Tools/read.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  9 16:42:45 1998                          */
;*    Last change :  Fri Apr 10 07:35:17 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Some reading/parsing tools                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_read
   (export (port->string-list ::input-port)
	   (port->list        ::input-port)
	   (string->word-list ::bstring)
	   (string-first-word ::bstring)))

;*---------------------------------------------------------------------*/
;*    port->string-list ...                                            */
;*---------------------------------------------------------------------*/
(define (port->string-list port::input-port)
   (let ((gram (regular-grammar ((blank  (in #\space #\tab #a012 #\Newline))
				 (letter (out #\space #\tab #a012 #\Newline)))
		  ((+ blank)
		   (ignore))
		  ((+ letter)
		   (cons (the-string) (ignore)))
		  (else
		   '()))))
      (read/rp gram port)))

;*---------------------------------------------------------------------*/
;*    port->list ...                                                   */
;*---------------------------------------------------------------------*/
(define (port->list port::input-port)
   (let loop ((exp (read-case-sensitive port))
	      (res '()))
      (if (eof-object? exp)
	  (reverse! res)
	  (loop (read-case-sensitive port) (cons exp res)))))

;*---------------------------------------------------------------------*/
;*    string->word-list ...                                            */
;*---------------------------------------------------------------------*/
(define (string->word-list string)
   (let* ((port (open-input-string string))
	  (res  (port->string-list port)))
      (close-input-port port)
      res))

;*---------------------------------------------------------------------*/
;*    string-first-word ...                                            */
;*    -------------------------------------------------------------    */
;*    Returns the first word of a string of word.                      */
;*---------------------------------------------------------------------*/
(define (string-first-word string)
   (let* ((port (open-input-string string))
	  (gram (regular-grammar ((blank  (in #\space #\tab #a012 #\Newline))
				  (letter (out #\space #\tab #a012 #\Newline)))
		   ((+ blank)
		    (ignore))
		   ((+ letter)
		    (the-string))
		   (else
		    '())))
	  (res  (read/rp gram port)))
      (close-input-port port)
      res))
