;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Tools/file.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 11:38:53 1994                          */
;*    Last change :  Sat Apr 25 08:36:09 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Tools for file manipulations                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_file
   (export (find-file/path ::bstring ::obj)
	   (parse-ident    ::bstring)))

;*---------------------------------------------------------------------*/
;*    find-file/path ...                                               */
;*---------------------------------------------------------------------*/
(define (find-file/path name path)
   (if (file-exists? name)
       name
       (let loop ((path path))
	  (if (null? path)
	      #f
	      (let ((fname (string-append (car path) "/" name)))
		 (if (file-exists? fname)
		     fname
		     (loop (cdr path))))))))

;*---------------------------------------------------------------------*/
;*    parse-ident ...                                                  */
;*    -------------------------------------------------------------    */
;*    This function spill an function identifier into its file         */
;*    component and C identifier.                                      */
;*---------------------------------------------------------------------*/
(define (parse-ident string)
   (let ((len (string-length string)))
      (let loop ((walker    0)
		 (file-stop 0)
		 (fun-start 0))
	 (cond
	    ((=fx walker len)
	     (cond
		((and (=fx file-stop 0) (>fx fun-start 0))
		 (values (substring string fun-start len) #f))
		((=fx file-stop 0)
		 (values string #f))
		((=fx fun-start len)
		 (values #f string))
		(else
		 (let ((fil-id (substring string 0 file-stop))
		       (fun-id (substring string fun-start len)))
		    (values fun-id fil-id)))))
	    ((char=? (string-ref string walker) #\:)
	     (loop (+fx walker 1) walker (+fx walker 1)))
	    (else
	     (loop (+fx walker 1) file-stop fun-start))))))

