;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Tools/echo.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Apr 20 18:06:42 1998                          */
;*    Last change :  Tue May 12 20:59:52 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We display gdb output.                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_echo
   (import engine_param)
   (export (gdb-echo str)
	   (gdb-echo* . str)
	   (gdb-start-echo)
	   (gdb-stop-echo)))

;*---------------------------------------------------------------------*/
;*    gdb-echo ...                                                     */
;*    -------------------------------------------------------------    */
;*    Args is a list of strings.                                       */
;*---------------------------------------------------------------------*/
(define (gdb-echo str)
   (gdb-start-echo)
   (display str)
   (gdb-stop-echo)
   (flush-output-port (current-output-port)))

;*---------------------------------------------------------------------*/
;*    gdb-echo* ...                                                    */
;*---------------------------------------------------------------------*/
(define (gdb-echo* . str)
   (gdb-start-echo)
   (for-each display str)
   (gdb-stop-echo)
   (flush-output-port (current-output-port)))

;*---------------------------------------------------------------------*/
;*    gdb-start-echo ...                                               */
;*---------------------------------------------------------------------*/
(define (gdb-start-echo)
   (if *bdb-emacs?* (print "gdb-io-start")))
   
;*---------------------------------------------------------------------*/
;*    gdb-stop-echo ...                                                */
;*---------------------------------------------------------------------*/
(define (gdb-stop-echo)
   (if *bdb-emacs?* (print "gdb-io-stop")))

