/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/bdb/Readline/read.c                  */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Apr  8 13:01:06 1998                          */
/*    Last change :  Thu Jan 28 12:37:26 1999 (serrano)                */
/*    -------------------------------------------------------------    */
/*    This file implement the connection with read-line.               */
/*=====================================================================*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <readline/readline.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    extern definitions                                               */
/*---------------------------------------------------------------------*/
extern obj_t command_generator( char *, int );

/*---------------------------------------------------------------------*/
/*    Prompt                                                           */
/*---------------------------------------------------------------------*/
char *gdb_prompt          = "(bdb) ";
char *regular_gdb_prompt  = "(gdb) ";
char *bdb_prompt          = ":=> ";
char *commands_prompt     = "> ";

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    read_cmd_line ...                                                */
/*---------------------------------------------------------------------*/
obj_t read_cmd_line( char *prompt ) {
   char *line_read;
   obj_t res;

   /* the phyiscal read */
   if( !(line_read = readline( prompt )) )
      return BEOF;

   /* if the line has any text in it, save it on the history. */
   if( line_read && *line_read )
      add_history( line_read );

   /* we allocate a Bigloo string that we return */
   res = string_to_bstring( line_read );
   free( line_read );
   
   return res;
}

/*---------------------------------------------------------------------*/
/*    char *                                                           */
/*    stub_command_generator ...                                       */
/*---------------------------------------------------------------------*/
char *stub_command_generator( char *text, int state ) {
   obj_t bres;

   bres = command_generator( text, state );
   
   if( STRINGP( bres ) ) {
      char *res;

      res = malloc( STRING_LENGTH( bres ) + 1 );
      strcpy( res, BSTRING_TO_STRING( bres ) );

      return res;
   }
   else
      return 0;
}

/*---------------------------------------------------------------------*/
/*    static char **                                                   */
/*    bdb_completion ...                                               */
/*---------------------------------------------------------------------*/
static char **bdb_completion( char *text, int start, int end ) {
   return completion_matches( rl_line_buffer, stub_command_generator );
}

/*---------------------------------------------------------------------*/
/*    char **                                                          */
/*    bdb_nofilename_completion ...                                    */
/*---------------------------------------------------------------------*/
char **
bdb_nofilename_completion() {
   return NULL;
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    initialize_readline ...                                          */
/*---------------------------------------------------------------------*/
void initialize_readline() {
   rl_completion_entry_function = (Function *)bdb_nofilename_completion;
   rl_attempted_completion_function  = (CPPFunction *)bdb_completion;
}









