;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Lib/wcircle.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May  7 14:44:08 1998                          */
;*    Last change :  Wed May 13 10:57:53 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The write-circle function.                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __write-circle
   (export (write-circle obj . port)))

;*---------------------------------------------------------------------*/
;*    write-circle ...                                                 */
;*---------------------------------------------------------------------*/
(define (write-circle obj . port)
   (write-circle/stack obj
		       (if (pair? port) (car port) (current-output-port))
		       '()))

;*---------------------------------------------------------------------*/
;*    write-circle/stack ...                                           */
;*---------------------------------------------------------------------*/
(define (write-circle/stack obj port stack)
   (cond
      ((memq obj stack)
       (display "..." port))
      ((or (fixnum? obj)
	   (char? obj)
	   (ucs2? obj)
	   (string? obj)
	   (ucs2-string? obj))
       (write obj port))
      ((vector? obj)
       (write-circle/stack-vector obj port stack))
      ((pair? obj)
       (write-circle/stack-pair obj port stack))
      ((flonum? obj)
       (display-flonum obj port))
      ((cell? obj)
       (write-circle/stack-cell obj port stack))
      ((struct? obj)
       (write-circle/stack-structure obj port stack))
      ((tvector? obj)
       (write-circle/stack-tvector obj port stack))
      ((object? obj)
       (write-circle/stack-object obj port stack))
      (else
       (write obj port)))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    write-circle/stack-cell ...                                      */
;*---------------------------------------------------------------------*/
(define (write-circle/stack-cell obj port stack)
   (display "#<cell:" port)
   (write-circle/stack (cell-ref obj) port (cons obj stack))
   (display ">" port))

;*---------------------------------------------------------------------*/
;*    write-circle/stack-structure ...                                 */
;*---------------------------------------------------------------------*/
(define (write-circle/stack-structure obj port stack)
   (display "#{")
   (display (struct-key obj) port)
   (if (=fx 0 (struct-length obj))
       (write-char #\} port)
       (let ((len   (-fx (struct-length obj) 1))
	     (stack (cons obj stack)))
	  (write-char #\space port)
	  (let loop ((i 0))
	     (cond
		((=fx i len)
		 (write-circle/stack (struct-ref obj i) port stack)
		 (write-char #\} port))
		(else
		 (write-circle/stack (struct-ref obj i) port stack)
		 (write-char #\space port)
		 (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write-circle/stack-vector ...                                    */
;*---------------------------------------------------------------------*/
(define (write-circle/stack-vector obj port stack)
   (write-char #\# port)
   (let ((tag (vector-tag obj)))
      (if (>fx tag 0)
	  (begin
	     (if (>=fx tag 100)
		 (write tag port)
		 (begin
		    (write-char #\0 port)
		    (if (>=fx tag 10)
			(write tag port)
			(begin
			   (write-char #\0 port)
			   (write tag port))))))))
   (write-char #\( port)
   (if (=fx 0 (vector-length obj))
       (write-char #\) port)
       (let ((len   (-fx (vector-length obj) 1))
	     (stack (cons obj stack)))
	  (let loop ((i 0))
	     (cond
		((=fx i len)
		 (write-circle/stack (vector-ref obj i) port stack)
		 (write-char #\) port))
		(else
		 (write-circle/stack (vector-ref obj i) port stack)
		 (write-char #\space port)
		 (loop (+fx 1 i))))))))
 
;*---------------------------------------------------------------------*/
;*    write-circle/stack-tvector ...                                   */
;*---------------------------------------------------------------------*/
(define (write-circle/stack-tvector obj port stack)
   (let ((tvector-ref (tvector-ref obj))
	 (id          (tvector-id obj)))
      (write-char #\# port)
      (write id port)
      (write-char #\( port)
      (if (not tvector-ref)
	  (begin
	     (display "...)" port)
	     obj)
	  (begin
	     (if (=fx 0 (tvector-length obj))
		 (write-char #\) port)
		 (let ((len (-fx (tvector-length obj) 1))
		       (stack (cons obj stack)))
		    (let loop ((i 0))
		       (cond
			  ((=fx i len)
			   (write-circle/stack (tvector-ref obj i)
					  port
					  stack)
			   (write-char #\) port))
			  (else
			   (write-circle/stack (tvector-ref obj i)
					  port
					  stack)
			   (write-char #\space port)
			   (loop (+fx 1 i)))))))))))

;*---------------------------------------------------------------------*/
;*    write-circle/stack-object ...                                    */
;*---------------------------------------------------------------------*/
(define (write-circle/stack-object obj port stack)
   (let ((old-length (get-write-length)))
      (set-write-length! 80)
      (object-write obj port)
      (set-write-length! old-length)))

;*---------------------------------------------------------------------*/
;*    write-circle/stack-pair ...                                      */
;*---------------------------------------------------------------------*/
(define (write-circle/stack-pair obj port stack)
   (write-char #\( port)
   (let loop ((l     obj)
	      (stack (cons obj stack)))
      (cond
	 ((null? (cdr l))
	  (write-circle/stack (car l) port stack)
	  (write-char #\) port))
	 ((not (pair? (cdr l)))
	  (write-circle/stack (car l) port stack)
	  (write-char #\space port)
	  (write-char #\. port)
	  (write-char #\space port)
	  (write-circle/stack (cdr l) port (cons (car l) stack))
	  (write-char #\) port))
	 (else
	  (write-circle/stack (car l) port stack)
	  (write-char #\space port)
	  (let ((stack (cons (car l) (cons l stack))))
	     (if (memq (cdr l) stack)
		 (display "...)")
		 (loop (cdr l) stack)))))))
