/*---------------------------------------------------------------------*/
/*   A pratical implementation for the Scheme programming language     */
/*                                                                     */
/*                                    ,--^,                            */
/*                              _ ___/ /|/                             */
/*                          ,;'( )__, ) '                              */
/*                         ;;  //   L__.                               */
/*                         '   \\   /  '                               */
/*                              ^   ^                                  */
/*                                                                     */
/*   Copyright (c) 1992-1999 Manuel Serrano                            */
/*                                                                     */
/*     Bug descriptions, use reports, comments or suggestions are      */
/*     welcome. Send them to                                           */
/*       bigloo-request@kaolin.unice.fr                                */
/*       http://kaolin.unice.fr/bigloo                                 */
/*                                                                     */
/*   This program is free software; you can redistribute it            */
/*   and/or modify it under the terms of the GNU General Public        */
/*   License as published by the Free Software Foundation; either      */
/*   version 2 of the License, or (at your option) any later version.  */
/*                                                                     */
/*   This program is distributed in the hope that it will be useful,   */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*   GNU General Public License for more details.                      */
/*                                                                     */
/*   You should have received a copy of the GNU General Public         */
/*   License along with this program; if not, write to the Free        */
/*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
/*   MA 02111-1307, USA.                                               */
/*---------------------------------------------------------------------*/
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/bdb/Lib/bdb.h                        */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sun Apr 12 09:50:35 1998                          */
/*    Last change :  Mon Jun  8 15:37:41 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    The Bdb include file.                                            */
/*=====================================================================*/
#ifndef BDB_H
#define BDB_H
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    The shared memory segment size                                   */
/*    -------------------------------------------------------------    */
/*    This value must be smaller than 0xffff because the string        */
/*    length encoding will be done using 4 bytes.                      */
/*---------------------------------------------------------------------*/
#if( !defined( SHMMAX ) )
#   define SHMMAX 0x2000000
#endif

#define SHSIZE                                             \
   ((OUTPUT_STRING_PORT_BUFFER_SIZE - 5) * 100) > SHMMAX ? \
   SHMMAX : (((OUTPUT_STRING_PORT_BUFFER_SIZE - 5) * 100))

#endif
