;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Init/parse-args.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 29 11:56:20 1995                          */
;*    Last change :  Sat Oct 10 15:02:24 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Command-line parsing                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module init_parse-args
   (include "Init/args.sch")
   (export  (parse-args args::pair))
   (import  engine_param
	    tools_version))

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args cmd-args)
   
   (args-parse (cdr cmd-args)
      ;; gdb compatibility
      (section "Gdb compatibility")
      (("--quiet" (synopsis "Do not print version number on startup."))
       (set! *verbose* -1))
      ;; help
      (("--help" (synopsis "Print this message."))
       (help args-parse-usage))
      (("-help")
       (help args-parse-usage))
      (("?")
       (help args-parse-usage))
      (("-v" (synopsis "-v[23]" "Set verbose mode on."))
       (set! *verbose* 1))
      (("-v2")
       (set! *verbose* 2))
      (("-v3")
       (set! *verbose* 3))
      ;; emacs mode
      (("--emacs" (synopsis "Use bdb emacs mode"))
       (set! *bdb-emacs?* #t))
      ;; executable
      (else
       (if (string? *exec*)
	   (set! *args* (cons else *args*))
	   (set! *exec* else)))))
	
;*---------------------------------------------------------------------*/
;*    query ...                                                        */
;*---------------------------------------------------------------------*/
(define (query)
   (version)
   (newline)
   (exit 0))

;*---------------------------------------------------------------------*/
;*    help ...                                                         */
;*---------------------------------------------------------------------*/
(define (help usage)
   (version)
   (print "usage: bdb [options] executable-file")
   (newline)
   (usage)
   (newline)
   (print "Runtime Command file:")
   (print "   - ~/.bdbrc")
   (exit 0))


   
