;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Engine/server.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 30 09:11:52 1998                          */
;*    Last change :  Mon Nov 23 09:29:07 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We start a socket server                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_server
   
   (import engine_engine)
   
   (extern (export close-server! "bdb_close_socket_server"))
   
   (export (init-server!)
	   (close-server!)
	   (init-client!)
	   (reset-server!)
	   (send-to-client::bstring ::bstring)))

;*---------------------------------------------------------------------*/
;*    *server* ...                                                     */
;*---------------------------------------------------------------------*/
(define *server* #unspecified)

;*---------------------------------------------------------------------*/
;*    init-server! ...                                                 */
;*    -------------------------------------------------------------    */
;*    This function setup the socker server that will communicate      */
;*    with the bigloo running process (the client).                    */
;*---------------------------------------------------------------------*/
(define (init-server!)
   (set! *server* (make-server-socket))
   (if (not (socket? *server*))
       (error "bdb" "Can't setup server" *server*))
   ;; we register the server termination
   (pragma "atexit( (void (*)(void))bdb_close_socket_server )" )
   ;; we return from this setup
   0)

;*---------------------------------------------------------------------*/
;*    close-server! ...                                                */
;*    -------------------------------------------------------------    */
;*    We are done with bdb, we stop the server.                        */
;*---------------------------------------------------------------------*/
(define (close-server!)
   (if (socket? *server*)
       (begin
	  (socket-shutdown *server*)
	  (set! *server* #unspecified))))

;*---------------------------------------------------------------------*/
;*    substring-at=? ...                                               */
;*---------------------------------------------------------------------*/
(define (substring-at=? str1 str2 start1 len)
   (let ((len1 (string-length str1))
	 (len2 (string-length str2)))
      (and (>=fx (-fx len1 start1) len)
	   (>=fx len2 len)
	   (let loop ((read1 start1)
		      (read2 0))
	      (cond
		 ((=fx read2 len)
		  #t)
		 ((char=? (string-ref str1 read1)
			  (string-ref str2 read2))
		  (loop (+fx read1 1) (+fx read2 1)))
		 (else
		  #f))))))
	      
;*---------------------------------------------------------------------*/
;*    init-client! ...                                                 */
;*---------------------------------------------------------------------*/
(define (init-client!)
   (let* ((cmd (string-append "call bdb_init_client( "
			      (integer->string (socket-port-number *server*))
			      " )"))
	  (res (gdb-send-for-output cmd))
	  (gram (regular-grammar ((blank (+ (in #\space #\tab))))
		   ((: #\$ (+ (in (#\0 #\9))) blank #\= blank #\0)
		    #t)
		   (else
		    #f)))
	  (port (open-input-string res)))
      (let ((res (read/rp gram port)))
	 (close-input-port port)
	 res)))

;*---------------------------------------------------------------------*/
;*    send-to-client ...                                               */
;*    -------------------------------------------------------------    */
;*    This function sends a command to the bdb client (the Bigloo      */
;*    running process) and read the result of the command thru the     */
;*    socket server port. The first time this function is invoked,     */
;*    the connection is established.                                   */
;*---------------------------------------------------------------------*/
(define (send-to-client::bstring cmd::bstring)
;*    (newline)                                                        */
;*    (print "***CLIENT: [" cmd "] "                                   */
;* 	  (socket-input *server*) " "                                  */
;* 	  (socket-output *server*) " "                                 */
;* 	  (socket-down? *server*) " "                                  */
;* 	  (socket-hostname *server*))                                  */
   (if (not (and (input-port? (socket-input *server*))
		 (output-port? (socket-output *server*))))
       (begin
;* 	  (print "accepting-connections...")                           */
	  (socket-accept-connection *server*)))
   (gdb-send-string cmd)
   (gdb-send-string #"\n")
;*    (print "listening...")                                           */
   (let ((reply (read (socket-input *server*))))
      (let ((listen (gdb-listen-result)))
;* 	 (print "listen: [" listen "]")                                */
	 #unspecified)
;*       (print "reply: [" (string-for-read reply) "]")                */
      ;; we have to flush extra characters
      (reset-server!)
      (if (not (string? reply))
	  ""
	  reply)))
	 
;*---------------------------------------------------------------------*/
;*    reset-server! ...                                                */
;*---------------------------------------------------------------------*/
(define (reset-server!)
   (socket-shutdown *server* #f))
	   
