;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/out/bigloo1.9e/bdb/Engine/param.scm                      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 29 11:45:41 1995                          */
;*    Last change :  Fri Jan 15 09:24:07 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Configuration variables                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_param
   (extern  (*gdb-prompt*::string         "gdb_prompt")
	    (*bdb-prompt*::string         "bdb_prompt")
	    (*regular-gdb-prompt*::string "regular_gdb_prompt")
	    (*commands-prompt*::string    "commands_prompt")
	    (export *bdb-emacs?*          "bdb_emacsp"))
   (import  tools_date)
   (export  *bdb-version*
	    *bdb-name*
	    *bdb-level*
	    *bdb-args*
	    *bdb-rest-args*
	    *bdb-author*
	    *bdb-email*
	    *bdb-date*
	    *bdb-tmp*
	    *verbose*
	    *exec*
	    *args*
	    *bdb-gdb*
	    *bdb-case-sensitive?*
	    *bdb-emacs?*
	    *bdb-emacs-echo-marker*))

;*---------------------------------------------------------------------*/
;*    compiler and author names ...                                    */
;*---------------------------------------------------------------------*/
(define *bdb-version*    "0.0")
(define *bdb-name*       (string-append "Bdb (v" *bdb-version* ")"))
(define *bdb-level*      #f)
(define *bdb-cmd-name*   'nothing-yet)
(define *bdb-args*       'nothing-yet)
(define *bdb-rest-args*  '())
(define *bdb-author*     "Manuel Serrano")
(define *bdb-email*      "Manuel.Serrano@unice.fr")
(define *bdb-date*       (bdb-date))
(define *bdb-tmp*        (let ((Venv (getenv "TMPDIR")))
			      (if (string? Venv)
				  Venv
				  "/tmp")))
(define *bdb-gdb*        "gdb")

;*---------------------------------------------------------------------*/
;*    Compiler controls                                                */
;*---------------------------------------------------------------------*/
(define *verbose*        0)

;*---------------------------------------------------------------------*/
;*    file names                                                       */
;*---------------------------------------------------------------------*/
(define *exec*           #f)

;*---------------------------------------------------------------------*/
;*    Execution arguments                                              */
;*---------------------------------------------------------------------*/
(define *args*           '())

;*---------------------------------------------------------------------*/
;*    case sensitivity ...                                             */
;*---------------------------------------------------------------------*/
(define *bdb-case-sensitive?* #f)

;*---------------------------------------------------------------------*/
;*    *bdb-emacs?* ...                                                 */
;*---------------------------------------------------------------------*/
(define *bdb-emacs?* #f)

;*---------------------------------------------------------------------*/
;*    *bdb-emacs-echo-marker* ...                                      */
;*---------------------------------------------------------------------*/
(define *bdb-emacs-echo-marker* #a026)
