;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Engine/engine.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul 12 15:53:47 1995                          */
;*    Last change :  Sun Oct 25 09:05:23 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We have read the argument line. We start the real compilation    */
;*    process.                                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_engine
   
   (extern (include "signal.h")
	   (gdb-send-string::int (::bstring)       "gdb_send_string")
	   (gdb-listen-result::bstring ()          "gdb_listen_result")
	   (gdb-init-process::obj (::string ::obj) "gdb_init_process")
	   (gdb-kill-process::obj ()               "gdb_kill_process")
	   (initialize-readline!::obj ()           "initialize_readline"))
   
   (export (bdb)
	   (bdb-sans-hello)
	   (gdb-send-for-output::bstring  ::bstring)
	   (gdb-send-for-output*::bstring ::obj)
	   (gdb-send-for-value::bstring   ::bstring)
	   (dummy-run! ::procedure)
	   (bdb-exit ::int))
   
   (import tools_speek
	   tools_file
 	   tools_version
	   tools_echo
	   tools_regexp
	   engine_param
	   engine_error
	   engine_server
	   command_file
	   command_parse
	   command_command
	   command_completion
	   command_eval
	   command_display
	   command_bbreak))

;*---------------------------------------------------------------------*/
;*    *bdb-exit* ...                                                   */
;*    -------------------------------------------------------------    */
;*    This variable is set when the repl is started. It is a pointer   */
;*    to a lexical escape from the repl or the Bigloo exit function.   */
;*---------------------------------------------------------------------*/
(define *bdb-exit* exit)

;*---------------------------------------------------------------------*/
;*    bdb-exit ...                                                     */
;*---------------------------------------------------------------------*/
(define (bdb-exit val)
   (if (procedure? *bdb-exit*)
       (*bdb-exit* val)
       (exit val)))

;*---------------------------------------------------------------------*/
;*    bdb ...                                                          */
;*---------------------------------------------------------------------*/
(define (bdb)
   (if (>= *verbose* 0)
       (version))
   (bdb-sans-hello))

;*---------------------------------------------------------------------*/
;*    bdb-sans-hello ...                                               */
;*---------------------------------------------------------------------*/
(define (bdb-sans-hello)
   (cond
      ((not (string? *exec*))
       (gdb-echo* #"No executable file!\n")
       (repl-file-name))
      ((not (file-exists? *exec*))
       (gdb-echo* *exec* #": No such file or directory.\n")
       (repl-file-name))
      ((directory? *exec*)
       (gdb-echo* *exec* #": Illegal file (directory).\n")
       (repl-file-name))
      (else
       ;; we have to setup the bdb signal handling (that is C-c)
       (init-signal-handler!)
       ;; we prepare for the exit machinery
       (bind-exit (exit)
	  (set! *bdb-exit* exit)
	  ;; then we start the gdb process
	  (if (gdb-init-process *bdb-gdb* *exec*)
	      (unwind-protect
		 ;; the gdb process is launched, we have to setup the server
		 (if (init-server!)
		     (unwind-protect
			(repl)
			(close-server!)))
		 (begin
		    (dump-assertions!)
		    (gdb-kill-process)
		    (newline))))))))

;*---------------------------------------------------------------------*/
;*    init-signal-handler! ...                                         */
;*---------------------------------------------------------------------*/
(define (init-signal-handler!)
   (let ((kill-my-self (lambda (n)
			  (notify-error "bdb"
					"Illegal signal caught, aborting"
					n)
			  (exit -1))))
      (signal sigfpe kill-my-self)
      (signal sigill kill-my-self)
      (signal sigbus kill-my-self)
      (signal sigsegv kill-my-self)
      (signal sigint
	      (lambda (signal)
		 'ignore))))
	   
;*---------------------------------------------------------------------*/
;*    repl-file-name ...                                               */
;*    -------------------------------------------------------------    */
;*    The user has given a file that doesn't exit. We read input       */
;*    until an existing file is given. No command is accepted but      */
;*    `file'.                                                          */
;*---------------------------------------------------------------------*/
(define (repl-file-name)
   (let loop ((line (read-cmd-line *gdb-prompt*)))
      (if (not (eof-object? line))
	  (let ((cmd (parse-input-line line)))
	     (cond
		((gdb-input? cmd)
		 (let ((string (gdb-input-string cmd)))
		    (cond
		       ((substring=? string "file " 5)
			(let ((exec (substring string
					       5
					       (string-length string))))
			   (set! *exec* exec)
			   (bdb-sans-hello)))
		       ((substring=? string "quit" 4)
			(exit 0))
		       (else
			(gdb-echo
			 #"You have to select an existing file first...\n")
			(loop (read-cmd-line *gdb-prompt*))))))
		((or (bdb-input? cmd) (bigloo-input? cmd))
		 (gdb-echo #"You have to select an existing file first...\n")
		 (loop (read-cmd-line *gdb-prompt*)))
		(else
		 (loop (read-cmd-line *gdb-prompt*))))))))
   
;*---------------------------------------------------------------------*/
;*    repl ...                                                         */
;*---------------------------------------------------------------------*/
(define (repl)
   ;; first we start a dummy execution to fetch the Bigloo symbols
   (if (load-bigloo-symbols! *exec*)
       (begin
	  ;; we initialize assertions
	  (load-assertions! *exec*)
	  ;; we initialize readline (mostly completion initialization)
	  (initialize-readline!)
	  ;; and the bdb command
	  (initialize-bdb-commands!)
	  ;; we now initialize bdb error handling
	  (initialize-bdb-error-handling!)
	  ;; and now we start the bdb read-eval-print loop
	  (let loop ((line (read-cmd-line *gdb-prompt*)))
	     (cond
		((eof-object? line)
		 'done)
		((string=? line "")
		 (loop (read-cmd-line *gdb-prompt*)))
		(else
		 (let ((cmd (parse-input-line line)))
		    (cond
		       ((gdb-input? cmd)
			(set! *bdb-last-command* line)
			(let ((string (gdb-input-string cmd)))
			   (gdb-echo (gdb-send-for-output string))
			   ;; when shall we display display?
			   (if (and (not *bdb-emacs?*)
				    (regexp-match?
				     "^[nscru]\\|^fi\\|^bret\\|^b[sncuf]"
				     string))
			       (display-display-command)))
			#unspecified)
		       ((bdb-input? cmd)
			(set! *bdb-last-command* line)
			(let ((command   (bdb-input-command cmd))
			      (line-list (bdb-input-line-list cmd)))
			   ((command-action command) line line-list)))
		       ((bigloo-input? cmd)
			(set! *bdb-last-command* line)
			(bdb-eval (bigloo-input-string cmd))))
		    (loop (read-cmd-line *gdb-prompt*)))))))
       (repl-file-name)))

;*---------------------------------------------------------------------*/
;*    *bdb-last-command* ...                                           */
;*---------------------------------------------------------------------*/
(define *bdb-last-command* #f)

;*---------------------------------------------------------------------*/
;*    *dummy-run-armed?* ...                                           */
;*---------------------------------------------------------------------*/
(define *dummy-run-armed?* #f)

;*---------------------------------------------------------------------*/
;*    dummy-run! ...                                                   */
;*    -------------------------------------------------------------    */
;*    We start a dummy run to fetch locals bindings and we stop the    */
;*    execution.                                                       */
;*---------------------------------------------------------------------*/
(define (dummy-run! call-back)
   (if *dummy-run-armed?*
       '()
       (begin
	  (set! *dummy-run-armed?* #t)
	  (cond
	     ((not (regexp-match? "Symbol \"bdb_initial_breakpoint\" is at"
				  (gdb-send-for-output
				   "info addre bdb_initial_breakpoint")))
	      ;; we are not able to find the initial breakpoint, nothing
	      ;; to do
	      (set! *dummy-run-armed?* #f)
	      '())
	     (else
	      ;; then we set a temporary break point inside the debugger
	      (gdb-send-for-output "tbreak bdb_initial_breakpoint")
	      ;; and we start the dummy execution.
	      (let ((args (get-run-arguments)))
		 (gdb-send-for-output "run > /dev/null 2> /dev/null")
		 ;; since the process is now started we can re-ask the
		 ;; running process info about its locals bindings
		 (let ((res (call-back)))
		    ;; and we just have to kill the gdb child process by now.
		    (gdb-send-for-output "kill")
		    ;; we restore the gdb child args
		    (gdb-send-for-output (string-append "set args " args))
		    ;; dummy-run is now done
		    (set! *dummy-run-armed?* #f)
		    res)))))))
	  
;*---------------------------------------------------------------------*/
;*    gdb-send-for-output ...                                          */
;*---------------------------------------------------------------------*/
(define (gdb-send-for-output::bstring cmd::bstring)
;*    (newline)                                                        */
;*    (print "*** FOR-OUTPUT[" cmd "]")                                */
   (gdb-send-string cmd)
   (gdb-send-string #"\n")
   (gdb-listen-result))

;*---------------------------------------------------------------------*/
;*    gdb-send-for-output* ...                                         */
;*---------------------------------------------------------------------*/
(define (gdb-send-for-output*::bstring cmd)
   (for-each gdb-send-string cmd)
   (gdb-listen-result))

;*---------------------------------------------------------------------*/
;*    gdb-send-for-value ...                                           */
;*---------------------------------------------------------------------*/
(define (gdb-send-for-value::bstring cmd::bstring)
   ;; we have to start the client
   (if (not (init-client!))
       (error "bdb" "Can't setup client" #unspecified)
       (send-to-client cmd)))


   

      
