;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/set.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 17 18:05:18 1998                          */
;*    Last change :  Tue Jun 30 10:57:03 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The set/show overriden command                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_set
   (import tools_read
	   tools_echo
	   engine_param
	   engine_engine
	   env_env)
   (export (show-command                  ::bstring ::obj)
	   (set-case-sensitivity-command  ::bstring ::obj)
	   (show-case-sensitivity-command ::bstring ::obj)))

;*---------------------------------------------------------------------*/
;*    show-command ...                                                 */
;*---------------------------------------------------------------------*/
(define (show-command line line-list)
   (match-case line-list
      ((?-)
       (gdb-start-echo)
       (display (gdb-send-for-output line))
       (display "case: ")
       (gdb-stop-echo)
       (show-case-sensitivity-command line line-list))
      (else
       (gdb-echo (gdb-send-for-output line)))))

;*---------------------------------------------------------------------*/
;*    set-case-sensitivity-command ...                                 */
;*---------------------------------------------------------------------*/
(define (set-case-sensitivity-command line line-list)
   (match-case line-list
      ((?- ?- ?val)
       (cond
	  ((string=? val "on")
	   (set! *bdb-case-sensitive?* #t))
	  ((string=? val "off")
	   (set! *bdb-case-sensitive?* #f))
	  (else
	   (gdb-echo #"\"on\" or \"off\" expected.\n"))))
      ((?- ?-)
       'nothing-at-all)
      (else
       (gdb-echo (gdb-send-for-output line)))))

;*---------------------------------------------------------------------*/
;*    show-case-sensitivity-command ...                                */
;*---------------------------------------------------------------------*/
(define (show-case-sensitivity-command line line-list)
   (gdb-echo* "Bdb case sensitivity is "
	      (if *bdb-case-sensitive?* "on." "off.")
	      #\Newline))

