;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/replay.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Oct 23 18:19:27 1998                          */
;*    Last change :  Sat Oct 24 08:15:49 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The record/replay command implementation                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_replay
   (extern (macro kill::int (::long ::int) "kill")
	   (macro SIGKILL::int             "SIGKILL")
	   (macro SIGSTOP::int             "SIGSTOP")
	   (macro SIGUSR1::int             "SIGUSR1"))
   (import command_command
	   env_env
	   (gdb-send-for-output engine_engine)
	   (get-current-global command_bfunction)
	   (gdb-echo tools_echo)
	   (gdb-echo* tools_echo)
	   (bdb-eval-environment command_eval)
	   (gdb-send-for-value engine_engine))
   (export (replay-command ::bstring ::pair)
	   (record-command ::bstring ::pair))
   (static (class record
	      (num::bstring  read-only)
	      (ppid::bstring read-only)
	      (cpid::bstring read-only)
	      (pc::bstring   read-only))))

;*---------------------------------------------------------------------*/
;*    replay-command ...                                               */
;*---------------------------------------------------------------------*/
(define (replay-command line line-list)
   (define (replay num)
      (let ((record (find-record num)))
	 (if (record? record)
	     (with-access::record record (num ppid cpid)
		(print "kill " ppid " " SIGSTOP)
		(kill (string->integer ppid) SIGSTOP)
		;; we first have to detach the running process
		(print "detach")
		(print (gdb-send-for-output "detach"))
		;; we resume the child
		(print "kill " cpid " " SIGUSR1)
		(kill (string->integer cpid) SIGUSR1)
		;; we attach the new process
		(print "attach " cpid)
		(print (gdb-send-for-output (string-append "attach " cpid)))
		)))) 
   (match-case line-list
      ((?-)
       (replay 'first-record))
      ((?- ?num)
       (replay num))
      (else
       (gdb-echo (string-append "A parse error in expression, near `"
				line
				#"'.\n")))))

;*---------------------------------------------------------------------*/
;*    record-command ...                                               */
;*---------------------------------------------------------------------*/
(define (record-command line line-list)
   (match-case line-list
      ((?-) 
       (let* ((pc  (gdb-send-for-output "print $pc"))
	      (res (gdb-send-for-value "call bdb_record_process()")))
	  (string-case res
	     ((: (submatch (+ digit)) " " (submatch (+ digit)))
	      (set! *record-num* (+fx 1 *record-num*))
	      (let ((record (instantiate::record
			       (pc   pc)
			       (num  (integer->string *record-num*))
			       (ppid (the-submatch 1))
			       (cpid (the-submatch 2)))))
		 (print record)
		 (set! *record* (cons record *record*))))
	     (else
	      (print "record-command: error: [" res "]")))))
      (else
       (gdb-echo (string-append "A parse error in expression, near `"
				line
				#"'.\n")))))
   
;*---------------------------------------------------------------------*/
;*    *record-num* ...                                                 */
;*---------------------------------------------------------------------*/
(define *record-num* 0)

;*---------------------------------------------------------------------*/
;*    *record* ...                                                     */
;*---------------------------------------------------------------------*/
(define *record* '())

;*---------------------------------------------------------------------*/
;*    bdb-find-record ...                                              */
;*---------------------------------------------------------------------*/
(define (find-record num)
   (if (and (pair? *record*) (not (string? num)))
       (car *record*)
       (let loop ((record *record*))
	  (print "record: " record)
	  (cond
	     ((null? record)
	      #f)
	     ((string=? (record-num (car record)) num)
	      (cdr record))
	     (else
	      (loop (cdr record)))))))

