;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/parse.scm                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  8 14:34:04 1998                          */
;*    Last change :  Fri Oct 16 08:55:21 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module implements the command parser.                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_parse
   (import engine_param
	   command_bvariables
	   command_blocals
	   command_bbreak
	   command_bmodule
	   command_completion
	   command_command)
   (extern (read-cmd-line::obj (::string) "read_cmd_line"))
   (export (parse-input-line::input ::bstring)
	   ;; the data constructors that are used for the result of
	   ;; parse command.
	   (class input
	      (string::bstring read-only))
	   (class bigloo-input::input)
	   (class gdb-input::input)
	   (class bdb-input::input
	      (line-list::pair read-only)
	      (command::command read-only))))

;*---------------------------------------------------------------------*/
;*    parse-input-line ...                                             */
;*    -------------------------------------------------------------    */
;*    There are two kinds of command. The gdb commands and the         */
;*    bdb commands. The second one are recognized because the first    */
;*    char is an open parenthesis.                                     */
;*---------------------------------------------------------------------*/
(define (parse-input-line cmd-line)
   (cond
      ((and (>fx (string-length cmd-line) 0)
	    (case (string-ref cmd-line 0)
	       ((#\( #\' #\`) #t)
	       (else #f)))
       ;; this is a bdb command
       (parse-bigloo-command cmd-line))
      (else
       ;; this is a gdb command
       (parse-gdb-command cmd-line))))

;*---------------------------------------------------------------------*/
;*    parse-gdb-command ...                                            */
;*---------------------------------------------------------------------*/
(define (parse-gdb-command cmd-line)
   (multiple-value-bind (cmd cmd-list)
      (find-command cmd-line)
      (if (command? cmd)
	  (instantiate::bdb-input
	     (string cmd-line)
	     (line-list cmd-list)
	     (command cmd))
	  (instantiate::gdb-input
	     (string cmd-line)))))

;*---------------------------------------------------------------------*/
;*    parse-bigloo-command ...                                         */
;*    -------------------------------------------------------------    */
;*    bdb command are difficult to be parsed because they may be       */
;*    splitted in several lines. We have to check if we are in         */
;*    such a situation. If so, we have to re-call the reader until     */
;*    we find the end of bdb input.                                    */
;*---------------------------------------------------------------------*/
(define (parse-bigloo-command cmd-line)
   (let ((p (open-input-string cmd-line)))
      (try (unwind-protect
	      (let* ((exp (read p))
		     (eof (read p)))
		 (if (not (eof-object? eof))
		     ;; this is an error too much input
		     (warning *bdb-name* "Too much input (ignored) -- " eof))
		 ;; we read the expression
		 (instantiate::bigloo-input
		    (string cmd-line)))
	      (close-input-port p))
	   (lambda (escape proc obj msg)
	      ;; we reach that point on unterminated inputs.
	      ;; We thus have to read more.
	      (let ((new (read-cmd-line *bdb-prompt*)))
		 (escape (parse-bigloo-command
			  (string-append cmd-line new))))))))
   
   



	   
   
