;*---------------------------------------------------------------------*/
;*   A pratical implementation for the Scheme programming language     */
;*                                                                     */
;*                                    ,--^,                            */
;*                              _ ___/ /|/                             */
;*                          ,;'( )__, ) '                              */
;*                         ;;  //   L__.                               */
;*                         '   \\   /  '                               */
;*                              ^   ^                                  */
;*                                                                     */
;*   Copyright (c) 1992-1999 Manuel Serrano                            */
;*                                                                     */
;*     Bug descriptions, use reports, comments or suggestions are      */
;*     welcome. Send them to                                           */
;*       bigloo-request@kaolin.unice.fr                                */
;*       http://kaolin.unice.fr/bigloo                                 */
;*                                                                     */
;*   This program is free software; you can redistribute it            */
;*   and/or modify it under the terms of the GNU General Public        */
;*   License as published by the Free Software Foundation; either      */
;*   version 2 of the License, or (at your option) any later version.  */
;*                                                                     */
;*   This program is distributed in the hope that it will be useful,   */
;*   but WITHOUT ANY WARRANTY; without even the implied warranty of    */
;*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
;*   GNU General Public License for more details.                      */
;*                                                                     */
;*   You should have received a copy of the GNU General Public         */
;*   License along with this program; if not, write to the Free        */
;*   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,   */
;*   MA 02111-1307, USA.                                               */
;*---------------------------------------------------------------------*/
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bdb/Command/help.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Apr 12 16:33:20 1998                          */
;*    Last change :  Tue Jun 30 10:59:37 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The help for command.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module command_help
   (import engine_engine
	   tools_echo
	   command_command)
   (export (binfo-help-command line line-list)
	   (info-help-command line line-list)
	   (help-command ::bstring ::obj)))
 
;*---------------------------------------------------------------------*/
;*    binfo-help-command ...                                           */
;*---------------------------------------------------------------------*/
(define (binfo-help-command line line-list)
   (let ((cmd (find-one-command "binfo" (get-command-list))))
      (if (command? cmd)
	  (help-one-command cmd line))))
  
;*---------------------------------------------------------------------*/
;*    info-help-command ...                                            */
;*---------------------------------------------------------------------*/
(define (info-help-command line line-list)
   (gdb-echo (gdb-send-for-output line)))

;*---------------------------------------------------------------------*/
;*    help-command ...                                                 */
;*---------------------------------------------------------------------*/
(define (help-command line line-list)
   (match-case line-list
      ((?-)
       (gdb-echo (gdb-send-for-output "help")))
      ((?- . ?cmd-names)
       (let loop ((cmd-names cmd-names)
		  (cmds      (get-command-list)))
	  (let ((cmd (find-one-command (car cmd-names) cmds)))
	     (if (not (command? cmd))
		 (gdb-echo (gdb-send-for-output line))
		 (if (null? (cdr cmd-names))
		     (help-one-command cmd line)
		     (loop (cdr cmd-names)
			   (command-sub-commands cmd)))))))))

;*---------------------------------------------------------------------*/
;*    help-one-command ...                                             */
;*    -------------------------------------------------------------    */
;*    We have found the command, we display its help and its           */
;*    sub-commands help.                                               */
;*---------------------------------------------------------------------*/
(define (help-one-command cmd line)
   (with-access::command cmd (name sub-commands help)
      (let ((c-name name))
	 (gdb-start-echo)
	 (if (string? help)
	     (print help)
	     (gdb-echo (gdb-send-for-output line)))
	 (if (pair? sub-commands)
	     (begin
		(newline)
		(print "List of " c-name " bdb subcommands:")
		(newline)
		(for-each (lambda (scmd)
			     (with-access::command scmd (name help)
				(if (string? help)
				    (print c-name " " name " -- " help))))
			  sub-commands)))
	 (gdb-stop-echo))))
   

